/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.List;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.WhileStatement;

class CertainBlockCountVisitor
implements StatementVisitor {
    private BlockStatement blockToCount;
    private int count;

    public CertainBlockCountVisitor(BlockStatement blockToCount) {
        this.blockToCount = blockToCount;
    }

    public int getCount() {
        return this.count;
    }

    public void visit(List<Statement> statements) {
        if (statements == null) {
            return;
        }
        for (Statement part : statements) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(AssignmentStatement statement) {
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visit(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.visit(statement.getConsequent());
        this.visit(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        for (SwitchClause clause : statement.getClauses()) {
            this.visit(clause.getBody());
        }
        this.visit(statement.getDefaultClause());
    }

    @Override
    public void visit(WhileStatement statement) {
        this.visit(statement.getBody());
    }

    @Override
    public void visit(BlockStatement statement) {
        this.visit(statement.getBody());
    }

    @Override
    public void visit(BreakStatement statement) {
        if (statement.getTarget() == this.blockToCount) {
            ++this.count;
        }
    }

    @Override
    public void visit(ContinueStatement statement) {
        if (statement.getTarget() == this.blockToCount) {
            ++this.count;
        }
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.visit(statement.getProtectedBody());
        this.visit(statement.getHandler());
    }
}

