/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.List;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.IdentifiedStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.WhileStatement;

class BreakToContinueReplacer
implements StatementVisitor {
    private IdentifiedStatement replacedBreak;
    private IdentifiedStatement replacement;
    private ContinueStatement replaceBy;

    public BreakToContinueReplacer(IdentifiedStatement replacedBreak, IdentifiedStatement replacement) {
        this.replacedBreak = replacedBreak;
        this.replacement = replacement;
    }

    @Override
    public void visit(AssignmentStatement statement) {
    }

    public void visitSequence(List<Statement> statements) {
        if (statements == null) {
            return;
        }
        for (int i = 0; i < statements.size(); ++i) {
            Statement stmt = statements.get(i);
            stmt.acceptVisitor(this);
            if (this.replaceBy == null) continue;
            statements.set(i, this.replaceBy);
            this.replaceBy = null;
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visitSequence(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.visitSequence(statement.getConsequent());
        this.visitSequence(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        for (SwitchClause clause : statement.getClauses()) {
            this.visitSequence(clause.getBody());
        }
        this.visitSequence(statement.getDefaultClause());
    }

    @Override
    public void visit(WhileStatement statement) {
        this.visitSequence(statement.getBody());
    }

    @Override
    public void visit(BlockStatement statement) {
        this.visitSequence(statement.getBody());
    }

    @Override
    public void visit(BreakStatement statement) {
        if (statement.getTarget() == this.replacedBreak) {
            this.replaceBy = new ContinueStatement();
            this.replaceBy.setTarget(this.replacement);
            this.replaceBy.setLocation(statement.getLocation());
        }
    }

    @Override
    public void visit(ContinueStatement statement) {
        if (statement.getTarget() == this.replacedBreak) {
            statement.setTarget(this.replacement);
        }
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.visitSequence(statement.getProtectedBody());
        this.visitSequence(statement.getHandler());
    }
}

