/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.teavm.dependency.ClassDependencyInfo;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.FieldDependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;

public class DependencyViolations {
    private final Set<MethodDependencyInfo> missingMethods;
    private final Set<ClassDependencyInfo> missingClasses;
    private final Set<FieldDependencyInfo> missingFields;

    DependencyViolations(Collection<? extends MethodDependencyInfo> missingMethods, Collection<? extends ClassDependencyInfo> missingClasses, Collection<? extends FieldDependencyInfo> missingFields) {
        this.missingMethods = Collections.unmodifiableSet(new HashSet<MethodDependencyInfo>(missingMethods));
        this.missingClasses = Collections.unmodifiableSet(new HashSet<ClassDependencyInfo>(missingClasses));
        this.missingFields = Collections.unmodifiableSet(new HashSet<FieldDependencyInfo>(missingFields));
    }

    public Set<MethodDependencyInfo> getMissingMethods() {
        return this.missingMethods;
    }

    public Set<ClassDependencyInfo> getMissingClasses() {
        return this.missingClasses;
    }

    public Set<FieldDependencyInfo> getMissingFields() {
        return this.missingFields;
    }

    public boolean hasMissingItems() {
        return !this.missingMethods.isEmpty() || !this.missingClasses.isEmpty() || !this.missingFields.isEmpty();
    }

    public void checkForMissingItems() {
        if (!this.hasMissingItems()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try {
            this.showMissingItems(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"StringBuilder should not throw IOException");
        }
        throw new IllegalStateException(sb.toString());
    }

    public void showMissingItems(Appendable sb) throws IOException {
        ArrayList<String> items = new ArrayList<String>();
        HashMap<String, DependencyStack> stackMap = new HashMap<String, DependencyStack>();
        for (ClassDependencyInfo cls : this.missingClasses) {
            stackMap.put(cls.getClassName(), cls.getStack());
            items.add(cls.getClassName());
        }
        for (MethodDependencyInfo method : this.missingMethods) {
            stackMap.put(method.getReference().toString(), method.getStack());
            items.add(method.getReference().toString());
        }
        for (FieldDependencyInfo field : this.missingFields) {
            stackMap.put(field.getReference().toString(), field.getStack());
            items.add(field.getReference().toString());
        }
        Collections.sort(items);
        sb.append("Can't compile due to the following items missing:\n");
        for (String item : items) {
            sb.append("  ").append(item).append("\n");
            DependencyStack stack = (DependencyStack)stackMap.get(item);
            if (stack == null) {
                sb.append("    at unknown location\n");
            } else {
                while (stack.getMethod() != null) {
                    sb.append("    at ").append(stack.getMethod().toString());
                    if (stack.getLocation() != null) {
                        sb.append(":").append(String.valueOf(stack.getLocation().getLine()));
                    }
                    sb.append("\n");
                    stack = stack.getCause();
                }
            }
            sb.append('\n');
        }
    }
}

