/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.teavm.common.CachedMapper;
import org.teavm.common.Mapper;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.util.ModelUtils;

class DependencyClassSource
implements ClassReaderSource {
    private ClassReaderSource innerSource;
    private ConcurrentMap<String, ClassHolder> generatedClasses = new ConcurrentHashMap<String, ClassHolder>();
    private List<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
    private CachedMapper<String, ClassReader> cache = new CachedMapper<String, ClassReader>(new Mapper<String, ClassReader>(){

        @Override
        public ClassReader map(String preimage) {
            return DependencyClassSource.this.findAndTransformClass(preimage);
        }
    });

    public DependencyClassSource(ClassReaderSource innerSource) {
        this.innerSource = innerSource;
    }

    @Override
    public ClassReader get(String name) {
        return this.cache.map(name);
    }

    public void submit(ClassHolder cls) {
        if (this.innerSource.get(cls.getName()) != null) {
            throw new IllegalArgumentException("Class " + cls.getName() + " is already defined");
        }
        if (this.generatedClasses.putIfAbsent(cls.getName(), cls) != null) {
            throw new IllegalArgumentException("Class " + cls.getName() + " is already defined");
        }
    }

    private ClassReader findAndTransformClass(String name) {
        ClassHolder cls = this.findClass(name);
        if (cls != null && !this.transformers.isEmpty()) {
            for (ClassHolderTransformer transformer : this.transformers) {
                transformer.transformClass(cls, this.innerSource);
            }
            cls = ModelUtils.copyClass(cls);
        }
        return cls;
    }

    private ClassHolder findClass(String name) {
        ClassReader cls = this.innerSource.get(name);
        if (cls != null) {
            return ModelUtils.copyClass(cls);
        }
        return (ClassHolder)this.generatedClasses.get(name);
    }

    public Collection<ClassHolder> getGeneratedClasses() {
        return this.generatedClasses.values();
    }

    public void addTransformer(ClassHolderTransformer transformer) {
        this.transformers.add(transformer);
    }
}

