/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.teavm.common.CachedMapper;
import org.teavm.common.Mapper;
import org.teavm.common.ServiceRepository;
import org.teavm.dependency.ClassDependency;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyCheckerInterruptor;
import org.teavm.dependency.DependencyClassSource;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyGraphBuilder;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.DependencyViolations;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.PluggableDependency;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.util.ModelUtils;

public class DependencyChecker
implements DependencyInfo,
DependencyAgent {
    static final boolean shouldLog = System.getProperty("org.teavm.logDependencies", "false").equals("true");
    private int classNameSuffix;
    private DependencyClassSource classSource;
    private ClassLoader classLoader;
    private Mapper<MethodReference, MethodReader> methodReaderCache;
    private Mapper<FieldReference, FieldReader> fieldReaderCache;
    private Map<MethodReference, DependencyStack> stacks = new HashMap<MethodReference, DependencyStack>();
    private Map<FieldReference, DependencyStack> fieldStacks = new HashMap<FieldReference, DependencyStack>();
    private Map<String, DependencyStack> classStacks = new HashMap<String, DependencyStack>();
    private CachedMapper<MethodReference, MethodDependency> methodCache;
    private CachedMapper<FieldReference, FieldDependency> fieldCache;
    private CachedMapper<String, ClassDependency> classCache;
    private List<DependencyListener> listeners = new ArrayList<DependencyListener>();
    private ServiceRepository services;
    private Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    Set<MethodDependency> missingMethods = new HashSet<MethodDependency>();
    Set<ClassDependency> missingClasses = new HashSet<ClassDependency>();
    Set<FieldDependency> missingFields = new HashSet<FieldDependency>();
    List<DependencyType> types = new ArrayList<DependencyType>();
    Map<String, DependencyType> typeMap = new HashMap<String, DependencyType>();
    private DependencyViolations dependencyViolations;
    private DependencyCheckerInterruptor interruptor;
    private boolean interrupted;

    public DependencyChecker(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services) {
        this.classSource = new DependencyClassSource(classSource);
        this.classLoader = classLoader;
        this.services = services;
        this.methodReaderCache = new CachedMapper<MethodReference, MethodReader>(new Mapper<MethodReference, MethodReader>(){

            @Override
            public MethodReader map(MethodReference preimage) {
                return DependencyChecker.this.findMethodReader(preimage);
            }
        });
        this.fieldReaderCache = new CachedMapper<FieldReference, FieldReader>(new Mapper<FieldReference, FieldReader>(){

            @Override
            public FieldReader map(FieldReference preimage) {
                return DependencyChecker.this.findFieldReader(preimage);
            }
        });
        this.methodCache = new CachedMapper<MethodReference, MethodDependency>(new Mapper<MethodReference, MethodDependency>(){

            @Override
            public MethodDependency map(MethodReference preimage) {
                MethodReader method = (MethodReader)DependencyChecker.this.methodReaderCache.map(preimage);
                if (method != null && !method.getReference().equals(preimage)) {
                    DependencyChecker.this.stacks.put(method.getReference(), DependencyChecker.this.stacks.get(preimage));
                    return (MethodDependency)DependencyChecker.this.methodCache.map(method.getReference());
                }
                return DependencyChecker.this.createMethodDep(preimage, method, (DependencyStack)DependencyChecker.this.stacks.get(preimage));
            }
        });
        this.fieldCache = new CachedMapper<FieldReference, FieldDependency>(new Mapper<FieldReference, FieldDependency>(){

            @Override
            public FieldDependency map(FieldReference preimage) {
                FieldReader field = (FieldReader)DependencyChecker.this.fieldReaderCache.map(preimage);
                if (field != null && !field.getReference().equals(preimage)) {
                    DependencyChecker.this.fieldStacks.put(field.getReference(), DependencyChecker.this.fieldStacks.get(preimage));
                    return (FieldDependency)DependencyChecker.this.fieldCache.map(field.getReference());
                }
                return DependencyChecker.this.createFieldNode(preimage, field, (DependencyStack)DependencyChecker.this.fieldStacks.get(preimage));
            }
        });
        this.classCache = new CachedMapper<String, ClassDependency>(new Mapper<String, ClassDependency>(){

            @Override
            public ClassDependency map(String preimage) {
                return DependencyChecker.this.createClassDependency(preimage, (DependencyStack)DependencyChecker.this.classStacks.get(preimage));
            }
        });
        this.methodCache.addKeyListener(new CachedMapper.KeyListener<MethodReference>(){

            @Override
            public void keyAdded(MethodReference key) {
                MethodDependency graph = (MethodDependency)DependencyChecker.this.methodCache.getKnown(key);
                if (!graph.isMissing()) {
                    for (DependencyListener listener : DependencyChecker.this.listeners) {
                        listener.methodAchieved(DependencyChecker.this, graph);
                    }
                    DependencyChecker.this.activateDependencyPlugin(graph);
                }
            }
        });
        this.fieldCache.addKeyListener(new CachedMapper.KeyListener<FieldReference>(){

            @Override
            public void keyAdded(FieldReference key) {
                FieldDependency fieldDep = (FieldDependency)DependencyChecker.this.fieldCache.getKnown(key);
                if (!fieldDep.isMissing()) {
                    for (DependencyListener listener : DependencyChecker.this.listeners) {
                        listener.fieldAchieved(DependencyChecker.this, fieldDep);
                    }
                }
            }
        });
        this.classCache.addKeyListener(new CachedMapper.KeyListener<String>(){

            @Override
            public void keyAdded(String key) {
                ClassDependency classDep = (ClassDependency)DependencyChecker.this.classCache.getKnown(key);
                if (!classDep.isMissing()) {
                    for (DependencyListener listener : DependencyChecker.this.listeners) {
                        listener.classAchieved(DependencyChecker.this, key);
                    }
                }
            }
        });
    }

    public DependencyCheckerInterruptor getInterruptor() {
        return this.interruptor;
    }

    public void setInterruptor(DependencyCheckerInterruptor interruptor) {
        this.interruptor = interruptor;
    }

    public boolean wasInterrupted() {
        return this.interrupted;
    }

    @Override
    public DependencyType getType(String name) {
        DependencyType type = this.typeMap.get(name);
        if (type == null) {
            type = new DependencyType(this, name, this.types.size());
            this.types.add(type);
            this.typeMap.put(name, type);
        }
        return type;
    }

    @Override
    public DependencyNode createNode() {
        return new DependencyNode(this);
    }

    @Override
    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String generateClassName() {
        return "$$tmp$$.TempClass" + this.classNameSuffix++;
    }

    @Override
    public void submitClass(ClassHolder cls) {
        this.classSource.submit(ModelUtils.copyClass(cls));
    }

    public void addDependencyListener(DependencyListener listener) {
        this.listeners.add(listener);
        listener.started(this);
    }

    public void addClassTransformer(ClassHolderTransformer transformer) {
        this.classSource.addTransformer(transformer);
    }

    public void addEntryPoint(MethodReference methodRef, String ... argumentTypes) {
        ValueType[] parameters = methodRef.getDescriptor().getParameterTypes();
        if (parameters.length + 1 != argumentTypes.length) {
            throw new IllegalArgumentException("argumentTypes length does not match the number of method's arguments");
        }
        MethodDependency method = this.linkMethod(methodRef, DependencyStack.ROOT);
        method.use();
        DependencyNode[] varNodes = method.getVariables();
        varNodes[0].propagate(this.getType(methodRef.getClassName()));
        for (int i = 0; i < argumentTypes.length; ++i) {
            varNodes[i + 1].propagate(this.getType(argumentTypes[i]));
        }
    }

    void schedulePropagation(final DependencyConsumer consumer, final DependencyType type) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                consumer.consume(type);
            }
        });
    }

    void schedulePropagation(final DependencyConsumer consumer, final DependencyType[] types) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                for (DependencyType type : types) {
                    consumer.consume(type);
                }
            }
        });
    }

    @Override
    public ClassDependency linkClass(String className, DependencyStack stack) {
        this.classStacks.put(className, stack);
        return this.classCache.map(className);
    }

    private ClassDependency createClassDependency(String className, DependencyStack stack) {
        ClassReader cls = this.classSource.get(className);
        ClassDependency dependency = new ClassDependency(this, className, stack, cls);
        if (dependency.isMissing()) {
            this.missingClasses.add(dependency);
        } else {
            if (cls.getParent() != null) {
                this.linkClass(cls.getParent(), stack);
            }
            for (String ifaceName : cls.getInterfaces()) {
                this.linkClass(ifaceName, stack);
            }
        }
        return dependency;
    }

    @Override
    public MethodDependency linkMethod(MethodReference methodRef, DependencyStack stack) {
        if (methodRef == null) {
            throw new IllegalArgumentException();
        }
        this.stacks.put(methodRef, stack);
        return this.methodCache.map(methodRef);
    }

    void initClass(ClassDependency cls, final DependencyStack stack) {
        ClassReader reader = cls.getClassReader();
        final MethodReader method = reader.getMethod(new MethodDescriptor("<clinit>", Void.TYPE));
        if (method != null) {
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    DependencyChecker.this.linkMethod(method.getReference(), stack).use();
                }
            });
        }
    }

    private MethodReader findMethodReader(MethodReference methodRef) {
        String clsName = methodRef.getClassName();
        MethodDescriptor desc = methodRef.getDescriptor();
        ClassReader cls = this.classSource.get(clsName);
        if (cls == null) {
            return null;
        }
        MethodReader reader = cls.getMethod(desc);
        if (reader != null) {
            return reader;
        }
        if (cls.getParent() != null && (reader = this.methodReaderCache.map(new MethodReference(cls.getParent(), desc))) != null) {
            return reader;
        }
        for (String ifaceName : cls.getInterfaces()) {
            reader = this.methodReaderCache.map(new MethodReference(ifaceName, desc));
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    private FieldReader findFieldReader(FieldReference fieldRef) {
        String clsName = fieldRef.getClassName();
        String name = fieldRef.getFieldName();
        while (clsName != null) {
            ClassReader cls = this.classSource.get(clsName);
            if (cls == null) {
                return null;
            }
            FieldReader field = cls.getField(name);
            if (field != null) {
                return field;
            }
            clsName = cls.getParent();
        }
        return null;
    }

    private MethodDependency createMethodDep(MethodReference methodRef, MethodReader method, DependencyStack stack) {
        DependencyNode resultNode;
        if (stack == null) {
            stack = DependencyStack.ROOT;
        }
        ValueType[] arguments = methodRef.getParameterTypes();
        int paramCount = arguments.length + 1;
        int varCount = Math.max(paramCount, method != null && method.getProgram() != null ? method.getProgram().variableCount() : 0);
        DependencyNode[] parameterNodes = new DependencyNode[varCount];
        for (int i = 0; i < varCount; ++i) {
            parameterNodes[i] = new DependencyNode(this);
            if (!shouldLog) continue;
            parameterNodes[i].setTag(methodRef + ":" + i);
        }
        if (methodRef.getDescriptor().getResultType() == ValueType.VOID) {
            resultNode = null;
        } else {
            resultNode = new DependencyNode(this);
            if (shouldLog) {
                resultNode.setTag(methodRef + ":RESULT");
            }
        }
        DependencyNode thrown = this.createNode();
        if (shouldLog) {
            thrown.setTag(methodRef + ":THROWN");
        }
        final MethodDependency dep = new MethodDependency(this, parameterNodes, paramCount, resultNode, thrown, stack, method, methodRef);
        if (method != null) {
            final DependencyStack initClassStack = stack;
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    DependencyChecker.this.linkClass(dep.getMethod().getOwnerName(), dep.getStack()).initClass(initClassStack);
                }
            });
        } else {
            this.missingMethods.add(dep);
        }
        return dep;
    }

    void scheduleMethodAnalysis(final MethodDependency dep) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                DependencyGraphBuilder graphBuilder = new DependencyGraphBuilder(DependencyChecker.this);
                graphBuilder.buildGraph(dep);
            }
        });
    }

    @Override
    public Collection<MethodReference> getAchievableMethods() {
        return this.methodCache.getCachedPreimages();
    }

    @Override
    public Collection<FieldReference> getAchievableFields() {
        return this.fieldCache.getCachedPreimages();
    }

    @Override
    public Collection<String> getAchievableClasses() {
        return this.classCache.getCachedPreimages();
    }

    @Override
    public FieldDependency linkField(FieldReference fieldRef, DependencyStack stack) {
        this.fieldStacks.put(fieldRef, stack);
        return this.fieldCache.map(fieldRef);
    }

    @Override
    public FieldDependency getField(FieldReference fieldRef) {
        return this.fieldCache.getKnown(fieldRef);
    }

    @Override
    public ClassDependency getClass(String className) {
        return this.classCache.getKnown(className);
    }

    private FieldDependency createFieldNode(final FieldReference fieldRef, FieldReader field, final DependencyStack stack) {
        FieldDependency dep;
        DependencyNode node = new DependencyNode(this);
        if (shouldLog) {
            node.setTag(fieldRef.getClassName() + "#" + fieldRef.getFieldName());
        }
        if ((dep = new FieldDependency(node, stack, field, fieldRef)).isMissing()) {
            this.missingFields.add(dep);
        } else {
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    DependencyChecker.this.linkClass(fieldRef.getClassName(), stack).initClass(stack);
                }
            });
        }
        return dep;
    }

    private void activateDependencyPlugin(MethodDependency methodDep) {
        DependencyPlugin plugin;
        Class<?> depClass;
        AnnotationReader depAnnot = methodDep.getMethod().getAnnotations().get(PluggableDependency.class.getName());
        if (depAnnot == null) {
            return;
        }
        ValueType depType = depAnnot.getValue("value").getJavaClass();
        String depClassName = ((ValueType.Object)depType).getClassName();
        try {
            depClass = Class.forName(depClassName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dependency plugin not found: " + depClassName, e);
        }
        try {
            plugin = (DependencyPlugin)depClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Can't instantiate dependency plugin " + depClassName, e);
        }
        plugin.methodAchieved(this, methodDep);
    }

    @Override
    public MethodDependency getMethod(MethodReference methodRef) {
        return this.methodCache.getKnown(methodRef);
    }

    public DependencyViolations getDependencyViolations() {
        if (this.dependencyViolations == null) {
            this.dependencyViolations = new DependencyViolations(this.missingMethods, this.missingClasses, this.missingFields);
        }
        return this.dependencyViolations;
    }

    public void checkForMissingItems() {
        this.getDependencyViolations().checkForMissingItems();
    }

    public boolean hasMissingItems() {
        return this.getDependencyViolations().hasMissingItems();
    }

    public void showMissingItems(Appendable sb) throws IOException {
        this.getDependencyViolations().showMissingItems(sb);
    }

    public void processDependencies() {
        this.interrupted = false;
        int index = 0;
        while (!this.tasks.isEmpty()) {
            this.tasks.poll().run();
            if (++index != 100) continue;
            if (this.interruptor != null && !this.interruptor.shouldContinue()) {
                this.interrupted = true;
                break;
            }
            index = 0;
        }
    }

    @Override
    public <T> T getService(Class<T> type) {
        return this.services.getService(type);
    }
}

