/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.teavm.common.MutableGraphEdge;

public class MutableGraphNode {
    int tag;
    Map<MutableGraphNode, MutableGraphEdge> edges = new HashMap<MutableGraphNode, MutableGraphEdge>();

    public MutableGraphNode(int tag) {
        this.tag = tag;
    }

    public MutableGraphEdge connect(MutableGraphNode other) {
        MutableGraphEdge edge = this.edges.get(other);
        if (edge == null) {
            edge = new MutableGraphEdge();
            edge.first = this;
            edge.second = other;
            this.edges.put(other, edge);
            MutableGraphEdge back = new MutableGraphEdge();
            back.first = other;
            back.second = this;
            back.back = edge;
            edge.back = back;
            other.edges.put(this, back);
        }
        return edge;
    }

    public void connectAll(Collection<MutableGraphNode> nodes) {
        for (MutableGraphNode node : nodes) {
            this.connect(node);
        }
    }

    public Collection<MutableGraphEdge> getEdges() {
        return this.edges.values();
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tag).append(":");
        Iterator<MutableGraphEdge> edges = this.edges.values().iterator();
        if (edges.hasNext()) {
            sb.append(edges.next().getSecond().getTag());
        }
        while (edges.hasNext()) {
            sb.append(',').append(edges.next().getSecond().getTag());
        }
        return sb.toString();
    }
}

