/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

public class LCATree {
    private int[] depths;
    private int[][] pathsToRoot;
    private int sz;

    public LCATree(int capacity) {
        this.depths = new int[capacity];
        this.pathsToRoot = new int[capacity][];
        this.sz = 1;
        this.depths[0] = 0;
        this.pathsToRoot[0] = new int[0];
    }

    public int size() {
        return this.sz;
    }

    public int addNode(int parent) {
        int depth;
        int node = this.sz++;
        this.depths[node] = depth = this.depths[parent] + 1;
        int h = 0;
        while (depth > 0) {
            depth /= 2;
            ++h;
        }
        int[] path = new int[h];
        this.pathsToRoot[node] = path;
        path[0] = parent;
        for (int i = 1; i < h; ++i) {
            path[i] = parent = this.pathsToRoot[parent][i - 1];
        }
        return node;
    }

    public int parentOf(int node) {
        int[] path = this.pathsToRoot[node];
        return path.length > 0 ? path[0] : -1;
    }

    public int lcaOf(int a, int b) {
        int i;
        if (a == b) {
            return a;
        }
        if (this.depths[a] < this.depths[b]) {
            int t = a;
            a = b;
            b = t;
        }
        if (this.depths[a] != this.depths[b]) {
            int diff;
            int h = this.depths[a] - this.depths[b];
            int diffln = 0;
            for (diff = 1; diff <= h; diff *= 2) {
                ++diffln;
            }
            --diffln;
            diff /= 2;
            while (h > 0) {
                h -= diff;
                a = this.pathsToRoot[a][diffln];
                while (diff > h) {
                    diff /= 2;
                    --diffln;
                }
            }
        }
        if (a == b) {
            return a;
        }
        do {
            int q;
            int p;
            int len = Math.min(this.pathsToRoot[a].length, this.pathsToRoot[b].length);
            for (i = 0; i < len && (p = this.pathsToRoot[a][i]) != (q = this.pathsToRoot[b][i]); ++i) {
            }
            if (--i >= 0) continue;
            return this.pathsToRoot[a][0];
        } while ((a = this.pathsToRoot[a][i]) != (b = this.pathsToRoot[b][i]));
        return a;
    }
}

