/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.cache.SymbolTable;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BinaryExpr;
import org.teavm.javascript.ast.BinaryOperation;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalExpr;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ConstantExpr;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.ExprVisitor;
import org.teavm.javascript.ast.IdentifiedStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.InstanceOfExpr;
import org.teavm.javascript.ast.InvocationExpr;
import org.teavm.javascript.ast.InvocationType;
import org.teavm.javascript.ast.NewArrayExpr;
import org.teavm.javascript.ast.NewExpr;
import org.teavm.javascript.ast.NewMultiArrayExpr;
import org.teavm.javascript.ast.NodeLocation;
import org.teavm.javascript.ast.NodeModifier;
import org.teavm.javascript.ast.QualificationExpr;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.StaticClassExpr;
import org.teavm.javascript.ast.SubscriptExpr;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.UnaryExpr;
import org.teavm.javascript.ast.UnaryOperation;
import org.teavm.javascript.ast.UnwrapArrayExpr;
import org.teavm.javascript.ast.VariableExpr;
import org.teavm.javascript.ast.WhileStatement;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.instructions.ArrayElementType;

public class AstIO {
    private static NodeModifier[] nodeModifiers = NodeModifier.values();
    private static BinaryOperation[] binaryOperations = BinaryOperation.values();
    private static UnaryOperation[] unaryOperations = UnaryOperation.values();
    private static ArrayElementType[] arrayElementTypes = ArrayElementType.values();
    private SymbolTable symbolTable;
    private SymbolTable fileTable;
    private Map<String, IdentifiedStatement> statementMap = new HashMap<String, IdentifiedStatement>();

    public AstIO(SymbolTable symbolTable, SymbolTable fileTable) {
        this.symbolTable = symbolTable;
        this.fileTable = fileTable;
    }

    public void write(DataOutput output, RegularMethodNode method) throws IOException {
        output.writeInt(this.packModifiers(method.getModifiers()));
        output.writeShort(method.getVariables().size());
        Iterator<Object> i$ = method.getVariables().iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            output.writeShort(n);
        }
        output.writeShort(method.getParameterDebugNames().size());
        for (Set set : method.getParameterDebugNames()) {
            output.writeShort(set != null ? set.size() : 0);
            for (String debugName : set) {
                output.writeUTF(debugName);
            }
        }
        output.writeBoolean(method.isOriginalNamePreserved());
        try {
            method.getBody().acceptVisitor(new NodeWriter(output));
        }
        catch (IOExceptionWrapper e) {
            throw new IOException("Error writing method body", e.getCause());
        }
    }

    public RegularMethodNode read(DataInput input, MethodReference method) throws IOException {
        RegularMethodNode node = new RegularMethodNode(method);
        node.getModifiers().addAll(this.unpackModifiers(input.readInt()));
        int varCount = input.readShort();
        for (int i = 0; i < varCount; ++i) {
            node.getVariables().add(Integer.valueOf(input.readShort()));
        }
        int paramDebugNameCount = input.readShort();
        for (int i = 0; i < paramDebugNameCount; ++i) {
            int debugNameCount = input.readShort();
            HashSet<String> debugNames = new HashSet<String>();
            for (int j = 0; j < debugNameCount; ++j) {
                debugNames.add(input.readUTF());
            }
            node.getParameterDebugNames().add(debugNames);
        }
        node.setOriginalNamePreserved(input.readBoolean());
        node.setBody(this.readStatement(input));
        return node;
    }

    private int packModifiers(Set<NodeModifier> modifiers) {
        int packed = 0;
        for (NodeModifier modifier : modifiers) {
            packed |= 1 << modifier.ordinal();
        }
        return packed;
    }

    private Set<NodeModifier> unpackModifiers(int packed) {
        EnumSet<NodeModifier> modifiers = EnumSet.noneOf(NodeModifier.class);
        while (packed != 0) {
            int shift = Integer.numberOfTrailingZeros(packed);
            modifiers.add(nodeModifiers[shift]);
            packed ^= 1 << shift;
        }
        return modifiers;
    }

    private NodeLocation readLocation(DataInput input) throws IOException {
        short fileIndex = input.readShort();
        if (fileIndex == -1) {
            return null;
        }
        return new NodeLocation(this.fileTable.at(fileIndex), input.readShort());
    }

    private Statement readStatement(DataInput input) throws IOException {
        byte type = input.readByte();
        switch (type) {
            case 0: {
                AssignmentStatement stmt = new AssignmentStatement();
                stmt.setLocation(this.readLocation(input));
                int debugNameCount = input.readShort();
                for (int i = 0; i < debugNameCount; ++i) {
                    stmt.getDebugNames().add(input.readUTF());
                }
                stmt.setLeftValue(this.readExpr(input));
                stmt.setRightValue(this.readExpr(input));
                return stmt;
            }
            case 1: {
                AssignmentStatement stmt = new AssignmentStatement();
                stmt.setLocation(this.readLocation(input));
                int debugNameCount = input.readShort();
                for (int i = 0; i < debugNameCount; ++i) {
                    stmt.getDebugNames().add(input.readUTF());
                }
                stmt.setRightValue(this.readExpr(input));
                return stmt;
            }
            case 2: {
                SequentialStatement stmt = new SequentialStatement();
                this.readSequence(input, stmt.getSequence());
                return stmt;
            }
            case 3: {
                ConditionalStatement stmt = new ConditionalStatement();
                stmt.setCondition(this.readExpr(input));
                this.readSequence(input, stmt.getConsequent());
                this.readSequence(input, stmt.getAlternative());
                return stmt;
            }
            case 4: {
                SwitchStatement stmt = new SwitchStatement();
                stmt.setId(this.readNullableString(input));
                stmt.setValue(this.readExpr(input));
                int clauseCount = input.readShort();
                for (int i = 0; i < clauseCount; ++i) {
                    SwitchClause clause = new SwitchClause();
                    int conditionCount = input.readShort();
                    int[] conditions = new int[conditionCount];
                    for (int j = 0; j < conditionCount; ++j) {
                        conditions[j] = input.readInt();
                    }
                    clause.setConditions(conditions);
                    this.readSequence(input, clause.getBody());
                    stmt.getClauses().add(clause);
                }
                this.readSequence(input, stmt.getDefaultClause());
                return stmt;
            }
            case 5: {
                WhileStatement stmt = new WhileStatement();
                stmt.setId(this.readNullableString(input));
                stmt.setCondition(this.readExpr(input));
                if (stmt.getId() != null) {
                    this.statementMap.put(stmt.getId(), stmt);
                }
                this.readSequence(input, stmt.getBody());
                return stmt;
            }
            case 6: {
                WhileStatement stmt = new WhileStatement();
                stmt.setId(this.readNullableString(input));
                if (stmt.getId() != null) {
                    this.statementMap.put(stmt.getId(), stmt);
                }
                this.readSequence(input, stmt.getBody());
                return stmt;
            }
            case 7: {
                BlockStatement stmt = new BlockStatement();
                stmt.setId(this.readNullableString(input));
                if (stmt.getId() != null) {
                    this.statementMap.put(stmt.getId(), stmt);
                }
                this.readSequence(input, stmt.getBody());
                return stmt;
            }
            case 8: {
                BreakStatement stmt = new BreakStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setTarget(this.statementMap.get(input.readUTF()));
                return stmt;
            }
            case 9: {
                BreakStatement stmt = new BreakStatement();
                stmt.setLocation(this.readLocation(input));
                return stmt;
            }
            case 10: {
                ContinueStatement stmt = new ContinueStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setTarget(this.statementMap.get(input.readUTF()));
                return stmt;
            }
            case 11: {
                ContinueStatement stmt = new ContinueStatement();
                stmt.setLocation(this.readLocation(input));
                return stmt;
            }
            case 12: {
                ReturnStatement stmt = new ReturnStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setResult(this.readExpr(input));
                return stmt;
            }
            case 13: {
                ReturnStatement stmt = new ReturnStatement();
                stmt.setLocation(this.readLocation(input));
                return stmt;
            }
            case 14: {
                ThrowStatement stmt = new ThrowStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setException(this.readExpr(input));
                return stmt;
            }
            case 15: {
                InitClassStatement stmt = new InitClassStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setClassName(this.symbolTable.at(input.readInt()));
                return stmt;
            }
            case 16: {
                short exceptionVarIndex;
                TryCatchStatement stmt = new TryCatchStatement();
                this.readSequence(input, stmt.getProtectedBody());
                int exceptionTypeIndex = input.readInt();
                if (exceptionTypeIndex >= 0) {
                    stmt.setExceptionType(this.symbolTable.at(exceptionTypeIndex));
                }
                if ((exceptionVarIndex = input.readShort()) >= 0) {
                    stmt.setExceptionVariable(Integer.valueOf(exceptionVarIndex));
                }
                this.readSequence(input, stmt.getHandler());
                return stmt;
            }
        }
        throw new RuntimeException("Unexpected statement type: " + type);
    }

    private void readSequence(DataInput input, List<Statement> statements) throws IOException {
        int count = input.readShort();
        for (int i = 0; i < count; ++i) {
            statements.add(this.readStatement(input));
        }
    }

    private String readNullableString(DataInput input) throws IOException {
        return input.readBoolean() ? input.readUTF() : null;
    }

    private Expr readExpr(DataInput input) throws IOException {
        NodeLocation location = this.readLocation(input);
        Expr expr = this.readExprWithoutLocation(input);
        expr.setLocation(location);
        return expr;
    }

    private Expr readExprWithoutLocation(DataInput input) throws IOException {
        byte type = input.readByte();
        switch (type) {
            case 0: {
                BinaryExpr expr = new BinaryExpr();
                expr.setOperation(binaryOperations[input.readByte()]);
                expr.setFirstOperand(this.readExpr(input));
                expr.setSecondOperand(this.readExpr(input));
                return expr;
            }
            case 1: {
                UnaryExpr expr = new UnaryExpr();
                expr.setOperation(unaryOperations[input.readByte()]);
                expr.setOperand(this.readExpr(input));
                return expr;
            }
            case 2: {
                ConditionalExpr expr = new ConditionalExpr();
                expr.setCondition(this.readExpr(input));
                expr.setConsequent(this.readExpr(input));
                expr.setAlternative(this.readExpr(input));
                return expr;
            }
            case 3: {
                ConstantExpr expr = new ConstantExpr();
                return expr;
            }
            case 4: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(input.readInt());
                return expr;
            }
            case 5: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(input.readLong());
                return expr;
            }
            case 6: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(Float.valueOf(input.readFloat()));
                return expr;
            }
            case 7: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(input.readDouble());
                return expr;
            }
            case 8: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(input.readUTF());
                return expr;
            }
            case 9: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(this.symbolTable.at(input.readInt()));
                return expr;
            }
            case 10: {
                VariableExpr expr = new VariableExpr();
                expr.setIndex(input.readShort());
                return expr;
            }
            case 11: {
                SubscriptExpr expr = new SubscriptExpr();
                expr.setArray(this.readExpr(input));
                expr.setIndex(this.readExpr(input));
                return expr;
            }
            case 12: {
                UnwrapArrayExpr expr = new UnwrapArrayExpr(arrayElementTypes[input.readByte()]);
                expr.setArray(this.readExpr(input));
                return expr;
            }
            case 13: {
                return this.parseInvocationExpr(InvocationType.CONSTRUCTOR, input);
            }
            case 14: {
                return this.parseInvocationExpr(InvocationType.STATIC, input);
            }
            case 15: {
                return this.parseInvocationExpr(InvocationType.SPECIAL, input);
            }
            case 16: {
                return this.parseInvocationExpr(InvocationType.DYNAMIC, input);
            }
            case 17: {
                QualificationExpr expr = new QualificationExpr();
                expr.setQualified(this.readExpr(input));
                String className = this.symbolTable.at(input.readInt());
                String fieldName = this.symbolTable.at(input.readInt());
                expr.setField(new FieldReference(className, fieldName));
                return expr;
            }
            case 18: {
                NewExpr expr = new NewExpr();
                expr.setConstructedClass(this.symbolTable.at(input.readInt()));
                return expr;
            }
            case 19: {
                NewArrayExpr expr = new NewArrayExpr();
                expr.setLength(this.readExpr(input));
                expr.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return expr;
            }
            case 20: {
                NewMultiArrayExpr expr = new NewMultiArrayExpr();
                int dimensionCount = input.readByte();
                for (int i = 0; i < dimensionCount; ++i) {
                    expr.getDimensions().add(this.readExpr(input));
                }
                expr.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return expr;
            }
            case 21: {
                InstanceOfExpr expr = new InstanceOfExpr();
                expr.setExpr(this.readExpr(input));
                expr.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return expr;
            }
            case 22: {
                StaticClassExpr expr = new StaticClassExpr();
                expr.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return expr;
            }
        }
        throw new RuntimeException("Unknown expression type: " + type);
    }

    private InvocationExpr parseInvocationExpr(InvocationType invocationType, DataInput input) throws IOException {
        InvocationExpr expr = new InvocationExpr();
        expr.setType(invocationType);
        String className = this.symbolTable.at(input.readInt());
        MethodDescriptor method = MethodDescriptor.parse(this.symbolTable.at(input.readInt()));
        expr.setMethod(new MethodReference(className, method));
        int argCount = input.readShort();
        for (int i = 0; i < argCount; ++i) {
            expr.getArguments().add(this.readExpr(input));
        }
        return expr;
    }

    static class IOExceptionWrapper
    extends RuntimeException {
        private static final long serialVersionUID = -7566355431593608333L;

        public IOExceptionWrapper(Throwable cause) {
            super(cause);
        }
    }

    class NodeWriter
    implements ExprVisitor,
    StatementVisitor {
        private DataOutput output;

        public NodeWriter(DataOutput output) {
            this.output = output;
        }

        public void writeExpr(Expr expr) throws IOException {
            this.writeLocation(expr.getLocation());
            expr.acceptVisitor(this);
        }

        private void writeLocation(NodeLocation location) throws IOException {
            if (location == null || location.getFileName() == null) {
                this.output.writeShort(-1);
            } else {
                this.output.writeShort(AstIO.this.fileTable.lookup(location.getFileName()));
                this.output.writeShort(location.getLine());
            }
        }

        private void writeSequence(List<Statement> sequence) throws IOException {
            this.output.writeShort(sequence.size());
            for (Statement part : sequence) {
                part.acceptVisitor(this);
            }
        }

        private void writeNullableString(String str) throws IOException {
            if (str == null) {
                this.output.writeBoolean(false);
            } else {
                this.output.writeBoolean(true);
                this.output.writeUTF(str);
            }
        }

        @Override
        public void visit(AssignmentStatement statement) {
            try {
                this.output.writeByte(statement.getLeftValue() != null ? 0 : 1);
                this.writeLocation(statement.getLocation());
                this.output.writeShort(statement.getDebugNames().size());
                for (String name : statement.getDebugNames()) {
                    this.output.writeUTF(name);
                }
                if (statement.getLeftValue() != null) {
                    this.writeExpr(statement.getLeftValue());
                }
                this.writeExpr(statement.getRightValue());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(SequentialStatement statement) {
            try {
                this.output.writeByte(2);
                this.writeSequence(statement.getSequence());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConditionalStatement statement) {
            try {
                this.output.writeByte(3);
                this.writeExpr(statement.getCondition());
                this.writeSequence(statement.getConsequent());
                this.writeSequence(statement.getAlternative());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(SwitchStatement statement) {
            try {
                this.output.writeByte(4);
                this.writeNullableString(statement.getId());
                this.writeExpr(statement.getValue());
                this.output.writeShort(statement.getClauses().size());
                for (SwitchClause clause : statement.getClauses()) {
                    int[] conditions = clause.getConditions();
                    this.output.writeShort(conditions.length);
                    for (int condition : conditions) {
                        this.output.writeInt(condition);
                    }
                    this.writeSequence(clause.getBody());
                }
                this.writeSequence(statement.getDefaultClause());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(WhileStatement statement) {
            try {
                this.output.writeByte(statement.getCondition() != null ? 5 : 6);
                this.writeNullableString(statement.getId());
                if (statement.getCondition() != null) {
                    this.writeExpr(statement.getCondition());
                }
                this.writeSequence(statement.getBody());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BlockStatement statement) {
            try {
                this.output.writeByte(7);
                this.writeNullableString(statement.getId());
                this.writeSequence(statement.getBody());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BreakStatement statement) {
            try {
                this.output.writeByte(statement.getTarget() != null && statement.getTarget().getId() != null ? 8 : 9);
                this.writeLocation(statement.getLocation());
                if (statement.getTarget() != null && statement.getTarget().getId() != null) {
                    this.output.writeUTF(statement.getTarget().getId());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ContinueStatement statement) {
            try {
                this.output.writeByte(statement.getTarget() != null && statement.getTarget().getId() != null ? 10 : 11);
                this.writeLocation(statement.getLocation());
                if (statement.getTarget() != null && statement.getTarget().getId() != null) {
                    this.output.writeUTF(statement.getTarget().getId());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ReturnStatement statement) {
            try {
                this.output.writeByte(statement.getResult() != null ? 12 : 13);
                this.writeLocation(statement.getLocation());
                if (statement.getResult() != null) {
                    this.writeExpr(statement.getResult());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ThrowStatement statement) {
            try {
                this.output.writeByte(14);
                this.writeLocation(statement.getLocation());
                this.writeExpr(statement.getException());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InitClassStatement statement) {
            try {
                this.output.writeByte(15);
                this.writeLocation(statement.getLocation());
                this.output.writeInt(AstIO.this.symbolTable.lookup(statement.getClassName()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(TryCatchStatement statement) {
            try {
                this.output.writeByte(16);
                this.writeSequence(statement.getProtectedBody());
                this.output.writeInt(statement.getExceptionType() != null ? AstIO.this.symbolTable.lookup(statement.getExceptionType()) : -1);
                this.output.writeShort(statement.getExceptionVariable() != null ? statement.getExceptionVariable() : -1);
                this.writeSequence(statement.getHandler());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BinaryExpr expr) {
            try {
                this.output.writeByte(0);
                this.output.writeByte(expr.getOperation().ordinal());
                this.writeExpr(expr.getFirstOperand());
                this.writeExpr(expr.getSecondOperand());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(UnaryExpr expr) {
            try {
                this.output.writeByte(1);
                this.output.writeByte(expr.getOperation().ordinal());
                this.writeExpr(expr.getOperand());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConditionalExpr expr) {
            try {
                this.output.writeByte(2);
                this.writeExpr(expr.getCondition());
                this.writeExpr(expr.getConsequent());
                this.writeExpr(expr.getAlternative());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConstantExpr expr) {
            try {
                Object value = expr.getValue();
                if (value == null) {
                    this.output.writeByte(3);
                } else if (value instanceof Integer) {
                    this.output.writeByte(4);
                    this.output.writeInt((Integer)value);
                } else if (value instanceof Long) {
                    this.output.writeByte(5);
                    this.output.writeLong((Long)value);
                } else if (value instanceof Float) {
                    this.output.writeByte(6);
                    this.output.writeFloat(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    this.output.writeByte(7);
                    this.output.writeDouble((Double)value);
                } else if (value instanceof String) {
                    this.output.writeByte(8);
                    this.output.writeUTF((String)value);
                } else if (value instanceof ValueType) {
                    this.output.writeByte(9);
                    this.output.writeInt(AstIO.this.symbolTable.lookup(value.toString()));
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(VariableExpr expr) {
            try {
                this.output.writeByte(10);
                this.output.writeShort(expr.getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(SubscriptExpr expr) {
            try {
                this.output.writeByte(11);
                this.writeExpr(expr.getArray());
                this.writeExpr(expr.getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(UnwrapArrayExpr expr) {
            try {
                this.output.writeByte(12);
                this.output.writeByte(expr.getElementType().ordinal());
                this.writeExpr(expr.getArray());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InvocationExpr expr) {
            try {
                switch (expr.getType()) {
                    case CONSTRUCTOR: {
                        this.output.writeByte(13);
                        break;
                    }
                    case STATIC: {
                        this.output.writeByte(14);
                        break;
                    }
                    case SPECIAL: {
                        this.output.writeByte(15);
                        break;
                    }
                    case DYNAMIC: {
                        this.output.writeByte(16);
                    }
                }
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getMethod().getClassName()));
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getMethod().getDescriptor().toString()));
                this.output.writeShort(expr.getArguments().size());
                for (int i = 0; i < expr.getArguments().size(); ++i) {
                    this.writeExpr(expr.getArguments().get(i));
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(QualificationExpr expr) {
            try {
                this.output.writeByte(17);
                this.writeExpr(expr.getQualified());
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getField().getClassName()));
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getField().getFieldName()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NewExpr expr) {
            try {
                this.output.writeByte(18);
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getConstructedClass()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NewArrayExpr expr) {
            try {
                this.output.writeByte(19);
                this.writeExpr(expr.getLength());
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getType().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NewMultiArrayExpr expr) {
            try {
                this.output.writeByte(20);
                this.output.writeByte(expr.getDimensions().size());
                for (Expr dimension : expr.getDimensions()) {
                    this.writeExpr(dimension);
                }
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getType().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InstanceOfExpr expr) {
            try {
                this.output.writeByte(21);
                this.writeExpr(expr.getExpr());
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getType().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(StaticClassExpr expr) {
            try {
                this.output.writeByte(22);
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getType().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }
    }
}

