/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teavm.parsing.resource.CompositeResourceProvider;
import org.teavm.parsing.resource.DirectoryResourceProvider;
import org.teavm.parsing.resource.Resource;
import org.teavm.parsing.resource.ZipFileResourceProvider;

public interface ResourceProvider
extends AutoCloseable {
    public static final ResourceProvider EMPTY = new ResourceProvider(){

        @Override
        public Iterator<Resource> getResources(String name) {
            return Collections.emptyIterator();
        }

        @Override
        public void close() {
        }
    };

    default public Resource getResource(String name) {
        Iterator<Resource> iter = this.getResources(name);
        return iter.hasNext() ? iter.next() : null;
    }

    public Iterator<Resource> getResources(String var1);

    @Override
    public void close();

    public static ResourceProvider ofClassPath(List<File> entries) {
        ArrayList<ResourceProvider> providers = new ArrayList<ResourceProvider>();
        for (File entry : entries) {
            if (entry.isFile()) {
                providers.add(new ZipFileResourceProvider(entry));
                continue;
            }
            if (!entry.isDirectory()) continue;
            providers.add(new DirectoryResourceProvider(entry));
        }
        if (providers.isEmpty()) {
            return EMPTY;
        }
        if (providers.size() == 1) {
            return (ResourceProvider)providers.get(0);
        }
        return new CompositeResourceProvider(providers.toArray(new ResourceProvider[0]));
    }
}

