/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.debug.DebugLines;
import org.teavm.backend.wasm.debug.DebugVariables;
import org.teavm.backend.wasm.generate.DwarfClassGenerator;
import org.teavm.backend.wasm.generate.DwarfGenerator;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmCustomSection;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmMemorySegment;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.render.WasmBinaryRenderingVisitor;
import org.teavm.backend.wasm.render.WasmBinaryStatsCollector;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.backend.wasm.render.WasmBinaryWriter;
import org.teavm.backend.wasm.render.WasmCompositeTypeBinaryRenderer;

public class WasmBinaryRenderer {
    private static final int SECTION_UNKNOWN = 0;
    private static final int SECTION_TYPE = 1;
    private static final int SECTION_IMPORT = 2;
    private static final int SECTION_FUNCTION = 3;
    private static final int SECTION_TABLE = 4;
    private static final int SECTION_MEMORY = 5;
    private static final int SECTION_GLOBAL = 6;
    private static final int SECTION_EXPORT = 7;
    private static final int SECTION_START = 8;
    private static final int SECTION_ELEMENT = 9;
    private static final int SECTION_CODE = 10;
    private static final int SECTION_DATA = 11;
    private static final int SECTION_TAGS = 13;
    private static final int EXTERNAL_KIND_FUNCTION = 0;
    private static final int EXTERNAL_KIND_MEMORY = 2;
    private static final int EXTERNAL_KIND_GLOBAL = 3;
    private static final int EXTERNAL_KIND_TAG = 4;
    private WasmBinaryWriter output;
    private WasmBinaryVersion version;
    private boolean obfuscated;
    private DwarfGenerator dwarfGenerator;
    private DwarfClassGenerator dwarfClassGen;
    private DebugLines debugLines;
    private DebugVariables debugVariables;
    private WasmBinaryStatsCollector statsCollector;

    public WasmBinaryRenderer(WasmBinaryWriter output, WasmBinaryVersion version, boolean obfuscated, DwarfGenerator dwarfGenerator, DwarfClassGenerator dwarfClassGen, DebugLines debugLines, DebugVariables debugVariables, WasmBinaryStatsCollector statsCollector) {
        this.output = output;
        this.version = version;
        this.obfuscated = obfuscated;
        this.dwarfGenerator = dwarfGenerator;
        this.dwarfClassGen = dwarfClassGen;
        this.debugLines = debugLines;
        this.debugVariables = debugVariables;
        this.statsCollector = statsCollector;
    }

    public void render(WasmModule module) {
        this.render(module, Collections::emptyList);
    }

    public void render(WasmModule module, Supplier<Collection<? extends WasmCustomSection>> customSectionSupplier) {
        this.output.writeInt32(1836278016);
        switch (this.version) {
            case V_0x1: {
                this.output.writeInt32(1);
            }
        }
        this.renderTypes(module);
        this.renderImports(module);
        this.renderFunctions(module);
        this.renderTable(module);
        if (module.memoryImportName == null) {
            this.renderMemory(module);
        }
        this.renderTags(module);
        this.renderGlobals(module);
        this.renderExport(module);
        this.renderStart(module);
        this.renderElement(module);
        this.renderCode(module);
        this.renderData(module);
        if (!this.obfuscated) {
            this.renderNames(module);
        }
        this.renderCustomSections(module, customSectionSupplier);
    }

    private void renderTypes(WasmModule module) {
        WasmCompositeType type;
        WasmBinaryWriter section = new WasmBinaryWriter();
        WasmCompositeTypeBinaryRenderer typeRenderer = new WasmCompositeTypeBinaryRenderer(module, section);
        int recTypeCount = 0;
        int i = 0;
        while (i < module.types.size()) {
            type = module.types.get(i);
            i = type.getRecursiveTypeCount() > 0 ? (i += type.getRecursiveTypeCount()) : ++i;
            ++recTypeCount;
        }
        section.writeLEB(recTypeCount);
        i = 0;
        while (i < module.types.size()) {
            type = module.types.get(i);
            if (type.getRecursiveTypeCount() > 0) {
                section.writeByte(78);
                section.writeLEB(type.getRecursiveTypeCount());
                for (int j = 0; j < type.getRecursiveTypeCount(); ++j) {
                    WasmCompositeType subtype = module.types.get(i++);
                    subtype.acceptVisitor(typeRenderer);
                }
                continue;
            }
            type.acceptVisitor(typeRenderer);
            ++i;
        }
        this.writeSection(1, "type", section.getData());
    }

    private void renderImports(WasmModule module) {
        ArrayList<WasmFunction> functions = new ArrayList<WasmFunction>();
        for (WasmFunction wasmFunction : module.functions) {
            if (wasmFunction.getImportName() == null) continue;
            functions.add(wasmFunction);
        }
        ArrayList<WasmGlobal> globals = new ArrayList<WasmGlobal>();
        for (WasmGlobal global : module.globals) {
            if (global.getImportName() == null) continue;
            globals.add(global);
        }
        if (functions.isEmpty() && globals.isEmpty() && module.memoryImportName == null) {
            return;
        }
        WasmBinaryWriter wasmBinaryWriter = new WasmBinaryWriter();
        int total = functions.size() + globals.size();
        if (module.memoryImportName != null) {
            ++total;
        }
        wasmBinaryWriter.writeLEB(total);
        if (module.memoryImportName != null) {
            String moduleName = module.memoryImportModule;
            if (moduleName == null) {
                moduleName = "";
            }
            wasmBinaryWriter.writeAsciiString(moduleName);
            wasmBinaryWriter.writeAsciiString(module.memoryImportName);
            wasmBinaryWriter.writeByte(2);
            wasmBinaryWriter.writeByte(3);
            wasmBinaryWriter.writeLEB(module.getMinMemorySize());
            wasmBinaryWriter.writeLEB(module.getMaxMemorySize());
        }
        for (WasmFunction wasmFunction : functions) {
            int signatureIndex = module.types.indexOf(wasmFunction.getType());
            String moduleName = wasmFunction.getImportModule();
            if (moduleName == null) {
                moduleName = "";
            }
            wasmBinaryWriter.writeAsciiString(moduleName);
            wasmBinaryWriter.writeAsciiString(wasmFunction.getImportName());
            wasmBinaryWriter.writeByte(0);
            wasmBinaryWriter.writeLEB(signatureIndex);
        }
        for (WasmGlobal wasmGlobal : globals) {
            String moduleName = wasmGlobal.getImportModule();
            if (moduleName == null) {
                moduleName = "";
            }
            wasmBinaryWriter.writeAsciiString(moduleName);
            wasmBinaryWriter.writeAsciiString(wasmGlobal.getImportName());
            wasmBinaryWriter.writeByte(3);
            wasmBinaryWriter.writeType(wasmGlobal.getType(), module);
            wasmBinaryWriter.writeByte(wasmGlobal.isImmutable() ? 0 : 1);
        }
        this.writeSection(2, "import", wasmBinaryWriter.getData());
    }

    private void renderFunctions(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        List functions = module.functions.stream().filter(function -> function.getImportName() == null).collect(Collectors.toList());
        section.writeLEB(functions.size());
        for (WasmFunction function2 : functions) {
            section.writeLEB(module.types.indexOf(function2.getType()));
        }
        this.writeSection(3, "function", section.getData());
    }

    private void renderTable(WasmModule module) {
        if (module.getFunctionTable().isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeByte(1);
        section.writeByte(112);
        section.writeByte(0);
        section.writeLEB(module.functions.size());
        this.writeSection(4, "table", section.getData());
    }

    private void renderMemory(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeByte(1);
        section.writeByte(1);
        section.writeLEB(module.getMinMemorySize());
        section.writeLEB(module.getMaxMemorySize());
        this.writeSection(5, "memory", section.getData());
    }

    private void renderGlobals(WasmModule module) {
        List globals = module.globals.stream().filter(global -> global.getImportName() == null).collect(Collectors.toList());
        if (globals.isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        WasmBinaryRenderingVisitor visitor = new WasmBinaryRenderingVisitor(section, module, null, null, 0);
        section.writeLEB(globals.size());
        for (WasmGlobal global2 : globals) {
            section.writeType(global2.getType(), module);
            section.writeByte(global2.isImmutable() ? 0 : 1);
            global2.getInitialValue().acceptVisitor(visitor);
            section.writeByte(11);
        }
        this.writeSection(6, "global", section.getData());
    }

    private void renderExport(WasmModule module) {
        List functions = module.functions.stream().filter(function -> function.getExportName() != null).collect(Collectors.toList());
        List tags = module.tags.stream().filter(tag -> tag.getExportName() != null).collect(Collectors.toList());
        List globals = module.globals.stream().filter(global -> global.getExportName() != null).collect(Collectors.toList());
        int total = functions.size() + tags.size() + globals.size();
        if (module.memoryExportName != null) {
            ++total;
        }
        if (total == 0) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(total);
        for (WasmFunction function2 : functions) {
            int functionIndex = module.functions.indexOf(function2);
            section.writeAsciiString(function2.getExportName());
            section.writeByte(0);
            section.writeLEB(functionIndex);
        }
        for (WasmTag tag2 : tags) {
            int tagIndex = module.tags.indexOf(tag2);
            section.writeAsciiString(tag2.getExportName());
            section.writeByte(4);
            section.writeLEB(tagIndex);
        }
        for (WasmGlobal global2 : globals) {
            int index = module.globals.indexOf(global2);
            section.writeAsciiString(global2.getExportName());
            section.writeByte(3);
            section.writeLEB(index);
        }
        if (module.memoryExportName != null) {
            section.writeAsciiString(module.memoryExportName);
            section.writeByte(2);
            section.writeLEB(0);
        }
        this.writeSection(7, "export", section.getData());
    }

    private void renderStart(WasmModule module) {
        if (module.getStartFunction() == null) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(module.functions.indexOf(module.getStartFunction()));
        this.writeSection(8, "start", section.getData());
    }

    private void renderElement(WasmModule module) {
        List referencedFunctions;
        int count = 0;
        if (!module.getFunctionTable().isEmpty()) {
            ++count;
        }
        if (module.functions.stream().anyMatch(WasmFunction::isReferenced)) {
            ++count;
        }
        if (count == 0) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(count);
        if (!module.getFunctionTable().isEmpty()) {
            section.writeLEB(0);
            this.renderInitializer(section, 0);
            section.writeLEB(module.getFunctionTable().size());
            for (WasmFunction function : module.getFunctionTable()) {
                section.writeLEB(module.functions.indexOf(function));
            }
        }
        if (!(referencedFunctions = module.functions.stream().filter(WasmFunction::isReferenced).collect(Collectors.toList())).isEmpty()) {
            section.writeLEB(3);
            section.writeByte(0);
            section.writeLEB(referencedFunctions.size());
            for (WasmFunction function : referencedFunctions) {
                section.writeLEB(module.functions.indexOf(function));
            }
        }
        this.writeSection(9, "element", section.getData());
    }

    private void renderCode(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        List functions = module.functions.stream().filter(function -> function.getImportName() == null).collect(Collectors.toList());
        section.writeLEB(functions.size());
        int sectionOffset = this.output.getPosition() + 4;
        for (WasmFunction function2 : functions) {
            byte[] body = this.renderFunction(module, function2, section.getPosition() + 4, sectionOffset);
            int startPos = section.getPosition();
            section.writeLEB4(body.length);
            section.writeBytes(body);
            int size = section.getPosition() - startPos;
            if (function2.getJavaMethod() == null) continue;
            this.statsCollector.addClassCodeSize(function2.getJavaMethod().getClassName(), size);
        }
        if (this.dwarfGenerator != null) {
            this.dwarfGenerator.setCodeSize(section.getPosition());
        }
        this.writeSection(10, "code", section.getData(), true);
    }

    private byte[] renderFunction(WasmModule module, WasmFunction function, int offset, int sectionOffset) {
        DwarfClassGenerator.Subprogram dwarfSubprogram;
        WasmBinaryWriter code = new WasmBinaryWriter();
        DwarfClassGenerator.Subprogram subprogram = dwarfSubprogram = this.dwarfClassGen != null ? this.dwarfClassGen.getSubprogram(function.getName()) : null;
        if (dwarfSubprogram != null) {
            dwarfSubprogram.startOffset = offset - 4;
            dwarfSubprogram.function = function;
        }
        if (this.debugLines != null && function.getJavaMethod() != null) {
            this.debugLines.advance(offset + sectionOffset);
            this.debugLines.start(function.getJavaMethod());
        }
        List<WasmLocal> localVariables = function.getLocalVariables();
        int parameterCount = Math.min(function.getType().getParameterTypes().size(), localVariables.size());
        if ((localVariables = localVariables.subList(parameterCount, localVariables.size())).isEmpty()) {
            code.writeLEB(0);
        } else {
            ArrayList<Object> localEntries = new ArrayList<Object>();
            Object currentEntry = new LocalEntry(localVariables.get(0).getType());
            for (int i = 1; i < localVariables.size(); ++i) {
                WasmType wasmType = localVariables.get(i).getType();
                if (((LocalEntry)currentEntry).type == wasmType) {
                    ++((LocalEntry)currentEntry).count;
                    continue;
                }
                localEntries.add(currentEntry);
                currentEntry = new LocalEntry(wasmType);
            }
            localEntries.add(currentEntry);
            code.writeLEB(localEntries.size());
            for (LocalEntry localEntry : localEntries) {
                code.writeLEB(localEntry.count);
                code.writeType(localEntry.type, module);
            }
        }
        WasmBinaryRenderingVisitor visitor = new WasmBinaryRenderingVisitor(code, module, this.dwarfGenerator, function.getJavaMethod() != null ? this.debugLines : null, offset + sectionOffset);
        for (WasmExpression part : function.getBody()) {
            visitor.preprocess(part);
        }
        visitor.setPositionToEmit(code.getPosition());
        for (int i = 0; i < function.getBody().size(); ++i) {
            WasmExpression part;
            part = function.getBody().get(i);
            if (i == function.getBody().size() - 1) {
                visitor.pushLocation(part);
            }
            part.acceptVisitor(visitor);
        }
        code.writeByte(11);
        if (!function.getBody().isEmpty()) {
            visitor.popLocation();
        }
        visitor.endLocation();
        if (dwarfSubprogram != null) {
            dwarfSubprogram.endOffset = code.getPosition() + offset;
        }
        if (this.debugVariables != null) {
            this.writeDebugVariables(function, offset + sectionOffset, code.getPosition());
        }
        return code.getData();
    }

    private void writeDebugVariables(WasmFunction function, int offset, int size) {
        this.debugVariables.startSequence(offset);
        for (WasmLocal local : function.getLocalVariables()) {
            if (local.getName() == null || local.getJavaType() == null) continue;
            this.debugVariables.type(local.getName(), local.getJavaType());
            this.debugVariables.range(local.getName(), offset, offset + size, local.getIndex());
        }
        this.debugVariables.endSequence();
    }

    private void renderInitializer(WasmBinaryWriter output, int value) {
        output.writeByte(65);
        output.writeLEB(value);
        output.writeByte(11);
    }

    private void renderData(WasmModule module) {
        if (module.getSegments().isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(module.getSegments().size());
        for (WasmMemorySegment segment : module.getSegments()) {
            section.writeByte(0);
            this.renderInitializer(section, segment.getOffset());
            section.writeLEB(segment.getLength());
            int chunkSize = 65536;
            for (int i = 0; i < segment.getLength(); i += chunkSize) {
                int next = Math.min(i + chunkSize, segment.getLength());
                section.writeBytes(segment.getData(i, next - i));
            }
        }
        this.writeSection(11, "data", section.getData());
    }

    private void renderTags(WasmModule module) {
        if (module.tags.isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(module.tags.size());
        for (WasmTag tag : module.tags) {
            section.writeByte(0);
            section.writeLEB(module.types.indexOf(tag.getType()));
        }
        this.writeSection(13, "tags", section.getData());
    }

    private void renderNames(WasmModule module) {
        List typesWithNamedFields;
        List globals;
        List types;
        WasmBinaryWriter section = new WasmBinaryWriter();
        WasmBinaryWriter functionsSubsection = new WasmBinaryWriter();
        List functions = module.functions.stream().filter(f -> f.getName() != null).collect(Collectors.toList());
        functionsSubsection.writeLEB(functions.size());
        for (WasmFunction function : functions) {
            functionsSubsection.writeLEB(module.functions.indexOf(function));
            functionsSubsection.writeAsciiString(function.getName());
        }
        byte[] payload = functionsSubsection.getData();
        section.writeLEB(1);
        section.writeLEB(payload.length);
        section.writeBytes(payload);
        List functionsWithLocalNames = module.functions.stream().filter(fn -> fn.getLocalVariables().stream().anyMatch(v -> v.getName() != null)).collect(Collectors.toList());
        if (!functionsWithLocalNames.isEmpty()) {
            WasmBinaryWriter subsection = new WasmBinaryWriter();
            subsection.writeLEB(functionsWithLocalNames.size());
            for (Object function : functionsWithLocalNames) {
                subsection.writeLEB(module.functions.indexOf((WasmFunction)function));
                List locals = ((WasmFunction)function).getLocalVariables().stream().filter(t -> t.getName() != null).collect(Collectors.toList());
                subsection.writeLEB(locals.size());
                for (WasmLocal local : locals) {
                    subsection.writeLEB(local.getIndex());
                    subsection.writeAsciiString(local.getName());
                }
            }
            payload = subsection.getData();
            section.writeLEB(2);
            section.writeLEB(payload.length);
            section.writeBytes(payload);
        }
        if (!(types = module.types.stream().filter(t -> t.getName() != null).collect(Collectors.toList())).isEmpty()) {
            WasmBinaryWriter typesSubsection = new WasmBinaryWriter();
            typesSubsection.writeLEB(types.size());
            for (Object type : types) {
                typesSubsection.writeLEB(module.types.indexOf((WasmCompositeType)type));
                typesSubsection.writeAsciiString(((WasmCompositeType)type).getName());
            }
            payload = typesSubsection.getData();
            section.writeLEB(4);
            section.writeLEB(payload.length);
            section.writeBytes(payload);
        }
        if (!(globals = module.globals.stream().filter(g -> g.getName() != null).collect(Collectors.toList())).isEmpty()) {
            WasmBinaryWriter globalsSubsection = new WasmBinaryWriter();
            globalsSubsection.writeLEB(globals.size());
            for (WasmGlobal global : globals) {
                globalsSubsection.writeLEB(module.globals.indexOf(global));
                globalsSubsection.writeAsciiString(global.getName());
            }
            payload = globalsSubsection.getData();
            section.writeLEB(7);
            section.writeLEB(payload.length);
            section.writeBytes(payload);
        }
        if (!(typesWithNamedFields = module.types.stream().filter(t -> t instanceof WasmStructure).filter(t -> ((WasmStructure)t).getFields().stream().anyMatch(f -> f.getName() != null)).collect(Collectors.toList())).isEmpty()) {
            WasmBinaryWriter subsection = new WasmBinaryWriter();
            subsection.writeLEB(typesWithNamedFields.size());
            for (WasmCompositeType type : typesWithNamedFields) {
                subsection.writeLEB(module.types.indexOf(type));
                List fields = ((WasmStructure)type).getFields().stream().filter(t -> t.getName() != null).collect(Collectors.toList());
                subsection.writeLEB(fields.size());
                for (WasmField field : fields) {
                    subsection.writeLEB(field.getIndex());
                    subsection.writeAsciiString(field.getName());
                }
            }
            payload = subsection.getData();
            section.writeLEB(10);
            section.writeLEB(payload.length);
            section.writeBytes(payload);
        }
        this.writeSection(0, "name", section.getData());
    }

    private void renderCustomSections(WasmModule module, Supplier<Collection<? extends WasmCustomSection>> sectionSupplier) {
        for (WasmCustomSection wasmCustomSection : module.getCustomSections().values()) {
            this.renderCustomSection(wasmCustomSection);
        }
        if (sectionSupplier != null) {
            for (WasmCustomSection wasmCustomSection : sectionSupplier.get()) {
                this.renderCustomSection(wasmCustomSection);
            }
        }
    }

    private void renderCustomSection(WasmCustomSection customSection) {
        this.writeSection(0, customSection.getName(), customSection.getData());
    }

    private void writeSection(int id, String name, byte[] data) {
        this.writeSection(id, name, data, false);
    }

    private void writeSection(int id, String name, byte[] data, boolean constantSizeLength) {
        int start = this.output.getPosition();
        this.output.writeByte(id);
        int length = data.length;
        if (id == 0) {
            length += name.length() + 1;
        }
        if (constantSizeLength) {
            this.output.writeLEB4(length);
        } else {
            this.output.writeLEB(length);
        }
        if (id == 0) {
            this.output.writeAsciiString(name);
        }
        this.output.writeBytes(data);
        this.statsCollector.addSectionSize(name, this.output.getPosition() - start);
    }

    static class LocalEntry {
        WasmType type;
        int count = 1;

        LocalEntry(WasmType type) {
            this.type = type;
        }
    }
}

