/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmCompositeTypeVisitor;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;

final class WasmTypeGraphBuilder {
    private WasmTypeGraphBuilder() {
    }

    static Graph buildTypeGraph(WasmModule module, Iterable<WasmCompositeType> types, int size) {
        GraphBuilder graphBuilder = new GraphBuilder(size);
        GraphBuilderVisitor visitor = new GraphBuilderVisitor(module, graphBuilder);
        for (WasmCompositeType type : types) {
            visitor.currentIndex = module.types.indexInCollection(type);
            type.acceptVisitor(visitor);
        }
        WasmTypeGraphBuilder.addNominalStructures(module, types, graphBuilder);
        return graphBuilder.build();
    }

    private static void addNominalStructures(WasmModule module, Iterable<WasmCompositeType> types, GraphBuilder graphBuilder) {
        HashMap<WasmStructure, List> subStructures = new HashMap<WasmStructure, List>();
        ArrayList<WasmStructure> topLevelStructures = new ArrayList<WasmStructure>();
        for (WasmCompositeType wasmCompositeType : types) {
            WasmStructure structure;
            if (!(wasmCompositeType instanceof WasmStructure) || !(structure = (WasmStructure)wasmCompositeType).isNominal()) continue;
            if (structure.getSupertype() != null) {
                subStructures.computeIfAbsent(structure.getSupertype(), k -> new ArrayList()).add(structure);
                continue;
            }
            topLevelStructures.add(structure);
        }
        WasmTypeGraphBuilder.mergeNominalStructures(module, topLevelStructures, 0, graphBuilder);
        for (Map.Entry entry : subStructures.entrySet()) {
            WasmTypeGraphBuilder.mergeNominalStructures(module, (List)entry.getValue(), ((WasmStructure)entry.getKey()).getFields().size(), graphBuilder);
        }
    }

    private static void mergeNominalStructures(WasmModule module, List<WasmStructure> structures, int parentFieldCount, GraphBuilder graphBuilder) {
        block0: for (int i = 0; i < structures.size(); ++i) {
            for (int j = i + 1; j < structures.size(); ++j) {
                WasmStructure b;
                WasmStructure a = structures.get(i);
                if (!WasmTypeGraphBuilder.areSameStructures(parentFieldCount, a, b = structures.get(j))) continue;
                int p = module.types.indexInCollection(a);
                int q = module.types.indexInCollection(b);
                graphBuilder.addEdge(p, q);
                graphBuilder.addEdge(q, p);
                continue block0;
            }
        }
    }

    private static boolean areSameStructures(int start, WasmStructure a, WasmStructure b) {
        if (a.getFields().size() != b.getFields().size()) {
            return false;
        }
        for (int i = start; i < a.getFields().size(); ++i) {
            if (a.getFields().get(i).getType() == b.getFields().get(i).getType()) continue;
            return false;
        }
        return true;
    }

    private static class GraphBuilderVisitor
    implements WasmCompositeTypeVisitor {
        final WasmModule module;
        final GraphBuilder graphBuilder;
        int currentIndex;

        GraphBuilderVisitor(WasmModule module, GraphBuilder graphBuilder) {
            this.module = module;
            this.graphBuilder = graphBuilder;
        }

        @Override
        public void visit(WasmStructure type) {
            if (type.getSupertype() != null) {
                this.addEdge(type.getSupertype().getReference());
            }
            for (WasmField field : type.getFields()) {
                this.addEdge(field.getUnpackedType());
            }
        }

        @Override
        public void visit(WasmArray type) {
            this.addEdge(type.getElementType().asUnpackedType());
        }

        @Override
        public void visit(WasmFunctionType type) {
            for (WasmFunctionType wasmFunctionType : type.getSupertypes()) {
                this.addEdge(wasmFunctionType.getReference());
            }
            for (WasmType wasmType : type.getParameterTypes()) {
                this.addEdge(wasmType);
            }
            for (WasmType wasmType : type.getReturnTypes()) {
                this.addEdge(wasmType);
            }
        }

        private void addEdge(WasmType type) {
            if (type instanceof WasmType.CompositeReference) {
                WasmCompositeType composite = ((WasmType.CompositeReference)type).composite;
                this.graphBuilder.addEdge(this.currentIndex, this.module.types.indexInCollection(composite));
            }
        }
    }
}

