/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.teavm.ast.ArrayFromDataExpr;
import org.teavm.ast.ArrayType;
import org.teavm.ast.CastExpr;
import org.teavm.ast.Expr;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.InvocationType;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.Statement;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.TryCatchStatement;
import org.teavm.backend.wasm.WasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.WasmHeap;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmGenerationContext;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.generate.common.methods.BaseWasmGenerationVisitor;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmInt64Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Address;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.classes.VirtualTable;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.CallSiteLocation;
import org.teavm.model.lowlevel.ExceptionHandlerDescriptor;
import org.teavm.model.lowlevel.ExceptionHandlingUtil;
import org.teavm.parsing.resource.ResourceProvider;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.ExceptionHandling;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.ShadowStack;

public class WasmGenerationVisitor
extends BaseWasmGenerationVisitor {
    private static final FieldReference MONITOR_FIELD = new FieldReference("java.lang.Object", "monitor");
    private static final MethodReference CATCH_METHOD = new MethodReference(ExceptionHandling.class, "catchException", Throwable.class);
    private static final MethodReference THROW_METHOD = new MethodReference(ExceptionHandling.class, "throwException", Throwable.class, Void.TYPE);
    private static final MethodReference THROW_CCE_METHOD = new MethodReference(ExceptionHandling.class, "throwClassCastException", Void.TYPE);
    private static final MethodReference THROW_NPE_METHOD = new MethodReference(ExceptionHandling.class, "throwNullPointerException", Void.TYPE);
    private static final MethodReference THROW_AIOOBE_METHOD = new MethodReference(ExceptionHandling.class, "throwArrayIndexOutOfBoundsException", Void.TYPE);
    private WasmGenerationContext context;
    private WasmClassGenerator classGenerator;
    private List<ExceptionHandlerDescriptor> handlers = new ArrayList<ExceptionHandlerDescriptor>();
    private WasmBlock lastTryBlock;
    private WasmBlock rethrowBlock;
    private List<WasmBlock> catchLabels = new ArrayList<WasmBlock>();
    private WasmLocal stackVariable;
    private BinaryWriter binaryWriter;
    private boolean managed;
    private WasmIntrinsicManager intrinsicManager = new WasmIntrinsicManager(){

        @Override
        public WasmExpression generate(Expr expr) {
            WasmGenerationVisitor.this.accept(expr);
            return WasmGenerationVisitor.this.result;
        }

        @Override
        public ResourceProvider getResourceProvider() {
            return WasmGenerationVisitor.this.context.resources();
        }

        @Override
        public ClassHierarchy getClassHierarchy() {
            return WasmGenerationVisitor.this.context.getClassHierarchy();
        }

        @Override
        public BinaryWriter getBinaryWriter() {
            return WasmGenerationVisitor.this.binaryWriter;
        }

        @Override
        public WasmStringPool getStringPool() {
            return WasmGenerationVisitor.this.context.getStringPool();
        }

        @Override
        public Diagnostics getDiagnostics() {
            return WasmGenerationVisitor.this.context.getDiagnostics();
        }

        @Override
        public WasmFunctionRepository getFunctions() {
            return WasmGenerationVisitor.this.context.functions();
        }

        @Override
        public WasmFunctionTypes getFunctionTypes() {
            return WasmGenerationVisitor.this.context.functionTypes();
        }

        @Override
        public WasmLocal getTemporary(WasmType type) {
            return WasmGenerationVisitor.this.tempVars.acquire(type);
        }

        @Override
        public void releaseTemporary(WasmLocal local) {
            WasmGenerationVisitor.this.tempVars.release(local);
        }

        @Override
        public int getStaticField(FieldReference field) {
            return WasmGenerationVisitor.this.classGenerator.getFieldOffset(field);
        }

        @Override
        public int getClassPointer(ValueType type) {
            return WasmGenerationVisitor.this.classGenerator.getClassPointer(type);
        }

        @Override
        public int getFunctionPointer(WasmFunction function) {
            return WasmGenerationVisitor.this.classGenerator.getFunctionPointer(function);
        }

        @Override
        public boolean isManagedMethodCall(MethodReference method) {
            return WasmGenerationVisitor.this.needsCallSiteId() && ExceptionHandlingUtil.isManagedMethodCall(WasmGenerationVisitor.this.context.characteristics, method);
        }

        @Override
        public WasmIntrinsicManager.CallSiteIdentifier generateCallSiteId(TextLocation location) {
            return WasmGenerationVisitor.this.generateCallSiteIdImpl(location);
        }

        @Override
        public WasmTag getExceptionTag() {
            return WasmGenerationVisitor.this.context.getExceptionTag();
        }
    };

    public WasmGenerationVisitor(WasmGenerationContext context, WasmClassGenerator classGenerator, BinaryWriter binaryWriter, WasmFunction function, MethodReference currentMethod, int firstVariable, boolean async) {
        super(context, currentMethod, function, firstVariable, async);
        this.context = context;
        this.classGenerator = classGenerator;
        this.binaryWriter = binaryWriter;
        this.managed = context.characteristics.isManaged(currentMethod);
    }

    @Override
    public void generate(Statement statement, List<WasmExpression> target) {
        int lastTargetSize = target.size();
        super.generate(statement, target);
        if (this.rethrowBlock != null) {
            List<WasmExpression> body = target.subList(lastTargetSize, target.size());
            this.rethrowBlock.getBody().addAll(body);
            body.clear();
            target.add(this.rethrowBlock);
            WasmExpression valueToReturn = WasmExpression.defaultValueOfType(this.function.getType().getSingleReturnType());
            if (valueToReturn != null) {
                target.add(new WasmReturn(valueToReturn));
            }
            if (!this.rethrowBlock.isTerminating()) {
                this.rethrowBlock.getBody().add(new WasmReturn());
            }
        }
    }

    @Override
    protected void generateThrowNPE(TextLocation location, List<WasmExpression> target) {
        WasmCall call = new WasmCall(this.context.functions().forStaticMethod(THROW_NPE_METHOD));
        call.setLocation(location);
        target.add(call);
    }

    @Override
    public void visit(CastExpr expr) {
        String className;
        ValueType type = expr.getTarget();
        if (type instanceof ValueType.Object && !this.context.characteristics.isManaged(className = ((ValueType.Object)type).getClassName())) {
            expr.getValue().acceptVisitor(this);
            return;
        }
        super.visit(expr);
    }

    @Override
    protected WasmType mapType(ValueType type) {
        return WasmGeneratorUtil.mapType(type);
    }

    @Override
    protected WasmExpression generateArrayLength(WasmExpression array) {
        int sizeOffset = this.classGenerator.getFieldOffset(new FieldReference(RuntimeArray.class.getName(), "size"));
        WasmLoadInt32 length = new WasmLoadInt32(4, array, WasmInt32Subtype.INT32);
        length.setOffset(sizeOffset);
        length.setLocation(array.getLocation());
        return length;
    }

    @Override
    protected void storeField(Expr qualified, FieldReference field, Expr value, TextLocation location) {
        WasmExpression resultExpr;
        block11: {
            WasmExpression address;
            block10: {
                address = this.getAddress(qualified, field, location);
                this.accept(value);
                if (field.equals(MONITOR_FIELD)) {
                    this.storeMonitor(address, this.result, location);
                    return;
                }
                ValueType type = this.context.getFieldType(field);
                if (!(type instanceof ValueType.Primitive)) break block10;
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: 
                    case BYTE: {
                        resultExpr = new WasmStoreInt32(1, address, this.result, WasmInt32Subtype.INT8);
                        break block11;
                    }
                    case SHORT: {
                        resultExpr = new WasmStoreInt32(2, address, this.result, WasmInt32Subtype.INT16);
                        break block11;
                    }
                    case CHARACTER: {
                        resultExpr = new WasmStoreInt32(2, address, this.result, WasmInt32Subtype.UINT16);
                        break block11;
                    }
                    case INTEGER: {
                        resultExpr = new WasmStoreInt32(4, address, this.result, WasmInt32Subtype.INT32);
                        break block11;
                    }
                    case LONG: {
                        resultExpr = new WasmStoreInt64(8, address, this.result, WasmInt64Subtype.INT64);
                        break block11;
                    }
                    case FLOAT: {
                        resultExpr = new WasmStoreFloat32(4, address, this.result);
                        break block11;
                    }
                    case DOUBLE: {
                        resultExpr = new WasmStoreFloat64(8, address, this.result);
                        break block11;
                    }
                    default: {
                        throw new AssertionError((Object)type.toString());
                    }
                }
            }
            resultExpr = new WasmStoreInt32(4, address, this.result, WasmInt32Subtype.INT32);
        }
        resultExpr.setOffset(this.getOffset(qualified, field));
        WasmExpression result = resultExpr;
        result.setLocation(location);
        this.resultConsumer.add(result);
    }

    private void storeMonitor(WasmExpression address, WasmExpression value, TextLocation location) {
        value = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_UNSIGNED, value, new WasmInt32Constant(1));
        value = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.OR, value, new WasmInt32Constant(Integer.MIN_VALUE));
        WasmStoreInt32 store = new WasmStoreInt32(4, address, value, WasmInt32Subtype.INT32);
        store.setLocation(location);
        store.setOffset(4);
        this.resultConsumer.add(store);
    }

    @Override
    protected WasmExpression storeArrayItem(WasmExpression array, WasmExpression index, Expr value, ArrayType type) {
        this.accept(value);
        WasmExpression wasmValue = this.result;
        return WasmGenerationVisitor.storeArrayItem(this.getArrayElementPointer(array, index, type), wasmValue, type);
    }

    private static WasmExpression storeArrayItem(WasmExpression array, WasmExpression value, ArrayType type) {
        switch (type) {
            case BYTE: {
                return new WasmStoreInt32(1, array, value, WasmInt32Subtype.INT8);
            }
            case SHORT: {
                return new WasmStoreInt32(2, array, value, WasmInt32Subtype.INT16);
            }
            case CHAR: {
                return new WasmStoreInt32(2, array, value, WasmInt32Subtype.UINT16);
            }
            case INT: 
            case OBJECT: {
                return new WasmStoreInt32(4, array, value, WasmInt32Subtype.INT32);
            }
            case LONG: {
                return new WasmStoreInt64(8, array, value, WasmInt64Subtype.INT64);
            }
            case FLOAT: {
                return new WasmStoreFloat32(4, array, value);
            }
            case DOUBLE: {
                return new WasmStoreFloat64(8, array, value);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected WasmExpression stringLiteral(String s) {
        return new WasmInt32Constant(this.context.getStringPool().getStringPointer(s));
    }

    @Override
    protected WasmExpression classLiteral(ValueType type) {
        return new WasmInt32Constant(this.classGenerator.getClassPointer(type));
    }

    @Override
    protected WasmExpression nullLiteral(Expr expr) {
        return new WasmInt32Constant(0);
    }

    @Override
    protected WasmExpression nullLiteral(WasmType type) {
        return new WasmInt32Constant(0);
    }

    @Override
    protected WasmExpression genIsNull(WasmExpression value) {
        return new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, value);
    }

    @Override
    public void visit(SubscriptExpr expr) {
        WasmExpression ptr = this.getArrayElementPointer(expr);
        switch (expr.getType()) {
            case BYTE: {
                this.result = new WasmLoadInt32(1, ptr, WasmInt32Subtype.INT8);
                break;
            }
            case SHORT: {
                this.result = new WasmLoadInt32(2, ptr, WasmInt32Subtype.INT16);
                break;
            }
            case CHAR: {
                this.result = new WasmLoadInt32(2, ptr, WasmInt32Subtype.UINT16);
                break;
            }
            case INT: 
            case OBJECT: {
                this.result = new WasmLoadInt32(4, ptr, WasmInt32Subtype.INT32);
                break;
            }
            case LONG: {
                this.result = new WasmLoadInt64(8, ptr, WasmInt64Subtype.INT64);
                break;
            }
            case FLOAT: {
                this.result = new WasmLoadFloat32(4, ptr);
                break;
            }
            case DOUBLE: {
                this.result = new WasmLoadFloat64(8, ptr);
            }
        }
    }

    private WasmExpression getArrayElementPointer(SubscriptExpr expr) {
        expr.getArray().acceptVisitor(this);
        WasmExpression array = this.result;
        expr.getIndex().acceptVisitor(this);
        WasmExpression index = this.result;
        return this.getArrayElementPointer(array, index, expr.getType());
    }

    private WasmExpression getArrayElementPointer(WasmExpression array, WasmExpression index, ArrayType type) {
        int size = -1;
        switch (type) {
            case BYTE: {
                size = 0;
                break;
            }
            case SHORT: 
            case CHAR: {
                size = 1;
                break;
            }
            case INT: 
            case OBJECT: 
            case FLOAT: {
                size = 2;
                break;
            }
            case LONG: 
            case DOUBLE: {
                size = 3;
            }
        }
        int base = BinaryWriter.align(this.classGenerator.getClassSize(RuntimeArray.class.getName()), 1 << size);
        array = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, array, new WasmInt32Constant(base));
        if (size != 0) {
            index = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, index, new WasmInt32Constant(size));
        }
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, array, index);
    }

    @Override
    protected WasmExpression invocation(InvocationExpr expr, List<WasmExpression> resultConsumer, boolean willDrop) {
        WasmIntrinsic intrinsic;
        if (expr.getMethod().getClassName().equals(ShadowStack.class.getName())) {
            switch (expr.getMethod().getName()) {
                case "allocStack": {
                    this.generateAllocStack(expr.getArguments().get(0));
                    this.result.setLocation(expr.getLocation());
                    if (resultConsumer != null) {
                        resultConsumer.add(this.result);
                        return null;
                    }
                    return this.result;
                }
                case "releaseStack": {
                    this.generateReleaseStack();
                    this.result.setLocation(expr.getLocation());
                    if (resultConsumer != null) {
                        resultConsumer.add(this.result);
                        return null;
                    }
                    return this.result;
                }
                case "registerGCRoot": {
                    this.generateRegisterGcRoot(expr.getArguments().get(0), expr.getArguments().get(1));
                    this.result.setLocation(expr.getLocation());
                    if (resultConsumer != null) {
                        resultConsumer.add(this.result);
                        return null;
                    }
                    return this.result;
                }
                case "removeGCRoot": {
                    this.generateRemoveGcRoot(expr.getArguments().get(0));
                    this.result.setLocation(expr.getLocation());
                    if (resultConsumer != null) {
                        resultConsumer.add(this.result);
                        return null;
                    }
                    return this.result;
                }
            }
        }
        if ((intrinsic = this.context.getIntrinsic(expr.getMethod())) != null) {
            WasmExpression resultExpr = intrinsic.apply(expr, this.intrinsicManager);
            return this.trivialInvocation(resultExpr, resultConsumer, expr.getLocation(), willDrop);
        }
        return super.invocation(expr, resultConsumer, willDrop);
    }

    @Override
    protected WasmExpression generateVirtualCall(WasmLocal instance, MethodReference method, List<WasmExpression> arguments) {
        int vtableOffset = this.classGenerator.getClassSize(RuntimeClass.class.getName());
        VirtualTable vtable = this.context.getVirtualTableProvider().lookup(method.getClassName());
        if (vtable != null) {
            vtable = vtable.findMethodContainer(method.getDescriptor());
        }
        if (vtable == null) {
            return new WasmUnreachable();
        }
        int vtableIndex = vtable.getMethods().indexOf(method.getDescriptor());
        if (vtable.getParent() != null) {
            vtableIndex += vtable.getParent().size();
        }
        WasmExpression classRef = this.getReferenceToClass(new WasmGetLocal(instance));
        WasmLoadInt32 methodIndex = new WasmLoadInt32(4, classRef, WasmInt32Subtype.INT32);
        methodIndex.setOffset(vtableIndex * 4 + vtableOffset);
        WasmType[] parameterTypes = new WasmType[method.parameterCount() + 1];
        parameterTypes[0] = WasmType.INT32;
        for (int i = 0; i < method.parameterCount(); ++i) {
            parameterTypes[i + 1] = WasmGeneratorUtil.mapType(method.parameterType(i));
        }
        WasmFunctionType functionType = this.context.functionTypes().of(WasmGeneratorUtil.mapType(method.getReturnType()), parameterTypes);
        WasmIndirectCall call = new WasmIndirectCall(methodIndex, functionType);
        call.getArguments().addAll(arguments);
        return call;
    }

    private WasmExpression getReferenceToClass(WasmExpression instance) {
        WasmLoadInt32 classIndex = new WasmLoadInt32(4, instance, WasmInt32Subtype.INT32);
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, classIndex, new WasmInt32Constant(3));
    }

    private WasmExpression trivialInvocation(WasmExpression resultExpr, List<WasmExpression> resultConsumer, TextLocation location, boolean willDrop) {
        if (resultConsumer != null) {
            if (willDrop) {
                WasmDrop drop = new WasmDrop(resultExpr);
                drop.setLocation(location);
                resultConsumer.add(drop);
            } else {
                resultConsumer.add(resultExpr);
            }
            this.result = null;
            return null;
        }
        return resultExpr;
    }

    @Override
    protected BaseWasmGenerationVisitor.CallSiteIdentifier generateCallSiteId(TextLocation location) {
        return this.generateCallSiteIdImpl(location);
    }

    private CallSiteIdentifierImpl generateCallSiteIdImpl(TextLocation location) {
        CallSiteLocation[] callSiteLocations = CallSiteLocation.fromTextLocation(location, this.currentMethod);
        CallSiteDescriptor callSite = new CallSiteDescriptor(this.context.callSites().size(), callSiteLocations);
        ArrayList<ExceptionHandlerDescriptor> reverseHandlers = new ArrayList<ExceptionHandlerDescriptor>(this.handlers);
        Collections.reverse(reverseHandlers);
        callSite.getHandlers().addAll(reverseHandlers);
        this.context.callSites().add(callSite);
        return new CallSiteIdentifierImpl(callSite.getId());
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    protected boolean isManagedCall(MethodReference method) {
        return ExceptionHandlingUtil.isManagedMethodCall(this.context.characteristics, method);
    }

    @Override
    protected void generateThrow(WasmExpression expression, TextLocation location, List<WasmExpression> target) {
        if (this.context.getExceptionTag() == null) {
            WasmCall call = new WasmCall(this.context.functions().forStaticMethod(THROW_METHOD), this.result);
            call.setLocation(location);
            target.add(call);
        } else {
            WasmThrow result = new WasmThrow(this.context.getExceptionTag());
            result.getArguments().add(expression);
            result.setLocation(location);
            target.add(result);
        }
    }

    private WasmBlock throwJumpTarget() {
        return this.lastTryBlock != null ? this.lastTryBlock : this.rethrowBlock();
    }

    private void generateAllocStack(Expr sizeExpr) {
        if (this.stackVariable != null) {
            throw new IllegalStateException("Call to ShadowStack.allocStack must be done only once");
        }
        this.stackVariable = this.tempVars.acquire(WasmType.INT32);
        this.stackVariable.setName("__stack__");
        InvocationExpr expr = new InvocationExpr();
        expr.setType(InvocationType.STATIC);
        expr.setMethod(new MethodReference(WasmRuntime.class, "allocStack", Integer.TYPE, Address.class));
        expr.getArguments().add(sizeExpr);
        expr.acceptVisitor(this);
        this.result = new WasmSetLocal(this.stackVariable, this.result);
    }

    private void generateReleaseStack() {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.releaseStack must be dominated by Mutator.allocStack");
        }
        int offset = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "stack"));
        WasmExpression oldValue = new WasmGetLocal(this.stackVariable);
        oldValue = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, oldValue, new WasmInt32Constant(4));
        this.result = new WasmStoreInt32(4, new WasmInt32Constant(offset), oldValue, WasmInt32Subtype.INT32);
    }

    private void generateRegisterGcRoot(Expr slotExpr, Expr gcRootExpr) {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.registerGCRoot must be dominated by Mutator.allocStack");
        }
        slotExpr.acceptVisitor(this);
        WasmExpression slotOffset = this.getSlotOffset(this.result);
        WasmExpression address = new WasmGetLocal(this.stackVariable);
        if (!(slotOffset instanceof WasmInt32Constant)) {
            address = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, address, slotOffset);
        }
        gcRootExpr.acceptVisitor(this);
        WasmExpression gcRoot = this.result;
        WasmStoreInt32 store = new WasmStoreInt32(4, address, gcRoot, WasmInt32Subtype.INT32);
        if (slotOffset instanceof WasmInt32Constant) {
            store.setOffset(((WasmInt32Constant)slotOffset).getValue());
        }
        this.result = store;
    }

    private void generateRemoveGcRoot(Expr slotExpr) {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.removeGCRoot must be dominated by Mutator.allocStack");
        }
        slotExpr.acceptVisitor(this);
        WasmExpression slotOffset = this.getSlotOffset(this.result);
        WasmExpression address = new WasmGetLocal(this.stackVariable);
        if (!(slotOffset instanceof WasmInt32Constant)) {
            address = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, address, slotOffset);
        }
        WasmStoreInt32 store = new WasmStoreInt32(4, address, new WasmInt32Constant(0), WasmInt32Subtype.INT32);
        if (slotOffset instanceof WasmInt32Constant) {
            store.setOffset(((WasmInt32Constant)slotOffset).getValue());
        }
        this.result = store;
    }

    private WasmExpression getSlotOffset(WasmExpression slot) {
        if (slot instanceof WasmInt32Constant) {
            int slotConstant = ((WasmInt32Constant)slot).getValue();
            return new WasmInt32Constant((slotConstant << 2) + 4);
        }
        slot = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, slot, new WasmInt32Constant(2));
        slot = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, slot, new WasmInt32Constant(4));
        return slot;
    }

    @Override
    public void visit(QualificationExpr expr) {
        WasmExpression resultExpr;
        block11: {
            WasmExpression address;
            block10: {
                address = this.getAddress(expr.getQualified(), expr.getField(), expr.getLocation());
                if (expr.getField().equals(MONITOR_FIELD)) {
                    this.result = this.getMonitor(address, expr.getLocation());
                    return;
                }
                ValueType type = this.context.getFieldType(expr.getField());
                if (!(type instanceof ValueType.Primitive)) break block10;
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: 
                    case BYTE: {
                        resultExpr = new WasmLoadInt32(1, address, WasmInt32Subtype.INT8);
                        break block11;
                    }
                    case SHORT: {
                        resultExpr = new WasmLoadInt32(2, address, WasmInt32Subtype.INT16);
                        break block11;
                    }
                    case CHARACTER: {
                        resultExpr = new WasmLoadInt32(2, address, WasmInt32Subtype.UINT16);
                        break block11;
                    }
                    case INTEGER: {
                        resultExpr = new WasmLoadInt32(4, address, WasmInt32Subtype.INT32);
                        break block11;
                    }
                    case LONG: {
                        resultExpr = new WasmLoadInt64(8, address, WasmInt64Subtype.INT64);
                        break block11;
                    }
                    case FLOAT: {
                        resultExpr = new WasmLoadFloat32(4, address);
                        break block11;
                    }
                    case DOUBLE: {
                        resultExpr = new WasmLoadFloat64(8, address);
                        break block11;
                    }
                    default: {
                        throw new AssertionError((Object)type.toString());
                    }
                }
            }
            resultExpr = new WasmLoadInt32(4, address, WasmInt32Subtype.INT32);
        }
        resultExpr.setOffset(this.getOffset(expr.getQualified(), expr.getField()));
        this.result = resultExpr;
    }

    private WasmExpression getMonitor(WasmExpression address, TextLocation location) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32.asBlock());
        block.setLocation(location);
        WasmLocal tmp = this.tempVars.acquire(WasmType.INT32);
        WasmLoadInt32 monitor = new WasmLoadInt32(4, address, WasmInt32Subtype.INT32);
        monitor.setOffset(4);
        block.getBody().add(new WasmSetLocal(tmp, monitor));
        WasmIntBinary isMonitor = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.AND, new WasmGetLocal(tmp), new WasmInt32Constant(Integer.MIN_VALUE));
        WasmIntBinary shiftMonitor = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, new WasmGetLocal(tmp), new WasmInt32Constant(1));
        WasmConditional cond = new WasmConditional(isMonitor);
        cond.setType(WasmType.INT32.asBlock());
        cond.getThenBlock().getBody().add(shiftMonitor);
        cond.getElseBlock().getBody().add(new WasmInt32Constant(0));
        block.getBody().add(cond);
        this.tempVars.release(tmp);
        return block;
    }

    private WasmExpression getAddress(Expr qualified, FieldReference field, TextLocation location) {
        if (qualified == null) {
            int offset = this.classGenerator.getFieldOffset(field);
            WasmInt32Constant result = new WasmInt32Constant(offset);
            result.setLocation(location);
            return result;
        }
        this.accept(qualified);
        assert (this.result != null);
        return this.result;
    }

    private int getOffset(Expr qualified, FieldReference field) {
        if (qualified == null) {
            return 0;
        }
        return this.classGenerator.getFieldOffset(field);
    }

    @Override
    protected void allocateObject(String className, TextLocation location, WasmLocal local, List<WasmExpression> target) {
        int tag = this.classGenerator.getClassPointer(ValueType.object(className));
        WasmFunction allocFunction = this.context.functions().forStaticMethod(new MethodReference(Allocator.class, "allocate", RuntimeClass.class, Address.class));
        WasmCall call = new WasmCall(allocFunction);
        call.getArguments().add(new WasmInt32Constant(tag));
        call.setLocation(location);
        if (local != null) {
            target.add(new WasmSetLocal(local, call));
        } else {
            target.add(call);
        }
    }

    @Override
    public void visit(NewArrayExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setType(this.mapType(ValueType.arrayOf(expr.getType())).asBlock());
        BaseWasmGenerationVisitor.CallSiteIdentifier callSiteId = this.generateCallSiteId(expr.getLocation());
        callSiteId.generateRegister(block.getBody(), expr.getLocation());
        this.allocateArray(expr.getType(), () -> {
            this.accept(expr.getLength());
            return this.result;
        }, expr.getLocation(), null, block.getBody());
        this.result = block.getBody().size() == 1 ? block.getBody().get(0) : block;
    }

    private void allocateArray(ValueType itemType, Supplier<WasmExpression> length, TextLocation location, WasmLocal local, List<WasmExpression> target) {
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(itemType));
        WasmFunction allocFunction = this.context.functions().forStaticMethod(new MethodReference(Allocator.class, "allocateArray", RuntimeClass.class, Integer.TYPE, Address.class));
        WasmCall call = new WasmCall(allocFunction);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        call.getArguments().add(length.get());
        call.setLocation(location);
        if (local != null) {
            target.add(new WasmSetLocal(local, call));
        } else {
            target.add(call);
        }
    }

    @Override
    public void visit(ArrayFromDataExpr expr) {
        ValueType type = expr.getType();
        ArrayType arrayType = ArrayType.OBJECT;
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    arrayType = ArrayType.BYTE;
                    break;
                }
                case SHORT: {
                    arrayType = ArrayType.SHORT;
                    break;
                }
                case CHARACTER: {
                    arrayType = ArrayType.CHAR;
                    break;
                }
                case INTEGER: {
                    arrayType = ArrayType.INT;
                    break;
                }
                case LONG: {
                    arrayType = ArrayType.LONG;
                    break;
                }
                case FLOAT: {
                    arrayType = ArrayType.FLOAT;
                    break;
                }
                case DOUBLE: {
                    arrayType = ArrayType.DOUBLE;
                }
            }
        }
        WasmType wasmArrayType = this.mapType(ValueType.arrayOf(expr.getType()));
        WasmBlock block = new WasmBlock(false);
        block.setType(wasmArrayType.asBlock());
        BaseWasmGenerationVisitor.CallSiteIdentifier callSiteId = this.generateCallSiteId(expr.getLocation());
        callSiteId.generateRegister(block.getBody(), expr.getLocation());
        WasmLocal array = this.tempVars.acquire(wasmArrayType);
        this.allocateArray(expr.getType(), () -> new WasmInt32Constant(expr.getData().size()), expr.getLocation(), array, block.getBody());
        for (int i = 0; i < expr.getData().size(); ++i) {
            WasmExpression arrayData = this.unwrapArray(new WasmGetLocal(array));
            block.getBody().add(this.storeArrayItem(arrayData, new WasmInt32Constant(i), expr.getData().get(i), arrayType));
        }
        block.getBody().add(new WasmGetLocal(array));
        block.setLocation(expr.getLocation());
        this.tempVars.release(array);
        this.result = block;
    }

    @Override
    protected WasmExpression allocateMultiArray(List<WasmExpression> target, ValueType arrayType, Supplier<List<WasmExpression>> dimensions, TextLocation location) {
        int dimensionList = -1;
        List<WasmExpression> dimensionsValue = dimensions.get();
        for (WasmExpression dimension : dimensionsValue) {
            int dimensionAddress = this.binaryWriter.append(DataPrimitives.INT.createValue());
            if (dimensionList < 0) {
                dimensionList = dimensionAddress;
            }
            target.add(new WasmStoreInt32(4, new WasmInt32Constant(dimensionAddress), dimension, WasmInt32Subtype.INT32));
        }
        int classPointer = this.classGenerator.getClassPointer(arrayType);
        WasmFunction allocFunction = this.context.functions().forStaticMethod(new MethodReference(Allocator.class, "allocateMultiArray", RuntimeClass.class, Address.class, Integer.TYPE, RuntimeArray.class));
        WasmCall call = new WasmCall(allocFunction);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        call.getArguments().add(new WasmInt32Constant(dimensionList));
        call.getArguments().add(new WasmInt32Constant(dimensionsValue.size()));
        call.setLocation(location);
        return call;
    }

    @Override
    public void visit(InvocationExpr expr) {
        this.result = this.invocation(expr, null, false);
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        String className;
        ValueType type = expr.getType();
        if (type instanceof ValueType.Object && !this.context.characteristics.isManaged(className = ((ValueType.Object)type).getClassName())) {
            expr.getExpr().acceptVisitor(this);
            return;
        }
        super.visit(expr);
    }

    @Override
    protected WasmExpression generateInstanceOf(WasmExpression expression, ValueType type) {
        this.classGenerator.getClassPointer(type);
        WasmCall supertypeCall = new WasmCall(this.context.functions().forSupertype(type));
        WasmExpression classRef = new WasmLoadInt32(4, expression, WasmInt32Subtype.INT32);
        classRef = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, classRef, new WasmInt32Constant(3));
        supertypeCall.getArguments().add(classRef);
        return supertypeCall;
    }

    @Override
    protected void generateThrowCCE(TextLocation location, List<WasmExpression> target) {
        WasmCall call = new WasmCall(this.context.functions().forStaticMethod(THROW_CCE_METHOD));
        call.setLocation(location);
        target.add(call);
    }

    @Override
    protected WasmExpression generateClassInitializer(String className, TextLocation location) {
        WasmCall call = new WasmCall(this.context.functions().forClassInitializer(className));
        call.setLocation(location);
        return call;
    }

    @Override
    protected boolean needsClassInitializer(String className) {
        return this.classGenerator.hasClinit(className);
    }

    @Override
    protected void generateTry(List<TryCatchStatement> tryCatchStatements, List<Statement> protectedBody) {
        if (this.context.getExceptionTag() == null) {
            this.emulatedTry(tryCatchStatements, protectedBody);
        } else {
            super.generateTry(tryCatchStatements, protectedBody);
        }
    }

    private void emulatedTry(List<TryCatchStatement> tryCatchStatements, List<Statement> protectedBody) {
        boolean isTopMostTryCatch;
        int firstId = this.handlers.size();
        WasmBlock innerCatchBlock = new WasmBlock(false);
        WasmBlock bodyBlock = new WasmBlock(false);
        bodyBlock.setType(WasmType.INT32.asBlock());
        boolean bl = isTopMostTryCatch = this.lastTryBlock == null;
        if (isTopMostTryCatch) {
            this.catchLabels.add(this.rethrowBlock());
        }
        ArrayList<WasmBlock> catchBlocks = new ArrayList<WasmBlock>();
        for (int i = 0; i < tryCatchStatements.size(); ++i) {
            TryCatchStatement tryCatch = tryCatchStatements.get(i);
            this.handlers.add(new ExceptionHandlerDescriptor(firstId + i, tryCatch.getExceptionType()));
            catchBlocks.add(new WasmBlock(false));
        }
        WasmBlock outerCatchBlock = (WasmBlock)catchBlocks.get(0);
        this.catchLabels.addAll(catchBlocks.subList(1, catchBlocks.size()));
        this.catchLabels.add(innerCatchBlock);
        WasmBlock lastTryBlockBackup = this.lastTryBlock;
        this.lastTryBlock = bodyBlock;
        this.visitMany(protectedBody, bodyBlock.getBody());
        this.lastTryBlock = lastTryBlockBackup;
        this.handlers.subList(firstId, this.handlers.size()).clear();
        if (!bodyBlock.isTerminating()) {
            bodyBlock.getBody().add(new WasmBreak(outerCatchBlock));
        }
        WasmBlock currentBlock = innerCatchBlock;
        WasmIntBinary handlerIdExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, bodyBlock, new WasmInt32Constant(1));
        WasmSwitch switchExpr = new WasmSwitch(handlerIdExpr, outerCatchBlock);
        switchExpr.getTargets().addAll(this.catchLabels);
        innerCatchBlock.getBody().add(switchExpr);
        this.catchLabels.subList(this.catchLabels.size() - tryCatchStatements.size(), this.catchLabels.size()).clear();
        if (isTopMostTryCatch) {
            this.catchLabels.remove(this.catchLabels.size() - 1);
            assert (this.catchLabels.isEmpty());
        }
        for (int i = tryCatchStatements.size() - 1; i >= 0; --i) {
            TryCatchStatement tryCatch = tryCatchStatements.get(i);
            WasmBlock catchBlock = (WasmBlock)catchBlocks.get(i);
            catchBlock.getBody().add(currentBlock);
            WasmFunction catchFunction = this.context.functions().forStaticMethod(CATCH_METHOD);
            WasmCall catchCall = new WasmCall(catchFunction);
            WasmExpression catchWrapper = tryCatch.getExceptionVariable() != null ? new WasmSetLocal(this.localVar(tryCatch.getExceptionVariable()), catchCall) : new WasmDrop(catchCall);
            catchBlock.getBody().add(catchWrapper);
            this.visitMany(tryCatch.getHandler(), catchBlock.getBody());
            if (!catchBlock.isTerminating() && catchBlock != outerCatchBlock) {
                catchBlock.getBody().add(new WasmBreak(outerCatchBlock));
            }
            currentBlock = catchBlock;
        }
        this.resultConsumer.add(outerCatchBlock);
    }

    private WasmBlock rethrowBlock() {
        if (this.rethrowBlock == null) {
            this.rethrowBlock = new WasmBlock(false);
        }
        return this.rethrowBlock;
    }

    private void visitMany(List<Statement> statements, List<WasmExpression> target) {
        List oldTarget = this.resultConsumer;
        this.resultConsumer = target;
        for (Statement part : statements) {
            this.accept(part);
        }
        this.resultConsumer = oldTarget;
    }

    @Override
    protected void generateThrowAIOOBE(TextLocation location, List<WasmExpression> target) {
        WasmCall call = new WasmCall(this.context.functions().forStaticMethod(THROW_AIOOBE_METHOD));
        call.setLocation(location);
        target.add(call);
    }

    private class CallSiteIdentifierImpl
    extends BaseWasmGenerationVisitor.CallSiteIdentifier
    implements WasmIntrinsicManager.CallSiteIdentifier {
        private int id;

        CallSiteIdentifierImpl(int id) {
            super(WasmGenerationVisitor.this);
            this.id = id;
        }

        @Override
        public void generateRegister(List<WasmExpression> consumer, TextLocation location) {
            if (!WasmGenerationVisitor.this.managed) {
                return;
            }
            WasmStoreInt32 result = new WasmStoreInt32(4, new WasmGetLocal(WasmGenerationVisitor.this.stackVariable), new WasmInt32Constant(this.id), WasmInt32Subtype.INT32);
            result.setLocation(location);
            consumer.add(result);
        }

        @Override
        public void checkHandlerId(List<WasmExpression> target, TextLocation location) {
            if (WasmGenerationVisitor.this.context.getExceptionTag() != null) {
                return;
            }
            WasmBlock jumpTarget = WasmGenerationVisitor.this.throwJumpTarget();
            if (jumpTarget == WasmGenerationVisitor.this.rethrowBlock) {
                WasmExpression handlerId = this.generateGetHandlerId(location);
                WasmBranch br = new WasmBranch(handlerId, WasmGenerationVisitor.this.throwJumpTarget());
                target.add(br);
            } else {
                WasmLocal handlerVar = WasmGenerationVisitor.this.tempVars.acquire(WasmType.INT32);
                WasmExpression handlerId = this.generateGetHandlerId(location);
                WasmSetLocal saveHandler = new WasmSetLocal(handlerVar, handlerId);
                saveHandler.setLocation(location);
                target.add(saveHandler);
                WasmBranch br = new WasmBranch(new WasmGetLocal(handlerVar), WasmGenerationVisitor.this.throwJumpTarget());
                br.setResult(new WasmGetLocal(handlerVar));
                WasmDrop dropBr = new WasmDrop(br);
                dropBr.setLocation(location);
                target.add(dropBr);
                WasmGenerationVisitor.this.tempVars.release(handlerVar);
            }
        }

        @Override
        public void generateThrow(List<WasmExpression> target, TextLocation location) {
            if (WasmGenerationVisitor.this.context.getExceptionTag() == null) {
                WasmBlock throwTarget = WasmGenerationVisitor.this.throwJumpTarget();
                WasmBreak breakExpr = new WasmBreak(throwTarget);
                if (throwTarget != WasmGenerationVisitor.this.rethrowBlock) {
                    breakExpr.setResult(this.generateGetHandlerId(location));
                    target.add(new WasmDrop(breakExpr));
                } else {
                    target.add(breakExpr);
                }
            } else {
                target.add(new WasmUnreachable());
            }
        }

        private WasmExpression generateGetHandlerId(TextLocation location) {
            WasmExpression handlerId = new WasmLoadInt32(4, new WasmGetLocal(WasmGenerationVisitor.this.stackVariable), WasmInt32Subtype.INT32);
            handlerId = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, handlerId, new WasmInt32Constant(this.id));
            handlerId.setLocation(location);
            return handlerId;
        }
    }
}

