/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.dependency.DefaultCallGraphNode;
import org.teavm.dependency.DefaultCallSite;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.CallLocation;
import org.teavm.model.MethodReference;

class FastVirtualCallConsumer
implements DependencyConsumer {
    private final DependencyNode node;
    private final MethodReference methodRef;
    private final DependencyAnalyzer analyzer;
    private final Map<MethodReference, CallLocation> callLocations = new LinkedHashMap<MethodReference, CallLocation>();
    private final Set<MethodDependency> methods = new LinkedHashSet<MethodDependency>(100, 0.5f);
    final DefaultCallSite callSite;

    FastVirtualCallConsumer(DependencyNode node, MethodReference methodRef, DependencyAnalyzer analyzer) {
        this.node = node;
        this.methodRef = methodRef;
        this.analyzer = analyzer;
        this.callSite = analyzer.callGraph.getNode(methodRef).getVirtualCallSite();
    }

    @Override
    public void consume(DependencyType type) {
        MethodDependency methodDep;
        String className = type.getName();
        if (DependencyAnalyzer.shouldLog) {
            System.out.println("Virtual call of " + String.valueOf(this.methodRef) + " detected on " + this.node.getTag() + ". Target class is " + className);
        }
        if (className.startsWith("[")) {
            className = "java.lang.Object";
        }
        if (!this.methods.add(methodDep = this.analyzer.linkMethod(className, this.methodRef.getDescriptor()))) {
            return;
        }
        DefaultCallGraphNode calledMethodNode = this.analyzer.callGraph.getNode(methodDep.getReference());
        this.callSite.calledMethods.add(calledMethodNode);
        calledMethodNode.addCaller(this.callSite);
        for (CallLocation location : this.callLocations.values()) {
            methodDep.addLocation(location, false);
        }
        if (!methodDep.isMissing()) {
            methodDep.use();
        }
    }

    void addLocation(CallLocation location) {
        if (this.callLocations.putIfAbsent(location.getMethod(), location) == null) {
            DefaultCallGraphNode caller = this.analyzer.callGraph.getNode(location.getMethod());
            caller.addVirtualCallSite(this.callSite);
            if (location.getSourceLocation() != null) {
                this.callSite.addLocation(caller, location.getSourceLocation());
            }
            for (MethodDependency method : this.methods) {
                method.addLocation(location, false);
            }
        }
    }
}

