/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;

public class HeapIntrinsic
implements WasmGCIntrinsic {
    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmLocal pagesVar = context.tempVars().acquire(WasmType.INT32);
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        WasmExpression bytes = context.generate(invocation.getArguments().get(0));
        WasmIntBinary pages = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, bytes, new WasmInt32Constant(1));
        pages = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.DIV_UNSIGNED, pages, new WasmInt32Constant(65536));
        pages = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, pages, new WasmInt32Constant(1));
        block.getBody().add(new WasmSetLocal(pagesVar, pages));
        WasmMemoryGrow grow = new WasmMemoryGrow(new WasmGetLocal(pagesVar));
        block.getBody().add(new WasmDrop(grow));
        block.getBody().add(new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.MUL, new WasmGetLocal(pagesVar), new WasmInt32Constant(65536)));
        context.tempVars().release(pagesVar);
        return block;
    }
}

