/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.Program;
import org.teavm.model.analysis.NullnessInformation;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.optimization.MethodOptimization;
import org.teavm.model.optimization.MethodOptimizationContext;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.ProgramUtils;

public class RedundantNullCheckElimination
implements MethodOptimization {
    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        NullnessInformation nullness = NullnessInformation.build(program, context.getMethod().getDescriptor());
        boolean hasChanges = false;
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                NullCheckInstruction nullCheck;
                if (!(instruction instanceof NullCheckInstruction) || nullness.isSynthesized((nullCheck = (NullCheckInstruction)instruction).getReceiver())) continue;
                if (nullness.isNotNull(nullCheck.getValue())) {
                    AssignInstruction assign = new AssignInstruction();
                    assign.setAssignee(nullCheck.getValue());
                    assign.setReceiver(nullCheck.getReceiver());
                    assign.setLocation(nullCheck.getLocation());
                    nullCheck.replace(assign);
                    hasChanges = true;
                    continue;
                }
                if (!nullness.isNull(nullCheck.getValue())) continue;
                block.detachSuccessors();
                while (nullCheck.getNext() != null) {
                    nullCheck.getNext().delete();
                }
                nullCheck.insertPreviousAll(ProgramUtils.createThrowNPEInstructions(program, nullCheck.getLocation()));
                nullCheck.delete();
                hasChanges = true;
            }
        }
        if (hasChanges) {
            new UnreachableBasicBlockEliminator().optimize(program);
        }
        nullness.dispose();
        return hasChanges;
    }
}

