/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.parser;

import java.nio.charset.StandardCharsets;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.parser.AddressListener;
import org.teavm.backend.wasm.parser.ParseException;
import org.teavm.backend.wasm.parser.WasmHollowStorageType;
import org.teavm.backend.wasm.parser.WasmHollowType;

public class WasmBinaryReader {
    private final AddressListener addressListener;
    public final byte[] data;
    public int ptr;
    private int lastReportedPtr = -1;

    public WasmBinaryReader(AddressListener addressListener, byte[] data) {
        this.addressListener = addressListener;
        this.data = data;
    }

    public void reportAddress() {
        if (this.ptr != this.lastReportedPtr) {
            this.lastReportedPtr = this.ptr;
            if (this.addressListener != null) {
                this.addressListener.address(this.ptr);
            }
        }
    }

    public WasmHollowStorageType readStorageType() {
        byte typeId = this.data[this.ptr];
        switch (typeId) {
            case 120: {
                ++this.ptr;
                return WasmHollowStorageType.INT8;
            }
            case 119: {
                ++this.ptr;
                return WasmHollowStorageType.INT16;
            }
        }
        return new WasmHollowStorageType.Regular(this.readType());
    }

    public WasmHollowType readType() {
        byte typeId = this.data[this.ptr++];
        switch (typeId) {
            case 127: {
                return WasmHollowType.INT32;
            }
            case 126: {
                return WasmHollowType.INT64;
            }
            case 125: {
                return WasmHollowType.FLOAT32;
            }
            case 124: {
                return WasmHollowType.FLOAT64;
            }
            case 99: {
                return this.readHeapType(true);
            }
            case 100: {
                return this.readHeapType(false);
            }
            case 64: {
                return null;
            }
        }
        return this.readAbsHeapType(typeId, true);
    }

    public WasmHollowType.Reference readHeapType(boolean nullable) {
        byte typeId = this.data[this.ptr];
        if ((typeId & 0xC0) == 64) {
            WasmHollowType.SpecialReference result = this.readAbsHeapType(typeId, nullable);
            ++this.ptr;
            return result;
        }
        return new WasmHollowType.CompositeReference(this.readLEB(), nullable);
    }

    public WasmHollowType.SpecialReference readAbsHeapType(int typeId, boolean nullable) {
        switch (typeId) {
            case 112: {
                return WasmBinaryReader.special(WasmType.SpecialReferenceKind.FUNC, nullable);
            }
            case 111: {
                return WasmBinaryReader.special(WasmType.SpecialReferenceKind.EXTERN, nullable);
            }
            case 110: {
                return WasmBinaryReader.special(WasmType.SpecialReferenceKind.ANY, nullable);
            }
            case 109: {
                return WasmBinaryReader.special(WasmType.SpecialReferenceKind.EQ, nullable);
            }
            case 108: {
                return WasmBinaryReader.special(WasmType.SpecialReferenceKind.I31, nullable);
            }
            case 107: {
                return WasmBinaryReader.special(WasmType.SpecialReferenceKind.STRUCT, nullable);
            }
            case 106: {
                return WasmBinaryReader.special(WasmType.SpecialReferenceKind.ARRAY, nullable);
            }
        }
        throw new ParseException("Unknown type", this.ptr);
    }

    private static WasmHollowType.SpecialReference special(WasmType.SpecialReferenceKind kind, boolean nullable) {
        return nullable ? WasmHollowType.Reference.special(kind) : WasmHollowType.SpecialReference.nonNullSpecial(kind);
    }

    public int readSignedLEB() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte digit = this.data[this.ptr++];
            result |= (digit & 0x7F) << shift;
            if ((digit & 0x80) == 0) {
                if ((digit & 0x40) == 0) break;
                result |= -1 << shift + 7;
                break;
            }
            shift += 7;
        }
        return result;
    }

    public int readLEB() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte digit = this.data[this.ptr++];
            result |= (digit & 0x7F) << shift;
            if ((digit & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    public long readSignedLongLEB() {
        long result = 0L;
        int shift = 0;
        while (true) {
            byte digit = this.data[this.ptr++];
            result |= ((long)digit & 0x7FL) << shift;
            if ((digit & 0x80) == 0) {
                if ((digit & 0x40) == 0) break;
                result |= -1L << shift + 7;
                break;
            }
            shift += 7;
        }
        return result;
    }

    public long readLongLEB() {
        long result = 0L;
        int shift = 0;
        while (true) {
            byte digit = this.data[this.ptr++];
            result |= ((long)digit & 0x7FL) << shift;
            if ((digit & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    public int readInt32() {
        return this.data[this.ptr++] & 0xFF | (this.data[this.ptr++] & 0xFF) << 8 | (this.data[this.ptr++] & 0xFF) << 16 | (this.data[this.ptr++] & 0xFF) << 24;
    }

    public int readFixedInt() {
        return (this.data[this.ptr++] & 0xFF) << 24 | (this.data[this.ptr++] & 0xFF) << 16 | (this.data[this.ptr++] & 0xFF) << 8 | this.data[this.ptr++] & 0xFF;
    }

    public long readFixedLong() {
        return ((long)this.data[this.ptr++] & 0xFFL) << 56 | ((long)this.data[this.ptr++] & 0xFFL) << 48 | ((long)this.data[this.ptr++] & 0xFFL) << 40 | ((long)this.data[this.ptr++] & 0xFFL) << 32 | ((long)this.data[this.ptr++] & 0xFFL) << 24 | (long)((this.data[this.ptr++] & 0xFF) << 16) | (long)((this.data[this.ptr++] & 0xFF) << 8) | (long)(this.data[this.ptr++] & 0xFF);
    }

    public String readString() {
        int size = this.readLEB();
        String result = new String(this.data, this.ptr, size, StandardCharsets.UTF_8);
        this.ptr += size;
        return result;
    }
}

