/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import java.lang.annotation.Annotation;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullCondition;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.model.ValueType;

public class ClassIntrinsic
implements WasmGCIntrinsic {
    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "getWasmGCFlags": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassFlagsOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getComponentType": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassArrayItemOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getEnclosingClass": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassEnclosingClassOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getDeclaringClass": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassDeclaringClassOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getSuperclass": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassParentOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getNameImpl": {
                return this.generateGetName(invocation, context);
            }
            case "setNameImpl": {
                return this.generateSetName(invocation, context);
            }
            case "getSimpleNameCache": {
                return this.generateGetSimpleName(invocation, context);
            }
            case "setSimpleNameCache": {
                return this.generateSetSimpleName(invocation, context);
            }
            case "getCanonicalNameCache": {
                return this.generateGetCanonicalName(invocation, context);
            }
            case "setCanonicalNameCache": {
                return this.generateSetCanonicalName(invocation, context);
            }
            case "getDeclaredAnnotationsImpl": {
                return this.generateGetDeclaredAnnotations(invocation, context);
            }
            case "getInterfacesImpl": {
                return this.generateGetInterfaces(invocation, context);
            }
            case "getDeclaredFieldsImpl": {
                return this.generateGetDeclaredFields(invocation, context);
            }
            case "getDeclaredMethodsImpl": {
                return this.generateGetDeclaredMethods(invocation, context);
            }
            case "last": {
                return new WasmGetGlobal(context.classInfoProvider().getLastRegularClassGlobal());
            }
            case "previous": {
                return new WasmStructGet(context.classInfoProvider().getClassInfo("java.lang.Class").getStructure(), context.generate(invocation.getArguments().get(0)), context.classInfoProvider().getPreviousRegularClassOffset());
            }
            case "initializeImpl": {
                return this.generateInitialize(invocation, context);
            }
        }
        throw new IllegalArgumentException("Unsupported invocation method: " + String.valueOf(invocation.getMethod()));
    }

    private WasmExpression generateGetName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        return new WasmStructGet(classCls.getStructure(), arg, context.classInfoProvider().getClassNameOffset());
    }

    private WasmExpression generateSetName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        WasmExpression value = context.generate(invocation.getArguments().get(1));
        return new WasmStructSet(classCls.getStructure(), arg, context.classInfoProvider().getClassNameOffset(), value);
    }

    private WasmExpression generateGetSimpleName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        return new WasmStructGet(classCls.getStructure(), arg, context.classInfoProvider().getClassSimpleNameOffset());
    }

    private WasmExpression generateSetSimpleName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        WasmExpression value = context.generate(invocation.getArguments().get(1));
        return new WasmStructSet(classCls.getStructure(), arg, context.classInfoProvider().getClassSimpleNameOffset(), value);
    }

    private WasmExpression generateGetCanonicalName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        return new WasmStructGet(classCls.getStructure(), arg, context.classInfoProvider().getClassCanonicalNameOffset());
    }

    private WasmExpression generateSetCanonicalName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        WasmExpression value = context.generate(invocation.getArguments().get(1));
        return new WasmStructSet(classCls.getStructure(), arg, context.classInfoProvider().getClassCanonicalNameOffset(), value);
    }

    private WasmExpression generateGetDeclaredAnnotations(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmGCGenerationUtil util = new WasmGCGenerationUtil(context.classInfoProvider());
        return util.allocateArray(ValueType.parse(Annotation.class), a -> {
            WasmBlock block = new WasmBlock(false);
            block.setType(a.getNonNullReference());
            WasmExpression arg = context.generate(invocation.getArguments().get(0));
            WasmStructGet annotationsData = new WasmStructGet(classCls.getStructure(), arg, context.classInfoProvider().getClassAnnotationsOffset());
            WasmNullBranch nullCheck = new WasmNullBranch(WasmNullCondition.NOT_NULL, annotationsData, block);
            block.getBody().add(nullCheck);
            block.getBody().add(new WasmArrayNewFixed((WasmArray)a));
            return block;
        });
    }

    private WasmExpression generateGetInterfaces(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmGCGenerationUtil util = new WasmGCGenerationUtil(context.classInfoProvider());
        return util.allocateArray(ValueType.parse(Class.class), a -> {
            WasmBlock block = new WasmBlock(false);
            block.setType(a.getNonNullReference());
            WasmExpression arg = context.generate(invocation.getArguments().get(0));
            WasmStructGet interfacesData = new WasmStructGet(classCls.getStructure(), arg, context.classInfoProvider().getClassInterfacesOffset());
            WasmNullBranch nullCheck = new WasmNullBranch(WasmNullCondition.NOT_NULL, interfacesData, block);
            block.getBody().add(nullCheck);
            block.getBody().add(new WasmArrayNewFixed((WasmArray)a));
            return block;
        });
    }

    private WasmExpression generateGetDeclaredFields(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        int fieldIndex = context.classInfoProvider().getClassFieldsOffset();
        if (fieldIndex < 0) {
            return new WasmUnreachable();
        }
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        return new WasmStructGet(classCls.getStructure(), arg, fieldIndex);
    }

    private WasmExpression generateGetDeclaredMethods(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        int fieldIndex = context.classInfoProvider().getClassMethodsOffset();
        if (fieldIndex < 0) {
            return new WasmUnreachable();
        }
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        return new WasmStructGet(classCls.getStructure(), arg, fieldIndex);
    }

    private WasmExpression generateInitialize(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmBlock block = new WasmBlock(false);
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmStructGet getField = new WasmStructGet(classCls.getStructure(), context.generate(invocation.getArguments().get(0)), context.classInfoProvider().getClassInitializerOffset());
        WasmNullBranch br = new WasmNullBranch(WasmNullCondition.NULL, getField, block);
        block.getBody().add(new WasmCallReference(br, context.functionTypes().of(null, new WasmType[0])));
        return block;
    }
}

