/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug;

import java.util.Objects;
import org.teavm.backend.wasm.debug.DebugFiles;
import org.teavm.backend.wasm.debug.DebugSectionBuilder;
import org.teavm.backend.wasm.debug.DebugStrings;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;

public class DebugFilesBuilder
extends DebugSectionBuilder
implements DebugFiles {
    private DebugStrings strings;
    private ObjectIntMap<FileData> fileMap = new ObjectIntHashMap();

    public DebugFilesBuilder(DebugStrings strings) {
        super("teavm_file");
        this.strings = strings;
    }

    @Override
    public int filePtr(String fileName) {
        int next;
        int index = 0;
        int current = 0;
        while ((next = fileName.indexOf(47, index)) >= 0) {
            String dirName = fileName.substring(index, next);
            current = this.filePtr(current, dirName);
            index = next + 1;
        }
        return this.filePtr(current, fileName.substring(index));
    }

    private int filePtr(int parent, String fileName) {
        FileData data = new FileData(parent, fileName);
        int ptr = this.fileMap.getOrDefault((Object)data, 0);
        if (ptr == 0) {
            ptr = this.fileMap.size() + 1;
            this.fileMap.put((Object)data, ptr);
            this.blob.writeLEB(parent);
            int extensionIndex = fileName.lastIndexOf(46);
            if (extensionIndex < 0) {
                this.blob.writeLEB(this.strings.stringPtr(fileName) << 1);
            } else {
                this.blob.writeLEB(1 | this.strings.stringPtr(fileName.substring(0, extensionIndex)) << 1);
                this.blob.writeLEB(this.strings.stringPtr(fileName.substring(extensionIndex + 1)));
            }
        }
        return ptr;
    }

    private static class FileData {
        private final int parent;
        private final String name;

        FileData(int parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileData fileData = (FileData)o;
            return this.parent == fileData.parent && this.name.equals(fileData.name);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.name);
        }
    }
}

