/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.analyze;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.interop.Import;
import org.teavm.interop.Structure;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class InteropDependencyListener
extends AbstractDependencyListener {
    @Override
    public void classReached(DependencyAgent agent, String className) {
        ClassReader cls;
        if (agent.getClassHierarchy().isSuperType(Structure.class.getName(), className, false) && (cls = agent.getClassSource().get(className)) != null) {
            this.reachFields(agent, cls);
        }
    }

    private void reachFields(DependencyAgent agent, ClassReader cls) {
        for (FieldReader fieldReader : cls.getFields()) {
            if (fieldReader.hasModifier(ElementModifier.STATIC)) continue;
            agent.linkField(fieldReader.getReference());
            this.reachType(agent, fieldReader.getType());
        }
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (method.isMissing() || !method.getMethod().hasModifier(ElementModifier.NATIVE)) {
            return;
        }
        AnnotationReader importAnnot = method.getMethod().getAnnotations().get(Import.class.getName());
        if (importAnnot == null) {
            return;
        }
        MethodReference reference = method.getReference();
        if (reference.getReturnType().isObject("java.lang.String")) {
            method.getResult().propagate(agent.getType("java.lang.String"));
        }
        for (int i = 0; i < reference.parameterCount(); ++i) {
            this.reachType(agent, reference.parameterType(i));
        }
    }

    private void reachType(DependencyAgent agent, ValueType type) {
        if (type instanceof ValueType.Object) {
            String fieldClassName = ((ValueType.Object)type).getClassName();
            if (agent.getClassHierarchy().isSuperType(Structure.class.getName(), fieldClassName, false)) {
                agent.linkClass(fieldClassName);
            }
        }
    }
}

