/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmCompositeTypeVisitor;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStorageType;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.render.WasmBinaryWriter;

public class WasmCompositeTypeBinaryRenderer
implements WasmCompositeTypeVisitor {
    private WasmModule module;
    private WasmBinaryWriter section;

    public WasmCompositeTypeBinaryRenderer(WasmModule module, WasmBinaryWriter section) {
        this.module = module;
        this.section = section;
    }

    @Override
    public void visit(WasmStructure type) {
        this.section.writeByte(80);
        if (type.getSupertype() != null) {
            this.section.writeLEB(1);
            this.section.writeLEB(this.module.types.indexOf(type.getSupertype()));
        } else {
            this.section.writeLEB(0);
        }
        this.section.writeByte(95);
        this.section.writeLEB(type.getFields().size());
        for (WasmField fieldType : type.getFields()) {
            this.writeStorageType(fieldType.getType());
            this.section.writeLEB(fieldType.isImmutable() ? 0 : 1);
        }
    }

    @Override
    public void visit(WasmArray type) {
        this.section.writeByte(94);
        this.writeStorageType(type.getElementType());
        this.section.writeLEB(type.isImmutable() ? 0 : 1);
    }

    @Override
    public void visit(WasmFunctionType type) {
        if (!type.isFinal() || !type.getSupertypes().isEmpty()) {
            this.section.writeByte(80);
            this.section.writeLEB(type.getSupertypes().size());
            for (WasmFunctionType wasmFunctionType : type.getSupertypes()) {
                this.section.writeLEB(this.module.types.indexOf(wasmFunctionType));
            }
        }
        this.section.writeByte(96);
        this.section.writeLEB(type.getParameterTypes().size());
        for (WasmType wasmType : type.getParameterTypes()) {
            this.section.writeType(wasmType, this.module);
        }
        if (type.getReturnType() != null) {
            this.section.writeByte(1);
            this.section.writeType(type.getReturnType(), this.module);
        } else {
            this.section.writeByte(0);
        }
    }

    private void writeStorageType(WasmStorageType storageType) {
        if (storageType instanceof WasmStorageType.Packed) {
            switch (((WasmStorageType.Packed)storageType).type) {
                case INT8: {
                    this.section.writeByte(120);
                    break;
                }
                case INT16: {
                    this.section.writeByte(119);
                }
            }
        } else {
            this.section.writeType(storageType.asUnpackedType(), this.module);
        }
    }
}

