/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generators.gc;

import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class StringGenerator
implements WasmGCCustomGenerator {
    @Override
    public void apply(MethodReference method, WasmFunction function, WasmGCCustomGeneratorContext context) {
        WasmFunction worker = context.functions().forStaticMethod(new MethodReference(StringInternPool.class, "query", String.class, String.class));
        WasmType stringType = context.typeMapper().mapType(ValueType.parse(String.class));
        WasmType instanceType = context.isCompactMode() ? WasmType.Reference.ANY : stringType;
        WasmLocal instanceLocal = new WasmLocal(instanceType, "this");
        function.add(instanceLocal);
        WasmExpression instance = new WasmGetLocal(instanceLocal);
        if (context.isCompactMode()) {
            instance = new WasmCast(instance, (WasmType.Reference)stringType);
        }
        function.getBody().add(new WasmCall(worker, instance));
    }
}

