/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.parser;

import java.util.Objects;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmType;

public class WasmHollowType {
    public static final Number INT32 = new Number(WasmNumType.INT32);
    public static final Number INT64 = new Number(WasmNumType.INT64);
    public static final Number FLOAT32 = new Number(WasmNumType.FLOAT32);
    public static final Number FLOAT64 = new Number(WasmNumType.FLOAT64);

    private WasmHollowType() {
    }

    public static Number num(WasmNumType number) {
        switch (number) {
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case FLOAT32: {
                return FLOAT32;
            }
            case FLOAT64: {
                return FLOAT64;
            }
        }
        throw new IllegalArgumentException();
    }

    public static final class Number
    extends WasmHollowType {
        public final WasmNumType number;

        private Number(WasmNumType number) {
            this.number = number;
        }
    }

    public static final class SpecialReference
    extends Reference {
        public final WasmType.SpecialReferenceKind kind;

        SpecialReference(WasmType.SpecialReferenceKind kind, boolean nullable) {
            super(nullable);
            this.kind = kind;
        }
    }

    public static final class CompositeReference
    extends Reference {
        public final int index;

        public CompositeReference(int index, boolean nullable) {
            super(nullable);
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompositeReference)) {
                return false;
            }
            CompositeReference that = (CompositeReference)o;
            return this.index == that.index && this.isNullable() == that.isNullable();
        }

        public int hashCode() {
            return Objects.hash(this.index, this.isNullable());
        }
    }

    public static abstract class Reference
    extends WasmHollowType {
        private static final SpecialReference[] references = new SpecialReference[WasmType.SpecialReferenceKind.values().length];
        private static final SpecialReference[] nonNullReferences = new SpecialReference[WasmType.SpecialReferenceKind.values().length];
        private final boolean nullable;

        public Reference(boolean nullable) {
            this.nullable = nullable;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public static SpecialReference special(WasmType.SpecialReferenceKind kind) {
            SpecialReference result = references[kind.ordinal()];
            if (result == null) {
                Reference.references[kind.ordinal()] = result = new SpecialReference(kind, true);
            }
            return result;
        }

        public static SpecialReference nonNullSpecial(WasmType.SpecialReferenceKind kind) {
            SpecialReference result = nonNullReferences[kind.ordinal()];
            if (result == null) {
                Reference.nonNullReferences[kind.ordinal()] = result = new SpecialReference(kind, false);
            }
            return result;
        }
    }
}

