/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapper;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmPackedType;
import org.teavm.backend.wasm.model.WasmStorageType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.interop.Address;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.ValueType;

public class WasmGCTypeMapper {
    private ClassReaderSource classes;
    private WasmGCClassInfoProvider classInfoProvider;
    private WasmFunctionTypes functionTypes;
    private List<WasmGCCustomTypeMapper> customTypeMappers;
    private Map<String, WasmType> typeCache = new HashMap<String, WasmType>();

    WasmGCTypeMapper(ClassReaderSource classes, WasmGCClassInfoProvider classInfoProvider, WasmFunctionTypes functionTypes) {
        this.classes = classes;
        this.classInfoProvider = classInfoProvider;
        this.functionTypes = functionTypes;
    }

    void setCustomTypeMappers(List<WasmGCCustomTypeMapper> customTypeMappers) {
        this.customTypeMappers = List.copyOf(customTypeMappers);
    }

    public WasmStorageType mapStorageType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BYTE: 
                case BOOLEAN: {
                    return WasmStorageType.packed(WasmPackedType.INT8);
                }
                case SHORT: 
                case CHARACTER: {
                    return WasmStorageType.packed(WasmPackedType.INT16);
                }
                case INTEGER: {
                    return WasmType.INT32.asStorage();
                }
                case LONG: {
                    return WasmType.INT64.asStorage();
                }
                case FLOAT: {
                    return WasmType.FLOAT32.asStorage();
                }
                case DOUBLE: {
                    return WasmType.FLOAT64.asStorage();
                }
            }
            throw new IllegalArgumentException();
        }
        return this.mapType(type).asStorage();
    }

    public WasmType mapType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BYTE: 
                case BOOLEAN: 
                case SHORT: 
                case CHARACTER: 
                case INTEGER: {
                    return WasmType.INT32;
                }
                case LONG: {
                    return WasmType.INT64;
                }
                case FLOAT: {
                    return WasmType.FLOAT32;
                }
                case DOUBLE: {
                    return WasmType.FLOAT64;
                }
            }
            throw new IllegalArgumentException();
        }
        if (type instanceof ValueType.Void) {
            return null;
        }
        if (type instanceof ValueType.Object) {
            return this.mapClassType(((ValueType.Object)type).getClassName());
        }
        if (type instanceof ValueType.Array) {
            String className;
            ClassReader cls;
            int degree = 0;
            while (type instanceof ValueType.Array) {
                type = ((ValueType.Array)type).getItemType();
                ++degree;
            }
            if (type instanceof ValueType.Object && (cls = this.classes.get(className = ((ValueType.Object)type).getClassName())) == null) {
                type = ValueType.object("java.lang.Object");
            }
            while (degree-- > 0) {
                type = ValueType.arrayOf(type);
            }
            return this.classInfoProvider.getClassInfo(type).getType();
        }
        throw new IllegalArgumentException();
    }

    private WasmType mapClassType(String className) {
        WasmType result = this.typeCache.get(className);
        if (result == null) {
            WasmGCCustomTypeMapper customMapper;
            Iterator<WasmGCCustomTypeMapper> iterator = this.customTypeMappers.iterator();
            while (iterator.hasNext() && (result = (customMapper = iterator.next()).map(className)) == null) {
            }
            if (result == null) {
                if (className.equals(Address.class.getName())) {
                    result = WasmType.INT32;
                } else {
                    WasmGCClassInfo classInfo;
                    ClassReader cls = this.classes.get(className);
                    if (cls == null) {
                        className = "java.lang.Object";
                    }
                    result = (classInfo = this.classInfoProvider.getClassInfo(className)).isHeapStructure() ? WasmType.INT32 : classInfo.getType();
                }
                this.typeCache.put(className, result);
            }
        }
        return result;
    }

    public WasmFunctionType getFunctionType(WasmType receiverType, MethodDescriptor methodDesc) {
        WasmType returnType = this.mapType(methodDesc.getResultType());
        ValueType[] javaParamTypes = methodDesc.getParameterTypes();
        WasmType[] paramTypes = new WasmType[javaParamTypes.length + 1];
        paramTypes[0] = receiverType;
        for (int i = 0; i < javaParamTypes.length; ++i) {
            paramTypes[i + 1] = this.mapType(javaParamTypes[i]);
        }
        return this.functionTypes.of(returnType, paramTypes);
    }

    public WasmFunctionType getFunctionType(String className, MethodDescriptor methodDesc) {
        return this.getFunctionType(this.classInfoProvider.getClassInfo(className).getType(), methodDesc);
    }
}

