/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.teavm.backend.wasm.debug.info.VariableInfo;
import org.teavm.backend.wasm.debug.info.VariableRangeInfo;
import org.teavm.backend.wasm.debug.info.VariableType;
import org.teavm.backend.wasm.debug.info.VariablesInfo;
import org.teavm.backend.wasm.debug.parser.DebugSectionParser;
import org.teavm.backend.wasm.debug.parser.DebugStringParser;

public class DebugVariablesParser
extends DebugSectionParser {
    private static final VariableType[] typeByOrdinal = VariableType.values();
    private DebugStringParser strings;
    private VariablesInfoImpl variablesInfo;

    public DebugVariablesParser(DebugStringParser strings) {
        super("teavm_var", strings);
        this.strings = strings;
    }

    public VariablesInfoImpl getVariablesInfo() {
        return this.variablesInfo;
    }

    @Override
    protected void doParse() {
        int lastAddress = 0;
        ArrayList<VariableRangeInfo> ranges = new ArrayList<VariableRangeInfo>();
        ArrayList<VariableRangeInfoImpl> localRanges = new ArrayList<VariableRangeInfoImpl>();
        while (this.ptr < this.data.length) {
            int baseAddress;
            lastAddress = baseAddress = lastAddress + this.readLEB();
            int variableCount = this.readLEB();
            for (int i = 0; i < variableCount; ++i) {
                String name = this.strings.getString(this.readLEB());
                VariableType type = typeByOrdinal[this.readLEB()];
                int rangeCount = this.readLEB();
                VariableInfoImpl varInfo = new VariableInfoImpl(name, type);
                int address = baseAddress;
                int lastLocation = 0;
                for (int j = 0; j < rangeCount; ++j) {
                    int location;
                    int end;
                    int start = address + this.readSignedLEB();
                    int size = this.readLEB();
                    address = end = start + size;
                    lastLocation = location = lastLocation + this.readSignedLEB();
                    VariableRangeInfoImpl rangeInfo = new VariableRangeInfoImpl(varInfo, start, end, location);
                    ranges.add(rangeInfo);
                    localRanges.add(rangeInfo);
                }
                localRanges.clear();
                varInfo.ranges = Collections.unmodifiableList(Arrays.asList(localRanges.toArray(new VariableRangeInfoImpl[0])));
            }
        }
        ranges.sort(Comparator.comparing(VariableRangeInfo::start));
        this.variablesInfo = new VariablesInfoImpl(Collections.unmodifiableList(Arrays.asList(ranges.toArray(new VariableRangeInfoImpl[0]))));
    }

    private static class VariablesInfoImpl
    extends VariablesInfo {
        private List<VariableRangeInfoImpl> ranges;

        VariablesInfoImpl(List<VariableRangeInfoImpl> ranges) {
            this.ranges = ranges;
        }

        @Override
        public List<? extends VariableRangeInfo> ranges() {
            return this.ranges;
        }
    }

    private static class VariableInfoImpl
    extends VariableInfo {
        private String name;
        private VariableType type;
        private List<VariableRangeInfoImpl> ranges;

        VariableInfoImpl(String name, VariableType type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public VariableType type() {
            return this.type;
        }

        @Override
        public Collection<? extends VariableRangeInfo> ranges() {
            return this.ranges;
        }
    }

    private static class VariableRangeInfoImpl
    extends VariableRangeInfo {
        private VariableInfoImpl variableInfo;
        private int start;
        private int end;
        private int index;

        VariableRangeInfoImpl(VariableInfoImpl variableInfo, int start, int end, int index) {
            this.variableInfo = variableInfo;
            this.start = start;
            this.end = end;
            this.index = index;
        }

        @Override
        public VariableInfo variable() {
            return this.variableInfo;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int index() {
            return this.index;
        }
    }
}

