/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.List;
import java.util.function.Function;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;

public class WasmReplacingExpressionVisitor
implements WasmExpressionVisitor {
    private Function<WasmExpression, WasmExpression> mapper;

    public WasmReplacingExpressionVisitor(Function<WasmExpression, WasmExpression> mapper) {
        this.mapper = mapper;
    }

    public void replace(WasmFunction function) {
        this.replaceExpressions(function.getBody());
    }

    private void replaceExpressions(List<WasmExpression> expressions) {
        for (int i = 0; i < expressions.size(); ++i) {
            WasmExpression part = expressions.get(i);
            part.acceptVisitor(this);
            part = this.mapper.apply(part);
            expressions.set(i, part);
        }
    }

    @Override
    public void visit(WasmBlock expression) {
        this.replaceExpressions(expression.getBody());
    }

    @Override
    public void visit(WasmBranch expression) {
        expression.getCondition().acceptVisitor(this);
        expression.setCondition(this.mapper.apply(expression.getCondition()));
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
            expression.setResult(this.mapper.apply(expression.getResult()));
        }
    }

    @Override
    public void visit(WasmBreak expression) {
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
            expression.setResult(this.mapper.apply(expression.getResult()));
        }
    }

    @Override
    public void visit(WasmSwitch expression) {
        expression.getSelector().acceptVisitor(this);
        expression.setSelector(this.mapper.apply(expression.getSelector()));
    }

    @Override
    public void visit(WasmConditional expression) {
        expression.getCondition().acceptVisitor(this);
        expression.setCondition(this.mapper.apply(expression.getCondition()));
        this.replaceExpressions(expression.getThenBlock().getBody());
        this.replaceExpressions(expression.getElseBlock().getBody());
    }

    @Override
    public void visit(WasmReturn expression) {
        if (expression.getValue() != null) {
            expression.getValue().acceptVisitor(this);
            expression.setValue(this.mapper.apply(expression.getValue()));
        }
    }

    @Override
    public void visit(WasmUnreachable expression) {
    }

    @Override
    public void visit(WasmInt32Constant expression) {
    }

    @Override
    public void visit(WasmInt64Constant expression) {
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
    }

    @Override
    public void visit(WasmGetLocal expression) {
    }

    @Override
    public void visit(WasmSetLocal expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmIntBinary expression) {
        expression.getFirst().acceptVisitor(this);
        expression.setFirst(this.mapper.apply(expression.getFirst()));
        expression.getSecond().acceptVisitor(this);
        expression.setSecond(this.mapper.apply(expression.getSecond()));
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        expression.getFirst().acceptVisitor(this);
        expression.setFirst(this.mapper.apply(expression.getFirst()));
        expression.getSecond().acceptVisitor(this);
        expression.setSecond(this.mapper.apply(expression.getSecond()));
    }

    @Override
    public void visit(WasmIntUnary expression) {
        expression.getOperand().acceptVisitor(this);
        expression.setOperand(this.mapper.apply(expression.getOperand()));
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        expression.getOperand().acceptVisitor(this);
        expression.setOperand(this.mapper.apply(expression.getOperand()));
    }

    @Override
    public void visit(WasmConversion expression) {
        expression.getOperand().acceptVisitor(this);
        expression.setOperand(this.mapper.apply(expression.getOperand()));
    }

    @Override
    public void visit(WasmCall expression) {
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        expression.getSelector().acceptVisitor(this);
        expression.setSelector(this.mapper.apply(expression.getSelector()));
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmDrop expression) {
        expression.getOperand().acceptVisitor(this);
        expression.setOperand(this.mapper.apply(expression.getOperand()));
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        expression.getAmount().acceptVisitor(this);
        expression.setAmount(this.mapper.apply(expression.getAmount()));
    }

    @Override
    public void visit(WasmFill expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
        expression.getCount().acceptVisitor(this);
        expression.setCount(this.mapper.apply(expression.getCount()));
    }

    @Override
    public void visit(WasmCopy expression) {
        expression.getSourceIndex().acceptVisitor(this);
        expression.setSourceIndex(this.mapper.apply(expression.getSourceIndex()));
        expression.getDestinationIndex().acceptVisitor(this);
        expression.setDestinationIndex(this.mapper.apply(expression.getDestinationIndex()));
        expression.getCount().acceptVisitor(this);
        expression.setCount(this.mapper.apply(expression.getCount()));
    }
}

