/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.interop.Function;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class FunctionIntrinsic
implements WasmIntrinsic {
    private WasmClassGenerator classGenerator;

    public FunctionIntrinsic(WasmClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (methodReference.getClassName().equals(Function.class.getName()) && methodReference.getName().equals("isNull")) {
            return false;
        }
        return this.classGenerator.isFunctionClass(methodReference.getClassName());
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        WasmExpression selector = manager.generate(invocation.getArguments().get(0));
        WasmIndirectCall call = new WasmIndirectCall(selector);
        for (ValueType type : invocation.getMethod().getParameterTypes()) {
            call.getParameterTypes().add(WasmGeneratorUtil.mapType(type));
        }
        if (invocation.getMethod().getReturnType() != ValueType.VOID) {
            call.setReturnType(WasmGeneratorUtil.mapType(invocation.getMethod().getReturnType()));
        }
        for (int i = 1; i < invocation.getArguments().size(); ++i) {
            call.getArguments().add(manager.generate(invocation.getArguments().get(i)));
        }
        return call;
    }
}

