/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.model.MethodReference;

public class DoubleIntrinsic
implements WasmIntrinsic {
    private static final long EXPONENT_BITS = 0x7FF0000000000000L;
    private static final long FRACTION_BITS = 0xFFFFFFFFFFFFFL;

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Double.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "getNaN": 
            case "isNaN": 
            case "isInfinite": 
            case "isFinite": 
            case "doubleToRawLongBits": 
            case "longBitsToDouble": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getNaN": {
                return new WasmFloat64Constant(Double.NaN);
            }
            case "isNaN": {
                return this.testNaN(manager.generate(invocation.getArguments().get(0)), manager);
            }
            case "isInfinite": {
                return this.testIsInfinite(manager.generate(invocation.getArguments().get(0)));
            }
            case "isFinite": {
                return this.testIsFinite(manager.generate(invocation.getArguments().get(0)));
            }
            case "doubleToRawLongBits": {
                WasmConversion conversion = new WasmConversion(WasmType.FLOAT64, WasmType.INT64, false, manager.generate(invocation.getArguments().get(0)));
                conversion.setReinterpret(true);
                return conversion;
            }
            case "longBitsToDouble": {
                WasmConversion conversion = new WasmConversion(WasmType.INT64, WasmType.FLOAT64, false, manager.generate(invocation.getArguments().get(0)));
                conversion.setReinterpret(true);
                return conversion;
            }
        }
        throw new AssertionError();
    }

    private WasmExpression testNaN(WasmExpression expression, WasmIntrinsicManager manager) {
        WasmLocal bitsVar = manager.getTemporary(WasmType.INT64);
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        WasmConversion conversion = new WasmConversion(WasmType.FLOAT64, WasmType.INT64, false, expression);
        conversion.setReinterpret(true);
        block.getBody().add(new WasmSetLocal(bitsVar, conversion));
        WasmIntBinary exponentBits = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.AND, new WasmGetLocal(bitsVar), new WasmInt64Constant(0x7FF0000000000000L));
        WasmIntBinary fractionBits = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.AND, new WasmGetLocal(bitsVar), new WasmInt64Constant(0xFFFFFFFFFFFFFL));
        WasmIntBinary testExponent = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.NE, exponentBits, new WasmInt64Constant(0x7FF0000000000000L));
        WasmIntBinary testFraction = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.NE, fractionBits, new WasmInt64Constant(0L));
        WasmBranch breakIfWrongExponent = new WasmBranch(testExponent, block);
        breakIfWrongExponent.setResult(new WasmInt32Constant(0));
        block.getBody().add(new WasmDrop(breakIfWrongExponent));
        manager.releaseTemporary(bitsVar);
        block.getBody().add(testFraction);
        return block;
    }

    private WasmExpression testIsInfinite(WasmExpression expression) {
        WasmConversion conversion = new WasmConversion(WasmType.FLOAT64, WasmType.INT64, false, expression);
        conversion.setReinterpret(true);
        WasmIntBinary result = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.AND, conversion, new WasmInt64Constant(0x7FF0000000000000L));
        return new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.EQ, result, new WasmInt64Constant(0x7FF0000000000000L));
    }

    private WasmExpression testIsFinite(WasmExpression expression) {
        WasmConversion conversion = new WasmConversion(WasmType.FLOAT64, WasmType.INT64, false, expression);
        conversion.setReinterpret(true);
        WasmIntBinary result = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.AND, conversion, new WasmInt64Constant(0x7FF0000000000000L));
        return new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.NE, result, new WasmInt64Constant(0x7FF0000000000000L));
    }
}

