/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.text;

import java.io.IOException;
import java.io.Reader;
import org.teavm.model.text.ListingParseException;
import org.teavm.model.text.ListingToken;

class ListingLexer {
    private Reader reader;
    private int c;
    private ListingToken token;
    private Object tokenValue;
    private int index = -1;
    private int tokenStart;

    ListingLexer(Reader reader) {
        this.reader = reader;
    }

    public ListingToken getToken() {
        return this.token;
    }

    public boolean tryConsumeIdentifier(String value) throws IOException, ListingParseException {
        if (this.token == ListingToken.IDENTIFIER && value.equals(this.tokenValue)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public Object getTokenValue() {
        return this.tokenValue;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public void nextToken() throws IOException, ListingParseException {
        if (this.token == ListingToken.EOF) {
            return;
        }
        this.tokenStart = this.index;
        if (this.index < 0) {
            this.tokenStart = 0;
            this.nextChar();
        }
        this.skipWhiteSpace();
        switch (this.c) {
            case -1: {
                this.token = ListingToken.EOF;
                break;
            }
            case 13: {
                this.token = ListingToken.EOL;
                this.nextChar();
                if (this.c != 10) break;
                this.nextChar();
                break;
            }
            case 10: {
                this.token = ListingToken.EOL;
                this.nextChar();
                break;
            }
            case 64: {
                this.readVariable();
                break;
            }
            case 36: {
                this.readLabel();
                break;
            }
            case 39: {
                this.readString();
                break;
            }
            case 58: {
                this.nextChar();
                this.expect('=');
                this.token = ListingToken.ASSIGN;
                break;
            }
            case 61: {
                this.nextChar();
                this.expect('=');
                if (this.c == 61) {
                    this.token = ListingToken.REFERENCE_EQUAL;
                    this.nextChar();
                    break;
                }
                this.token = ListingToken.EQUAL;
                break;
            }
            case 33: {
                this.nextChar();
                this.expect('=');
                if (this.c == 61) {
                    this.token = ListingToken.REFERENCE_NOT_EQUAL;
                    this.nextChar();
                    break;
                }
                this.token = ListingToken.NOT_EQUAL;
                break;
            }
            case 60: {
                this.nextChar();
                if (this.c == 61) {
                    this.nextChar();
                    this.token = ListingToken.LESS_OR_EQUAL;
                    break;
                }
                if (this.c == 60) {
                    this.nextChar();
                    this.token = ListingToken.SHIFT_LEFT;
                    break;
                }
                this.token = ListingToken.LESS;
                break;
            }
            case 62: {
                this.nextChar();
                if (this.c == 61) {
                    this.nextChar();
                    this.token = ListingToken.GREATER_OR_EQUAL;
                    break;
                }
                if (this.c == 62) {
                    this.nextChar();
                    if (this.c == 62) {
                        this.nextChar();
                        this.token = ListingToken.SHIFT_RIGHT_UNSIGNED;
                        break;
                    }
                    this.token = ListingToken.SHIFT_RIGHT;
                    break;
                }
                this.token = ListingToken.GREATER;
                break;
            }
            case 43: {
                this.nextChar();
                this.token = ListingToken.ADD;
                break;
            }
            case 45: {
                this.nextChar();
                this.token = ListingToken.SUBTRACT;
                break;
            }
            case 42: {
                this.nextChar();
                this.token = ListingToken.MULTIPLY;
                break;
            }
            case 47: {
                this.nextChar();
                if (this.c == 47) {
                    this.skipComment();
                    break;
                }
                this.token = ListingToken.DIVIDE;
                break;
            }
            case 37: {
                this.nextChar();
                this.token = ListingToken.REMAINDER;
                break;
            }
            case 38: {
                this.nextChar();
                this.token = ListingToken.AND;
                break;
            }
            case 124: {
                this.nextChar();
                this.token = ListingToken.OR;
                break;
            }
            case 94: {
                this.nextChar();
                this.token = ListingToken.XOR;
                break;
            }
            case 46: {
                this.nextChar();
                this.token = ListingToken.DOT;
                break;
            }
            case 44: {
                this.nextChar();
                this.token = ListingToken.COMMA;
                break;
            }
            case 91: {
                this.nextChar();
                this.token = ListingToken.LEFT_SQUARE_BRACKET;
                break;
            }
            case 93: {
                this.nextChar();
                this.token = ListingToken.RIGHT_SQUARE_BRACKET;
                break;
            }
            case 96: {
                this.nextChar();
                this.token = ListingToken.IDENTIFIER;
                this.readEscapedIdentifier();
                break;
            }
            default: {
                if (ListingLexer.isIdentifierStart(this.c)) {
                    this.readIdentifier();
                    break;
                }
                if (this.c >= 48 && this.c <= 57) {
                    this.readNumber();
                    break;
                }
                this.unexpected();
            }
        }
    }

    private void readVariable() throws IOException {
        this.nextChar();
        this.token = ListingToken.VARIABLE;
        this.readIdentifierLike();
    }

    private void readLabel() throws IOException {
        this.nextChar();
        this.token = ListingToken.LABEL;
        this.readIdentifierLike();
    }

    private void readIdentifierLike() throws IOException {
        StringBuilder sb = new StringBuilder();
        while (ListingLexer.isIdentifierPart(this.c)) {
            sb.append((char)this.c);
            this.nextChar();
        }
        this.tokenValue = sb.toString();
    }

    private void readIdentifier() throws IOException {
        this.token = ListingToken.IDENTIFIER;
        StringBuilder sb = new StringBuilder();
        sb.append((char)this.c);
        this.nextChar();
        while (ListingLexer.isIdentifierPart(this.c)) {
            sb.append((char)this.c);
            this.nextChar();
        }
        this.tokenValue = sb.toString();
    }

    private void readEscapedIdentifier() throws IOException, ListingParseException {
        StringBuilder sb = new StringBuilder();
        while (this.c != 96) {
            if (this.c < 32) {
                throw new ListingParseException("Unexpected char in escaped identifier", this.index);
            }
            sb.append((char)this.c);
            this.nextChar();
        }
        this.nextChar();
        this.tokenValue = sb.toString();
    }

    static boolean isIdentifierStart(int c) {
        if (c >= 97 && c <= 122 || c >= 65 && c <= 90) {
            return true;
        }
        switch (c) {
            case 95: {
                return true;
            }
        }
        return false;
    }

    static boolean isIdentifierPart(int c) {
        if (ListingLexer.isIdentifierStart(c) || c >= 48 && c <= 57) {
            return true;
        }
        switch (c) {
            case 35: 
            case 36: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    private void readString() throws IOException, ListingParseException {
        this.nextChar();
        this.token = ListingToken.STRING;
        StringBuilder sb = new StringBuilder();
        block10: while (true) {
            switch (this.c) {
                case 39: {
                    this.nextChar();
                    this.tokenValue = sb.toString();
                    return;
                }
                case 92: {
                    this.nextChar();
                    switch (this.c) {
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 39: 
                        case 92: {
                            sb.append(this.c);
                            break;
                        }
                        case 117: {
                            int codePoint = 0;
                            for (int i = 0; i < 4; ++i) {
                                this.nextChar();
                                if (this.c == -1) {
                                    throw new ListingParseException("Wrong escape sequence", this.index);
                                }
                                int digit = Character.digit((char)this.c, 16);
                                if (digit < 0) {
                                    throw new ListingParseException("Wrong escape sequence", this.index);
                                }
                                codePoint = codePoint * 16 + digit;
                            }
                            sb.appendCodePoint(codePoint);
                            break;
                        }
                        default: {
                            throw new ListingParseException("Wrong escape sequence", this.index);
                        }
                    }
                    this.nextChar();
                    continue block10;
                }
            }
            if (this.c < 32) {
                throw new ListingParseException("Unexpected character in string literal: " + this.c, this.index);
            }
            sb.append((char)this.c);
            this.nextChar();
        }
    }

    private void readNumber() throws IOException, ListingParseException {
        StringBuilder sb = new StringBuilder();
        this.token = ListingToken.INTEGER;
        if (this.c == 45) {
            sb.append(this.c);
            this.nextChar();
        }
        while (this.c >= 48 && this.c <= 57) {
            sb.append((char)this.c);
            this.nextChar();
        }
        if (this.c == 46) {
            sb.append('.');
            this.token = ListingToken.DOUBLE;
            this.nextChar();
            if (this.c < 48 || this.c > 57) {
                throw new ListingParseException("Wrong number", this.index);
            }
            while (this.c >= 48 && this.c <= 57) {
                sb.append((char)this.c);
                this.nextChar();
            }
        }
        if (this.c == 69 || this.c == 101) {
            sb.append('e');
            this.nextChar();
            if (this.c == 43 || this.c == 45) {
                sb.append((char)this.c);
                this.nextChar();
            }
            if (this.c < 48 || this.c > 57) {
                throw new ListingParseException("Wrong number", this.index);
            }
            while (this.c >= 48 && this.c <= 57) {
                sb.append((char)this.c);
                this.nextChar();
            }
        }
        if (this.c == 70 || this.c == 102) {
            this.nextChar();
            this.token = ListingToken.FLOAT;
        } else if (this.c == 108 || this.c == 76) {
            this.nextChar();
            this.token = ListingToken.LONG;
        } else if (ListingLexer.isIdentifierStart(this.c)) {
            throw new ListingParseException("Wrong number", this.index);
        }
        switch (this.token) {
            case INTEGER: {
                this.tokenValue = Integer.parseInt(sb.toString());
                break;
            }
            case LONG: {
                this.tokenValue = Long.parseLong(sb.toString());
                break;
            }
            case FLOAT: {
                this.tokenValue = Float.valueOf(Float.parseFloat(sb.toString()));
                break;
            }
            case DOUBLE: {
                this.tokenValue = Double.parseDouble(sb.toString());
                break;
            }
        }
    }

    private void expect(char expected) throws IOException, ListingParseException {
        if (this.c != expected) {
            this.unexpected();
        }
        this.nextChar();
    }

    private void unexpected() throws ListingParseException {
        throw new ListingParseException("Unexpected character: " + (char)this.c, this.index);
    }

    private void skipWhiteSpace() throws IOException {
        block3: while (true) {
            switch (this.c) {
                case 9: 
                case 32: {
                    this.nextChar();
                    continue block3;
                }
            }
            break;
        }
    }

    private void skipComment() throws IOException {
        while (true) {
            switch (this.c) {
                case 10: {
                    this.nextChar();
                    this.token = ListingToken.EOL;
                    return;
                }
                case -1: {
                    this.token = ListingToken.EOF;
                    return;
                }
            }
            this.nextChar();
        }
    }

    private void nextChar() throws IOException {
        this.c = this.reader.read();
        ++this.index;
    }
}

