/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import java.util.ArrayList;
import java.util.Objects;
import org.teavm.model.InliningInfo;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;

public class CallSiteLocation {
    private String fileName;
    private String className;
    private String methodName;
    private int lineNumber;

    public CallSiteLocation(String fileName, String className, String methodName, int lineNumber) {
        this.fileName = fileName;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public static CallSiteLocation[] fromTextLocation(TextLocation location, MethodReference callingMethod) {
        InliningInfo inlining;
        if (location == null) {
            return new CallSiteLocation[]{new CallSiteLocation("", callingMethod.getClassName(), callingMethod.getName(), -1)};
        }
        if (location.getInlining() == null) {
            return new CallSiteLocation[]{new CallSiteLocation(CallSiteLocation.convertFileName(location.getFileName()), callingMethod.getClassName(), callingMethod.getName(), location.getLine())};
        }
        ArrayList<CallSiteLocation> result = new ArrayList<CallSiteLocation>();
        result.add(new CallSiteLocation(CallSiteLocation.convertFileName(location.getFileName()), inlining.getMethod().getClassName(), inlining.getMethod().getName(), location.getLine()));
        for (inlining = location.getInlining(); inlining != null; inlining = inlining.getParent()) {
            MethodReference method = inlining.getParent() != null ? inlining.getParent().getMethod() : callingMethod;
            result.add(new CallSiteLocation(CallSiteLocation.convertFileName(inlining.getFileName()), method.getClassName(), method.getName(), inlining.getLine()));
        }
        return result.toArray(new CallSiteLocation[0]);
    }

    private static String convertFileName(String fileName) {
        if (fileName != null) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        return fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CallSiteLocation)) {
            return false;
        }
        CallSiteLocation other = (CallSiteLocation)obj;
        return Objects.equals(this.fileName, other.fileName) && Objects.equals(this.className, other.className) && Objects.equals(this.methodName, other.methodName) && this.lineNumber == other.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.className, this.methodName, this.lineNumber);
    }
}

