/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.ClassHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.MemberHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;

public class Linker {
    private DependencyInfo dependency;

    public Linker(DependencyInfo dependency) {
        this.dependency = dependency;
    }

    public void link(ClassHolder cls) {
        for (MethodHolder methodHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            MethodReference methodRef = methodHolder.getReference();
            MethodDependencyInfo methodDep = this.dependency.getMethod(methodRef);
            if (methodDep != null && methodDep.isUsed()) continue;
            if (methodHolder.hasModifier(ElementModifier.STATIC)) {
                cls.removeMethod(methodHolder);
                continue;
            }
            methodHolder.getModifiers().add(ElementModifier.ABSTRACT);
            methodHolder.getModifiers().remove((Object)ElementModifier.NATIVE);
            methodHolder.setProgram(null);
        }
        for (MemberHolder memberHolder : cls.getFields().toArray(new FieldHolder[0])) {
            FieldReference fieldRef = new FieldReference(cls.getName(), memberHolder.getName());
            if (this.dependency.getField(fieldRef) != null) continue;
            cls.removeField((FieldHolder)memberHolder);
        }
    }
}

