/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.runtime.math;

public final class WasmPow {
    private static final long OFF = 4604531861337669632L;
    private static final int POW_LOG_TABLE_BITS = 7;
    private static final int POW_N = 128;
    private static final double LN2HI = 0.6931471805598903;
    private static final double LN2LO = 5.497923018708371E-14;
    private static final int EXP_TABLE_BITS = 7;
    private static final int EXP_POLY_ORDER = 5;
    private static final int EXP_N = 128;
    private static final double INVLN2N = 184.6649652337873;
    private static final double NEGLN2HIN = -0.005415212348111709;
    private static final double NEGLN2LON = -1.2864023111638346E-14;
    private static final double Shift = 6.755399441055744E15;
    private static double[] poly = new double[]{-0.5, -0.6666666666666679, 0.5000000000000007, 0.7999999995323976, -0.6666666663487739, -1.142909628459501, 1.0000415263675542};
    private static TableEntry[] tab = new TableEntry[]{WasmPow.a(1.4140625, -0.3464667673462145, 5.929407345889625E-15), WasmPow.a(1.40625, -0.34092658697056777, -2.544157440035963E-14), WasmPow.a(1.3984375, -0.3353555419211034, -3.443525940775045E-14), WasmPow.a(1.390625, -0.3297532863724655, -2.500123826022799E-15), WasmPow.a(1.3828125, -0.32411946865420305, -8.929337133850617E-15), WasmPow.a(1.375, -0.31845373111855224, 1.7625431312172662E-14), WasmPow.a(1.3671875, -0.31275571000389846, 1.5688303180062087E-15), WasmPow.a(1.359375, -0.3070250352949415, 2.9655274673691784E-14), WasmPow.a(1.3515625, -0.3012613305781997, 3.7923164802093147E-14), WasmPow.a(1.34375, -0.2954642128938758, 3.993416384387844E-14), WasmPow.a(1.3359375, -0.28963329258306203, 1.9352855826489123E-14), WasmPow.a(1.3359375, -0.28963329258306203, 1.9352855826489123E-14), WasmPow.a(1.328125, -0.28376817313062475, -1.9852665484979036E-14), WasmPow.a(1.3203125, -0.27786845100342816, -2.814323765595281E-14), WasmPow.a(1.3125, -0.2719337154836694, 2.7643769993528702E-14), WasmPow.a(1.3046875, -0.2659635484970977, -4.025092402293806E-14), WasmPow.a(1.296875, -0.25995752443691345, -1.2621729398885316E-14), WasmPow.a(1.2890625, -0.25391520998095984, -3.600176732637335E-15), WasmPow.a(1.2890625, -0.25391520998095984, -3.600176732637335E-15), WasmPow.a(1.28125, -0.2478361639045943, 1.3029797173308663E-14), WasmPow.a(1.2734375, -0.2417199368871934, 4.8230289429940886E-14), WasmPow.a(1.265625, -0.23556607131274632, -2.0592242769647135E-14), WasmPow.a(1.2578125, -0.22937410106487732, 3.149265065191484E-14), WasmPow.a(1.25, -0.22314355131425145, 4.169796584527195E-14), WasmPow.a(1.25, -0.22314355131425145, 4.169796584527195E-14), WasmPow.a(1.2421875, -0.21687393830063684, 2.2477465222466186E-14), WasmPow.a(1.234375, -0.21056476910735, 3.6507188831790577E-16), WasmPow.a(1.2265625, -0.2042155414286526, -3.827767260205414E-14), WasmPow.a(1.2265625, -0.2042155414286526, -3.827767260205414E-14), WasmPow.a(1.21875, -0.19782574332987224, -4.7641388950792196E-14), WasmPow.a(1.2109375, -0.19139485299967873, 4.9278276214647115E-14), WasmPow.a(1.203125, -0.18492233849406148, 4.9485167661250996E-14), WasmPow.a(1.203125, -0.18492233849406148, 4.9485167661250996E-14), WasmPow.a(1.1953125, -0.1784076574728033, -1.5003333854266542E-14), WasmPow.a(1.1875, -0.17185025692663203, -2.7194441649495324E-14), WasmPow.a(1.1875, -0.17185025692663203, -2.7194441649495324E-14), WasmPow.a(1.1796875, -0.1652495728952772, -2.99659267292569E-14), WasmPow.a(1.171875, -0.15860503017665906, 2.0472357800461955E-14), WasmPow.a(1.171875, -0.15860503017665906, 2.0472357800461955E-14), WasmPow.a(1.1640625, -0.15191604202584585, 3.879296723063646E-15), WasmPow.a(1.15625, -0.1451820098444614, -3.6506824353335045E-14), WasmPow.a(1.1484375, -0.13840232285906495, -5.4183331379008994E-14), WasmPow.a(1.1484375, -0.13840232285906495, -5.4183331379008994E-14), WasmPow.a(1.140625, -0.131576357788731, 1.1729485484531301E-14), WasmPow.a(1.140625, -0.131576357788731, 1.1729485484531301E-14), WasmPow.a(1.1328125, -0.12470347850091912, -3.811763084710266E-14), WasmPow.a(1.125, -0.11778303565643, 4.654729747598445E-14), WasmPow.a(1.125, -0.11778303565643, 4.654729747598445E-14), WasmPow.a(1.1171875, -0.11081436634026431, -2.5799991283069902E-14), WasmPow.a(1.109375, -0.10379679368168127, 3.7700471749674615E-14), WasmPow.a(1.109375, -0.10379679368168127, 3.7700471749674615E-14), WasmPow.a(1.1015625, -0.09672962645856842, 1.7306161136093256E-14), WasmPow.a(1.1015625, -0.09672962645856842, 1.7306161136093256E-14), WasmPow.a(1.09375, -0.089612158689647, -4.012913552726574E-14), WasmPow.a(1.0859375, -0.08244366921110213, 2.7541708360737882E-14), WasmPow.a(1.0859375, -0.08244366921110213, 2.7541708360737882E-14), WasmPow.a(1.078125, -0.07522342123763792, 5.0396178134370583E-14), WasmPow.a(1.078125, -0.07522342123763792, 5.0396178134370583E-14), WasmPow.a(1.0703125, -0.06795066190852594, 1.8195060030168815E-14), WasmPow.a(1.0625, -0.06062462181648698, 5.213620639136504E-14), WasmPow.a(1.0625, -0.06062462181648698, 5.213620639136504E-14), WasmPow.a(1.0546875, -0.053244514518837605, 2.532168943117445E-14), WasmPow.a(1.0546875, -0.053244514518837605, 2.532168943117445E-14), WasmPow.a(1.046875, -0.045809536031242715, -5.148849572685811E-14), WasmPow.a(1.046875, -0.045809536031242715, -5.148849572685811E-14), WasmPow.a(1.0390625, -0.038318864302141264, 4.6652946995830086E-15), WasmPow.a(1.0390625, -0.038318864302141264, 4.6652946995830086E-15), WasmPow.a(1.03125, -0.03077165866670839, -4.529814257790929E-14), WasmPow.a(1.03125, -0.03077165866670839, -4.529814257790929E-14), WasmPow.a(1.0234375, -0.023167059281490765, -4.361324067851568E-14), WasmPow.a(1.015625, -0.015504186535963527, -1.7274567499706107E-15), WasmPow.a(1.015625, -0.015504186535963527, -1.7274567499706107E-15), WasmPow.a(1.0078125, -0.0077821404420319595, -2.298941004620351E-14), WasmPow.a(1.0078125, -0.0077821404420319595, -2.298941004620351E-14), WasmPow.a(1.0, 0.0, 0.0), WasmPow.a(1.0, 0.0, 0.0), WasmPow.a(0.9921875, 0.007843177461040796, -1.4902732911301337E-14), WasmPow.a(0.984375, 0.01574835696817445, -3.527980389655325E-14), WasmPow.a(0.9765625, 0.023716526617363343, -4.730054772033249E-14), WasmPow.a(0.96875, 0.03174869831457272, 7.580310369375161E-15), WasmPow.a(0.9609375, 0.039845908547249564, -4.9893776716773285E-14), WasmPow.a(0.953125, 0.048009219186383234, -2.262629393030674E-14), WasmPow.a(0.9453125, 0.056239718322899535, -2.345674491018699E-14), WasmPow.a(0.94140625, 0.06038051098892083, -1.3352588834854848E-14), WasmPow.a(0.93359375, 0.06871389254808946, -3.765296820388875E-14), WasmPow.a(0.92578125, 0.07711730334438016, 5.1128335719851986E-14), WasmPow.a(0.91796875, 0.08559193033545398, -5.046674438470119E-14), WasmPow.a(0.9140625, 0.08985632912185793, 3.1218748807418837E-15), WasmPow.a(0.90625, 0.09844007281321865, 3.3871241029241416E-14), WasmPow.a(0.8984375, 0.10709813555638448, -1.7376727386423858E-14), WasmPow.a(0.89453125, 0.11145544092528326, 3.957125899799804E-14), WasmPow.a(0.88671875, 0.12022742699821265, -5.2849453521890294E-14), WasmPow.a(0.8828125, 0.12464244520731427, -3.767012502308738E-14), WasmPow.a(0.875, 0.13353139262449076, 3.1859736349078334E-14), WasmPow.a(0.87109375, 0.13800567301939282, 5.0900642926060466E-14), WasmPow.a(0.86328125, 0.14701474296180095, 8.710783796122478E-15), WasmPow.a(0.859375, 0.15154989812720032, 6.157896229122976E-16), WasmPow.a(0.8515625, 0.16068238169043525, 3.821577743916796E-14), WasmPow.a(0.84765625, 0.16528009093906348, 3.9440046718453496E-14), WasmPow.a(0.83984375, 0.17453941635187675, 2.2924522154618074E-14), WasmPow.a(0.8359375, 0.17920142945774842, -3.742530094732263E-14), WasmPow.a(0.83203125, 0.18388527877016259, -2.5223102140407338E-14), WasmPow.a(0.82421875, 0.1933193110035063, -1.0320443688698849E-14), WasmPow.a(0.8203125, 0.19806991376208316, 1.0634128304268335E-14), WasmPow.a(0.8125, 0.20763936477828793, -4.3425422595242564E-14), WasmPow.a(0.80859375, 0.21245865121420593, -1.2527395755711364E-14), WasmPow.a(0.8046875, 0.21730127569003344, -5.204008743405884E-14), WasmPow.a(0.80078125, 0.22216746534115828, -3.979844515951702E-15), WasmPow.a(0.79296875, 0.2319714654378231, -4.7955860343296286E-14), WasmPow.a(0.7890625, 0.2369097470783572, 5.015686013791602E-16), WasmPow.a(0.78515625, 0.24187253642048745, -7.252318953240293E-16), WasmPow.a(0.78125, 0.2468600779315011, 2.4688324156011588E-14), WasmPow.a(0.7734375, 0.2569104137850218, 5.465121253624792E-15), WasmPow.a(0.76953125, 0.26197371574153294, 4.102651071698446E-14), WasmPow.a(0.765625, 0.2670627852490952, -4.996736502345936E-14), WasmPow.a(0.76171875, 0.27217788591576664, 4.903580708156347E-14), WasmPow.a(0.7578125, 0.27731928541618345, 5.089628039500759E-14), WasmPow.a(0.75390625, 0.28248725557466514, 1.1782016386565151E-14), WasmPow.a(0.74609375, 0.29290401643288533, 4.727452940514406E-14), WasmPow.a(0.7421875, 0.29815337231912054, -4.4204083338755686E-14), WasmPow.a(0.73828125, 0.3034304294199046, 1.548345993498083E-14), WasmPow.a(0.734375, 0.30873548164959175, 2.1522127491642888E-14), WasmPow.a(0.73046875, 0.3140688276249648, 1.1054030169005386E-14), WasmPow.a(0.7265625, 0.31943077076641657, -5.534326352070679E-14), WasmPow.a(0.72265625, 0.3248216194012912, -5.351646604259541E-14), WasmPow.a(0.71875, 0.33024168687052224, 5.4612144489920215E-14), WasmPow.a(0.71484375, 0.3356912916381134, 2.8136969901227338E-14), WasmPow.a(0.7109375, 0.3411707574027787, -1.156568624616423E-14)};
    private static final long[] EXP_TAB = new long[]{0L, 0x3FF0000000000000L, 4367149474599452526L, 4607171688528556853L, -4868004084858692515L, 4607161091040444513L, -4859280119576434991L, 4607150627056680837L, 4363093389540324883L, 4607140297302181236L, -4860564323061625094L, 4607130102505797342L, 4350749156061923425L, 4607120043400338376L, 4364168240100004761L, 4607110120722592643L, 4366128403083131757L, 4607100335213349135L, 4363624214708482044L, 4607090687617419255L, 4341116261916187857L, 4607081178683658658L, -4870076522866643445L, 4607071809164989211L, -4857881712154133234L, 4607062579818421073L, -4877256630102726059L, 4607053491405074892L, -4858881367677209578L, 4607044544690204128L, 4359717415120819631L, 4607035740443217489L, -4863857816615152824L, 4607027079437701499L, -4859630355816238531L, 4607018562451443178L, 4362731899485115327L, 4607010190266452853L, -4857455882053489882L, 4607001963668987092L, 4367063335334195040L, 4606993883449571754L, -4859410923963139939L, 4606985950403025181L, 4362421515177083789L, 4606978165328481494L, 4359618604155798653L, 4606970529029414038L, 4365834109879625876L, 4606963042313658936L, 4361558225371547773L, 4606955705993438783L, 4359562691856033778L, 4606948520885386461L, -4857492308587640738L, 4606941487810569089L, 4360319936817113905L, 4606934607594512097L, -4882709470952570886L, 4606927881067223440L, 4362641697437125300L, 4606921309063217931L, 4354440509323660175L, 4606914892421541718L, 4360414030434708406L, 4606908631985796885L, 4361245865020257356L, 4606902528604166193L, 4363949802402347082L, 4606896583129437951L, -4862018976549545212L, 4606890796419031025L, -4858738662784151448L, 4606885169335019979L, -4856841960950780530L, 4606879702744160358L, -4867878926798276910L, 4606874397517914103L, -4856823124960863467L, 4606869254532475109L, 4361066948569222253L, 4606864274668794914L, -4858519367427004022L, 4606859458812608540L, -4874962362796897957L, 4606854807854460458L, -4864964451502548453L, 4606850322689730711L, 4342424336897059857L, 4606846004218661165L, 4365789078613288175L, 4606841853346381911L, 4354643160121541497L, 4606837870982937808L, 4365113450260533808L, 4606834058043315166L, 4356828907110576048L, 4606830415447468583L, 4364865165386375287L, 4606826944120347917L, -4859502521842818162L, 4606823644991925415L, -4861672301267803319L, 4606820518997222978L, -4865894452217038753L, 4606817567076339586L, -4862178651875353354L, 4606814790174478863L, 4364890759862540174L, 4606812189241976794L, 4358244976955136773L, 4606809765234329597L, 4364097860734309385L, 4606807519112221737L, 4338311716453074666L, 4606805451841554103L, 4365169902980743221L, 4606803564393472328L, -4860258889723447649L, 4606801857744395273L, -4860452975632495192L, 4606800332876043653L, -4862669920490755666L, 4606798990775468832L, -4858312122400614312L, 4606797832435081765L, 4347962289735735652L, 4606796858852682099L, -4858341730713460184L, 4606796071031487437L, -4870059510540748414L, 4606795469980162751L, -4871936092595705362L, 4606795056712849967L, -4863645441585018799L, 4606794832249197700L, -4866104880896786737L, 4606794797614391156L, -4861936742874514000L, 4606794953839182196L, -4862171044651866486L, 4606795301959919561L, 4364160436192007379L, 4606795843018579263L, -4865239048860621539L, 4606796578062795143L, 4365374511615819883L, 4606797508145889586L, 4352143969406577749L, 4606798634326904418L, -4861457929465508030L, 4606799957670631954L, -4858423338550479052L, 4606801479247646227L, -4863783675556659426L, 4606803200134334381L, -4858024654332078226L, 4606805121412928237L, 4364178698342926848L, 4606807244171536025L, 4363345029737015988L, 4606809569504174299L, -4871286895867992065L, 4606812098510800012L, 4358348108421357380L, 4606814832297342774L, -4858529541450220157L, 4606817771975737286L, -4873552611666813399L, 4606820918663955941L, -4869477542650660519L, 4606824273486041615L, -4858747092350994006L, 4606827837572140624L, -4862257653857481141L, 4606831612058535866L, 4355455812241575463L, 4606835598087680144L, 4354367543587795899L, 4606839796808229667L, -4861700651175763357L, 4606844209375077733L, 4362612029712904661L, 4606848836949388595L, -4858896013081134315L, 4606853680698631517L, 4364212552380330450L, 4606858741796615000L, 4360726356711135923L, 4606864021423521215L, -4863078573502718540L, 4606869520765940602L, 4362891239881388935L, 4606875241016906669L, -4859248142566958598L, 4606881183375930982L, -4875775683326071110L, 4606887349049038331L, -4859203616861915584L, 4606893739248802106L, -4870406652589927628L, 4606900355194379847L, -4858839866725070283L, 4606907198111549002L, 4356388038631218637L, 4606914269232742866L, -4858893633017702228L, 4606921569797086729L, 4355946959017544883L, 4606929101050434204L, 4363674894410448276L, 4606936864245403770L, 4360857247493478828L, 4606944860641415499L, 4351547817417644647L, 4606953091504727989L, 4352565403421120872L, 4606961558108475497L, -4863735759665056302L, 4606970261732705274L, -4859474856892171665L, 4606979203664415100L, -4859368956010059447L, 4606988385197591026L, 4356286533989107623L, 4606997807633245319L, -4863164539274780145L, 4607007472279454616L, 4363524392198705836L, 4607017380451398277L, 4360674496013757259L, 4607027533471396960L, -4863090309766824417L, 4607037932668951391L, -4861307347717911095L, 4607048579380781353L, 4356306869484685523L, 4607059474950864886L, 4360546482996998769L, 4607070620730477699L, -4859393813814996496L, 4607082018078232794L, -4860036451210660739L, 4607093668360120305L, 4363640302291525640L, 4607105572949547559L, 4360658257139329842L, 4607117733227379351L, 4362409866909812206L, 4607130150581978432L, -4859885672053611539L, 4607142826409246228L, 4357102052301720989L, 4607155762112663768L, 4346824392926350473L, 4607168959103332849L};
    private static final double[] EXP_POLY = new double[]{0.49999999999996786, 0.16666666666665886, 0.0416666808410674, 0.008333335853059549};
    private static final double C2 = EXP_POLY[0];
    private static final double C3 = EXP_POLY[1];
    private static final double C4 = EXP_POLY[2];
    private static final double C5 = EXP_POLY[3];

    private WasmPow() {
    }

    private static int top12(double x) {
        return (int)(Double.doubleToLongBits(x) >> 52);
    }

    private static double logInline(long ix, DoubleResult tail) {
        long tmp = ix - 4604531861337669632L;
        int i = (int)((tmp >>> 45) % 128L);
        int k = (int)(tmp >> 52);
        long iz = ix - (tmp & 0xFFF0000000000000L);
        double z = Double.longBitsToDouble(iz);
        double kd = k;
        double invc = WasmPow.tab[i].invc;
        double logc = WasmPow.tab[i].logc;
        double logctail = WasmPow.tab[i].logctail;
        double zhi = Double.longBitsToDouble(iz + 0x80000000L & 0xFFFFFFFF00000000L);
        double zlo = z - zhi;
        double rhi = zhi * invc - 1.0;
        double rlo = zlo * invc;
        double r = rhi + rlo;
        double t1 = kd * 0.6931471805598903 + logc;
        double t2 = t1 + r;
        double lo1 = kd * 5.497923018708371E-14 + logctail;
        double lo2 = t1 - t2 + r;
        double ar = poly[0] * r;
        double ar2 = r * ar;
        double ar3 = r * ar2;
        double arhi = poly[0] * rhi;
        double arhi2 = rhi * arhi;
        double hi = t2 + arhi2;
        double lo3 = rlo * (ar + arhi);
        double lo4 = t2 - hi + arhi2;
        double p = ar3 * (poly[1] + r * poly[2] + ar2 * (poly[3] + r * poly[4] + ar2 * (poly[5] + r * poly[6])));
        double lo = lo1 + lo2 + lo3 + lo4 + p;
        double y = hi + lo;
        tail.value = hi - y + lo;
        return y;
    }

    private static double specialcase(double tmp, long sbits, long ki) {
        if ((ki & 0x80000000L) == 0L) {
            double scale = Double.longBitsToDouble(sbits -= 4544132024016830464L);
            double y = 5.486124068793689E303 * (scale + scale * tmp);
            return y;
        }
        double scale = Double.longBitsToDouble(sbits += 4602678819172646912L);
        double y = scale + scale * tmp;
        if (Math.abs(y) < 1.0) {
            double one = 1.0;
            if (y < 0.0) {
                one = -1.0;
            }
            double lo = scale - y + scale * tmp;
            double hi = one + y;
            if ((y = hi + (lo = one - hi + y + lo) - one) == 0.0) {
                y = Double.longBitsToDouble(sbits & Long.MIN_VALUE);
            }
        }
        y = Double.MIN_NORMAL * y;
        return y;
    }

    private static double expInline(double x, double xtail, boolean signBias) {
        int abstop = WasmPow.top12(x) & 0x7FF;
        if (abstop - WasmPow.top12(5.551115123125783E-17) >= WasmPow.top12(512.0) - WasmPow.top12(5.551115123125783E-17)) {
            if (abstop - WasmPow.top12(5.551115123125783E-17) >= Integer.MIN_VALUE) {
                double one = 1.0 + x;
                return signBias ? -one : 1.0 + x;
            }
            if (abstop >= WasmPow.top12(1024.0)) {
                if (Double.doubleToLongBits(x) >>> 63 != 0L) {
                    return WasmPow.mathUflow(signBias);
                }
                return WasmPow.mathOflow(signBias);
            }
            abstop = 0;
        }
        double z = 184.6649652337873 * x;
        double kd = z + 6.755399441055744E15;
        long ki = Double.doubleToLongBits(kd);
        double r = x + (kd -= 6.755399441055744E15) * -0.005415212348111709 + kd * -1.2864023111638346E-14;
        long idx = 2L * (ki % 128L);
        long top = ki + (long)(signBias ? 1 : 0) << 45;
        double tail = Double.longBitsToDouble(EXP_TAB[(int)idx]);
        long sbits = EXP_TAB[(int)idx + 1] + top;
        double r2 = (r += xtail) * r;
        double tmp = tail + r + r2 * (C2 + r * C3) + r2 * r2 * (C4 + r * C5);
        if (abstop == 0) {
            return WasmPow.specialcase(tmp, sbits, ki);
        }
        double scale = Double.longBitsToDouble(sbits);
        return scale + scale * tmp;
    }

    private static double mathOflow(boolean sign) {
        return WasmPow.mathXflow(sign, 3.105036184601418E231);
    }

    private static double mathUflow(boolean sign) {
        return WasmPow.mathXflow(sign, 1.2882297539194267E-231);
    }

    private static double mathXflow(boolean sign, double y) {
        return (sign ? -y : y) * y;
    }

    private static int checkint(long iy) {
        int e = (int)(iy >>> 52 & 0x7FFL);
        if (e < 1023) {
            return 0;
        }
        if (e > 1075) {
            return 2;
        }
        if ((iy & (1L << 1075 - e) - 1L) != 0L) {
            return 0;
        }
        if ((iy & 1L << 1075 - e) != 0L) {
            return 1;
        }
        return 2;
    }

    private static boolean zeroinfnan(long i) {
        return 2L * i - 1L >= 2L * Double.doubleToLongBits(Double.POSITIVE_INFINITY) - 1L;
    }

    public static double pow(double x, double y) {
        boolean signBias = false;
        long ix = Double.doubleToLongBits(x);
        long iy = Double.doubleToLongBits(y);
        int topx = WasmPow.top12(x);
        int topy = WasmPow.top12(y);
        if (topx - 1 >= 2046 || (topy & 0x7FF) - 958 >= 128) {
            if (WasmPow.zeroinfnan(iy)) {
                if (2L * iy == 0L) {
                    return 1.0;
                }
                if (ix == Double.doubleToLongBits(1.0)) {
                    return 1.0;
                }
                if (2L * ix > 2L * Double.doubleToLongBits(Double.POSITIVE_INFINITY) || 2L * iy > 2L * Double.doubleToLongBits(Double.POSITIVE_INFINITY)) {
                    return x + y;
                }
                if (2L * ix == 2L * Double.doubleToLongBits(1.0)) {
                    return 1.0;
                }
                if (2L * ix < 2L * Double.doubleToLongBits(1.0) == (iy >>> 63 == 0L)) {
                    return 0.0;
                }
                return y * y;
            }
            if (WasmPow.zeroinfnan(ix)) {
                double x2 = x * x;
                if (ix >>> 63 != 0L && WasmPow.checkint(iy) == 1) {
                    x2 = -x2;
                }
                return iy >>> 63 != 0L ? 1.0 / x2 : x2;
            }
            if (ix >>> 63 != 0L) {
                int yint = WasmPow.checkint(iy);
                if (yint == 0) {
                    return x;
                }
                if (yint == 1) {
                    signBias = true;
                }
                ix &= Long.MAX_VALUE;
                topx &= 0x7FF;
            }
            if ((topy & 0x7FF) - 958 >= 128) {
                if (ix == Double.doubleToLongBits(1.0)) {
                    return 1.0;
                }
                if ((topy & 0x7FF) < 958) {
                    return 1.0;
                }
                return ix > Double.doubleToLongBits(1.0) == topy < 2048 ? WasmPow.mathOflow(false) : WasmPow.mathUflow(false);
            }
            if (topx == 0) {
                ix = Double.doubleToLongBits(x * 4.503599627370496E15);
                ix &= Long.MAX_VALUE;
                ix -= 0x340000000000000L;
            }
        }
        DoubleResult lo = new DoubleResult();
        double hi = WasmPow.logInline(ix, lo);
        double yhi = Double.longBitsToDouble(iy & 0xFFFFFFFFF8000000L);
        double ylo = y - yhi;
        double lhi = Double.longBitsToDouble(Double.doubleToLongBits(hi) & 0xFFFFFFFFF8000000L);
        double llo = hi - lhi + lo.value;
        double ehi = yhi * lhi;
        double elo = ylo * lhi + y * llo;
        return WasmPow.expInline(ehi, elo, signBias);
    }

    private static TableEntry a(double a, double b, double c) {
        TableEntry entry = new TableEntry();
        entry.invc = a;
        entry.logc = b;
        entry.logctail = c;
        return entry;
    }

    static class TableEntry {
        double invc;
        double pad;
        double logc;
        double logctail;

        TableEntry() {
        }
    }

    static class DoubleResult {
        double value;

        DoubleResult() {
        }
    }
}

