/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.runtime.fs;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teavm.backend.wasm.runtime.fs.WasiVirtualFile;
import org.teavm.backend.wasm.wasi.Prestat;
import org.teavm.backend.wasm.wasi.PrestatDir;
import org.teavm.backend.wasm.wasi.Wasi;
import org.teavm.interop.Address;
import org.teavm.runtime.fs.VirtualFile;
import org.teavm.runtime.fs.VirtualFileSystem;

public class WasiFileSystem
implements VirtualFileSystem {
    private List<Preopened> preopenedList;
    final byte[] buffer = new byte[256];
    short errno;
    String bestPreopenedPath;
    int bestPreopenedId;

    @Override
    public String getUserDir() {
        return "/";
    }

    @Override
    public VirtualFile getFile(String path) {
        return new WasiVirtualFile(this, path);
    }

    void findBestPreopened(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        List<Preopened> list = this.getPreopenedList();
        int bestFd = -1;
        int bestNameLength = -1;
        for (Preopened preopened : list) {
            if (path.equals(preopened.name)) {
                bestFd = preopened.fd;
                path = null;
                break;
            }
            int prefixLen = WasiFileSystem.getPrefixLength(path, preopened.name);
            if (prefixLen <= bestNameLength || prefixLen < 0) continue;
            bestFd = preopened.fd;
            bestNameLength = prefixLen;
        }
        if (bestFd == -1) {
            path = null;
        } else if (path != null) {
            path = path.substring(bestNameLength);
        }
        this.bestPreopenedPath = path;
        this.bestPreopenedId = bestFd;
    }

    private static int getPrefixLength(String name, String dir) {
        if (dir.equals("/") && name.startsWith("/")) {
            return 1;
        }
        return name.startsWith(dir) && name.length() > dir.length() && name.charAt(dir.length()) == '/' ? dir.length() + 1 : -1;
    }

    @Override
    public boolean isWindows() {
        return false;
    }

    @Override
    public String canonicalize(String path) {
        return path;
    }

    private List<Preopened> getPreopenedList() {
        if (this.preopenedList == null) {
            this.preopenedList = this.createPreopenedList();
        }
        return this.preopenedList;
    }

    private List<Preopened> createPreopenedList() {
        short errno;
        byte[] buffer = this.buffer;
        Prestat prestat = (Prestat)Address.align((Address)Address.ofData((byte[])buffer), (int)4).toStructure();
        ArrayList<Preopened> list = new ArrayList<Preopened>();
        int fd = 3;
        while ((errno = Wasi.fdPrestatGet(fd, prestat)) != 8) {
            if (errno != 0) {
                return Collections.emptyList();
            }
            if (prestat.kind == 0) {
                PrestatDir prestatDir = (PrestatDir)prestat;
                int length = prestatDir.nameLength;
                byte[] bytes = length <= buffer.length ? buffer : new byte[length];
                errno = Wasi.fdPrestatDirName(fd, Address.ofData((byte[])bytes), length);
                if (errno == 0 && length > 0) {
                    if (bytes[length - 1] == 0) {
                        --length;
                    }
                    list.add(new Preopened(fd, new String(bytes, 0, length, StandardCharsets.UTF_8)));
                } else {
                    return Collections.emptyList();
                }
            }
            ++fd;
        }
        return list;
    }

    static class Preopened {
        final int fd;
        final String name;

        Preopened(int fd, String name) {
            this.fd = fd;
            this.name = name;
        }
    }
}

