/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.Objects;
import org.teavm.backend.wasm.render.CLine;
import org.teavm.backend.wasm.render.WasmCRenderer;
import org.teavm.model.TextLocation;

class CSingleLine
extends CLine {
    private String text;
    private TextLocation location;

    public CSingleLine(String text) {
        this(text, null);
    }

    public CSingleLine(String text, TextLocation location) {
        this.text = text;
        this.location = location;
    }

    public String getText() {
        return this.text;
    }

    public TextLocation getLocation() {
        return this.location;
    }

    public void setLocation(TextLocation location) {
        this.location = location;
    }

    @Override
    void render(WasmCRenderer target) {
        if (target.lineNumbersEmitted) {
            TextLocation location = this.location;
            if (location == null) {
                location = target.lastReportedLocation;
            }
            if (location != null) {
                if (!Objects.equals(target.currentFile, location.getFileName())) {
                    target.line("#line " + (location.getLine() - 1) + " \"" + location.getFileName() + "\"");
                } else if (location.getLine() != target.currentLine) {
                    target.line("#line " + (location.getLine() - 1));
                }
                target.currentFile = location.getFileName();
                target.currentLine = location.getLine() + 1;
                target.lastReportedLocation = location;
            }
        }
        target.line(this.text);
    }
}

