/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.wasm.model.WasmCollection;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmCustomSection;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmMemorySegment;
import org.teavm.backend.wasm.model.WasmTag;

public class WasmModule {
    private int minMemorySize;
    private int maxMemorySize;
    private List<WasmMemorySegment> segments = new ArrayList<WasmMemorySegment>();
    private List<WasmFunction> functionTable = new ArrayList<WasmFunction>();
    private WasmFunction startFunction;
    private Map<String, WasmCustomSection> customSections = new LinkedHashMap<String, WasmCustomSection>();
    private Map<String, WasmCustomSection> readonlyCustomSections = Collections.unmodifiableMap(this.customSections);
    public final WasmCollection<WasmFunction> functions = new WasmCollection();
    public final WasmCollection<WasmGlobal> globals = new WasmCollection();
    public final WasmCollection<WasmCompositeType> types = new WasmCollection();
    public final WasmCollection<WasmTag> tags = new WasmCollection();

    public void add(WasmCustomSection customSection) {
        if (this.customSections.containsKey(customSection.getName())) {
            throw new IllegalArgumentException("Custom section " + customSection.getName() + " already defined in this module");
        }
        if (customSection.module != null) {
            throw new IllegalArgumentException("Given custom section is already registered in another module");
        }
        this.customSections.put(customSection.getName(), customSection);
        customSection.module = this;
    }

    public void remove(WasmCustomSection customSection) {
        if (customSection.module != this) {
            return;
        }
        customSection.module = null;
        this.customSections.remove(customSection.getName());
    }

    public Map<? extends String, ? extends WasmCustomSection> getCustomSections() {
        return this.readonlyCustomSections;
    }

    public List<WasmFunction> getFunctionTable() {
        return this.functionTable;
    }

    public List<WasmMemorySegment> getSegments() {
        return this.segments;
    }

    public int getMinMemorySize() {
        return this.minMemorySize;
    }

    public void setMinMemorySize(int minMemorySize) {
        this.minMemorySize = minMemorySize;
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public WasmFunction getStartFunction() {
        return this.startFunction;
    }

    public void setStartFunction(WasmFunction startFunction) {
        this.startFunction = startFunction;
    }
}

