/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassGenerator;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.ValueType;
import org.teavm.model.classes.TagRegistry;

public class WasmGCSupertypeFunctionGenerator {
    private ObjectIntMap<ValueType> tableIndexes = new ObjectIntHashMap();
    private Map<ValueType, WasmFunction> functions = new HashMap<ValueType, WasmFunction>();
    private WasmModule module;
    private WasmGCClassGenerator classGenerator;
    private NameProvider nameProvider;
    private TagRegistry tagRegistry;
    private WasmFunctionTypes functionTypes;
    private WasmFunctionType functionType;

    WasmGCSupertypeFunctionGenerator(WasmModule module, WasmGCClassGenerator classGenerator, NameProvider nameProvider, TagRegistry tagRegistry, WasmFunctionTypes functionTypes) {
        this.module = module;
        this.classGenerator = classGenerator;
        this.nameProvider = nameProvider;
        this.tagRegistry = tagRegistry;
        this.functionTypes = functionTypes;
    }

    public WasmFunction getIsSupertypeFunction(ValueType type) {
        WasmFunction result = this.functions.get(type);
        if (result == null) {
            result = this.generateIsSupertypeFunction(type);
            this.functions.put(type, result);
        }
        return result;
    }

    private WasmFunction generateIsSupertypeFunction(ValueType type) {
        WasmFunction function = new WasmFunction(this.getFunctionType());
        function.setName(this.nameProvider.forSupertypeFunction(type));
        WasmLocal subtypeVar = new WasmLocal(WasmType.INT32, "subtype");
        function.add(subtypeVar);
        this.module.functions.add(function);
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            this.generateIsClass(subtypeVar, className, function.getBody());
        } else if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            this.generateIsArray(subtypeVar, itemType, function.getBody());
        } else {
            WasmGlobal expected = this.classGenerator.getClassInfo((ValueType)type).pointer;
            WasmIntBinary condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, new WasmGetLocal(subtypeVar), new WasmGetGlobal(expected));
            function.getBody().add(new WasmReturn(condition));
        }
        return function;
    }

    private void generateIsClass(WasmLocal subtypeVar, String className, List<WasmExpression> body) {
        List<TagRegistry.Range> ranges = this.tagRegistry.getRanges(className);
        if (ranges.isEmpty()) {
            body.add(new WasmReturn(new WasmInt32Constant(0)));
            return;
        }
        int tagOffset = this.classGenerator.getClassTagOffset();
        WasmExpression tagExpression = this.getClassField(new WasmGetLocal(subtypeVar), tagOffset);
        body.add(new WasmSetLocal(subtypeVar, tagExpression));
        ranges.sort(Comparator.comparingInt(range -> range.lower));
        int lower = ranges.get((int)0).lower;
        int upper = ranges.get((int)(ranges.size() - 1)).upper;
        WasmIntBinary lowerCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(subtypeVar), new WasmInt32Constant(lower));
        WasmConditional testLower = new WasmConditional(lowerCondition);
        testLower.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
        body.add(testLower);
        WasmIntBinary upperCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GE_SIGNED, new WasmGetLocal(subtypeVar), new WasmInt32Constant(upper));
        WasmConditional testUpper = new WasmConditional(upperCondition);
        testUpper.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
        body.add(testUpper);
        for (int i = 1; i < ranges.size(); ++i) {
            int lowerHole = ranges.get((int)(i - 1)).upper;
            int upperHole = ranges.get((int)i).lower;
            lowerCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GE_SIGNED, new WasmGetLocal(subtypeVar), new WasmInt32Constant(lowerHole));
            testLower = new WasmConditional(lowerCondition);
            body.add(testLower);
            upperCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(subtypeVar), new WasmInt32Constant(upperHole));
            testUpper = new WasmConditional(upperCondition);
            testUpper.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
            testLower.getThenBlock().getBody().add(testUpper);
        }
        body.add(new WasmReturn(new WasmInt32Constant(1)));
    }

    private void generateIsArray(WasmLocal subtypeVar, ValueType itemType, List<WasmExpression> body) {
        int itemOffset = this.classGenerator.getClassArrayItemOffset();
        WasmExpression itemExpression = this.getClassField(new WasmGetLocal(subtypeVar), itemOffset);
        body.add(new WasmSetLocal(subtypeVar, itemExpression));
        WasmConditional itemTest = new WasmConditional(new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, new WasmGetLocal(subtypeVar)));
        itemTest.setType(WasmType.INT32);
        itemTest.getThenBlock().getBody().add(new WasmInt32Constant(0));
        WasmCall delegateToItem = new WasmCall(this.getIsSupertypeFunction(itemType));
        delegateToItem.getArguments().add(new WasmGetLocal(subtypeVar));
        itemTest.getElseBlock().getBody().add(delegateToItem);
        body.add(new WasmReturn(itemTest));
    }

    public WasmFunctionType getFunctionType() {
        if (this.functionType == null) {
            this.functionType = this.functionTypes.of(WasmType.INT32, this.classGenerator.standardClasses.classClass().getType());
        }
        return this.functionType;
    }

    private WasmExpression getClassField(WasmExpression instance, int fieldIndex) {
        return new WasmStructGet(this.classGenerator.standardClasses.classClass().getStructure(), instance, fieldIndex);
    }
}

