/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCStandardClasses;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.generate.gc.initialization.WasmGCInitializerContributor;
import org.teavm.backend.wasm.generate.gc.method.WasmGCFunctionProvider;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringPool;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStorageType;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.ClassMetadataRequirements;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.classes.VirtualTable;
import org.teavm.model.classes.VirtualTableEntry;
import org.teavm.model.classes.VirtualTableProvider;
import org.teavm.model.util.ReflectionUtil;

public class WasmGCClassGenerator
implements WasmGCClassInfoProvider,
WasmGCInitializerContributor {
    public static final int CLASS_FIELD_OFFSET = 0;
    private final WasmModule module;
    private ClassReaderSource classSource;
    private WasmFunctionTypes functionTypes;
    private TagRegistry tagRegistry;
    private ClassMetadataRequirements metadataRequirements;
    private VirtualTableProvider virtualTables;
    private WasmGCFunctionProvider functionProvider;
    private Map<ValueType, WasmGCClassInfo> classInfoMap = new LinkedHashMap<ValueType, WasmGCClassInfo>();
    private ObjectIntMap<FieldReference> fieldIndexes = new ObjectIntHashMap();
    private ObjectIntMap<MethodReference> methodIndexes = new ObjectIntHashMap();
    public final WasmGCStringPool strings;
    public final WasmGCStandardClasses standardClasses;
    private final WasmGCTypeMapper typeMapper;
    private final NameProvider names;
    private WasmFunction initializer;
    private WasmFunction createPrimitiveClassFunction;
    private WasmFunction createArrayClassFunction;
    private final WasmGCSupertypeFunctionGenerator supertypeGenerator;
    private int classTagOffset;
    private int classFlagsOffset;
    private int classNameOffset;
    private int classParentOffset;
    private int classArrayOffset;
    private int classArrayItemOffset;
    private int classSupertypeFunctionOffset;
    private int virtualTableFieldOffset;

    public WasmGCClassGenerator(WasmModule module, ClassReaderSource classSource, WasmFunctionTypes functionTypes, TagRegistry tagRegistry, ClassMetadataRequirements metadataRequirements, VirtualTableProvider virtualTables, WasmGCFunctionProvider functionProvider, NameProvider names) {
        this.module = module;
        this.classSource = classSource;
        this.functionTypes = functionTypes;
        this.tagRegistry = tagRegistry;
        this.metadataRequirements = metadataRequirements;
        this.virtualTables = virtualTables;
        this.functionProvider = functionProvider;
        this.names = names;
        this.standardClasses = new WasmGCStandardClasses(this);
        this.strings = new WasmGCStringPool(this.standardClasses, module, functionProvider);
        this.supertypeGenerator = new WasmGCSupertypeFunctionGenerator(module, this, names, tagRegistry, functionTypes);
        this.typeMapper = new WasmGCTypeMapper(this);
    }

    @Override
    public void contributeToInitializerDefinitions(WasmFunction function) {
        for (WasmGCClassInfo classInfo : this.classInfoMap.values()) {
            WasmStructNewDefault newStruct = new WasmStructNewDefault(this.standardClasses.classClass().getStructure());
            function.getBody().add(new WasmSetGlobal(classInfo.pointer, newStruct));
        }
    }

    @Override
    public void contributeToInitializer(WasmFunction function) {
        WasmGCClassInfo classClass = this.standardClasses.classClass();
        for (WasmGCClassInfo classInfo : this.classInfoMap.values()) {
            classInfo.initializer.accept(function.getBody());
            WasmFunction supertypeFunction = this.supertypeGenerator.getIsSupertypeFunction(classInfo.getValueType());
            function.getBody().add(this.setClassField(classInfo, this.classSupertypeFunctionOffset, new WasmFunctionReference(supertypeFunction)));
            function.getBody().add(this.setClassField(classInfo, 0, new WasmGetGlobal(classClass.pointer)));
        }
    }

    @Override
    public WasmGCClassInfo getClassInfo(ValueType type) {
        WasmGCClassInfo classInfo = this.classInfoMap.get(type);
        if (classInfo == null) {
            WasmStructure classStructure;
            classInfo = new WasmGCClassInfo(type);
            this.classInfoMap.put(type, classInfo);
            if (!(type instanceof ValueType.Primitive)) {
                String name = type instanceof ValueType.Object ? ((ValueType.Object)type).getClassName() : null;
                classInfo.structure = new WasmStructure(name);
                classInfo.structure.getFields().add(this.standardClasses.classClass().getType().asStorage());
                this.fillFields(classInfo.structure.getFields(), type);
            }
            String pointerName = this.names.forClassInstance(type);
            classInfo.virtualTableStructure = classStructure = type instanceof ValueType.Object ? this.initRegularClassStructure(((ValueType.Object)type).getClassName()) : this.standardClasses.classClass().getStructure();
            classInfo.pointer = new WasmGlobal(pointerName, classStructure.getReference(), new WasmNullConstant(classStructure.getReference()));
            this.module.globals.add(classInfo.pointer);
            if (type instanceof ValueType.Primitive) {
                this.initPrimitiveClass(classInfo, (ValueType.Primitive)type);
            } else if (type instanceof ValueType.Void) {
                this.initVoidClass(classInfo);
            } else if (type instanceof ValueType.Array) {
                this.initArrayClass(classInfo, (ValueType.Array)type);
            } else if (type instanceof ValueType.Object) {
                this.initRegularClass(classInfo, classStructure, ((ValueType.Object)type).getClassName());
            }
        }
        return classInfo;
    }

    public int getClassTagOffset() {
        return this.classTagOffset;
    }

    public int getClassArrayItemOffset() {
        return this.classArrayItemOffset;
    }

    private void initPrimitiveClass(WasmGCClassInfo classInfo, ValueType.Primitive type) {
        classInfo.initializer = target -> {
            int kind;
            switch (type.getKind()) {
                case BOOLEAN: {
                    kind = 0;
                    break;
                }
                case BYTE: {
                    kind = 1;
                    break;
                }
                case SHORT: {
                    kind = 2;
                    break;
                }
                case CHARACTER: {
                    kind = 3;
                    break;
                }
                case INTEGER: {
                    kind = 4;
                    break;
                }
                case LONG: {
                    kind = 5;
                    break;
                }
                case FLOAT: {
                    kind = 6;
                    break;
                }
                case DOUBLE: {
                    kind = 7;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            target.add(this.fillPrimitiveClass(classInfo.pointer, ReflectionUtil.typeName(type.getKind()), kind));
        };
    }

    private void initVoidClass(WasmGCClassInfo classInfo) {
        classInfo.initializer = target -> target.add(this.fillPrimitiveClass(classInfo.pointer, "void", 8));
    }

    private void initRegularClass(WasmGCClassInfo classInfo, WasmStructure classStructure, String name) {
        classInfo.initializer = target -> {
            ClassReader cls;
            List<TagRegistry.Range> ranges = this.tagRegistry.getRanges(name);
            int tag = ranges.stream().mapToInt(range -> range.lower).min().orElse(0);
            target.add(this.setClassField(classInfo, this.classTagOffset, new WasmInt32Constant(tag)));
            ClassMetadataRequirements.Info metadataReg = this.metadataRequirements.getInfo(name);
            if (metadataReg.name()) {
                WasmGlobal namePtr = this.strings.getStringConstant((String)name).global;
                target.add(this.setClassField(classInfo, this.classNameOffset, new WasmGetGlobal(namePtr)));
            }
            if ((cls = this.classSource.get(name)) != null) {
                if (metadataReg.simpleName() && cls.getSimpleName() != null) {
                    WasmGlobal namePtr = this.strings.getStringConstant((String)cls.getSimpleName()).global;
                    target.add(this.setClassField(classInfo, this.classNameOffset, new WasmGetGlobal(namePtr)));
                }
                if (cls.getParent() != null) {
                    WasmGCClassInfo parent = this.getClassInfo(cls.getParent());
                    target.add(this.setClassField(classInfo, this.classParentOffset, new WasmGetGlobal(parent.pointer)));
                }
            }
            VirtualTable virtualTable = this.virtualTables.lookup(name);
            this.fillVirtualTableMethods((List<WasmExpression>)target, classStructure, classInfo.pointer, virtualTable, this.virtualTableFieldOffset, name);
        };
    }

    private int fillVirtualTableMethods(List<WasmExpression> target, WasmStructure structure, WasmGlobal global, VirtualTable virtualTable, int index, String origin) {
        if (virtualTable.getParent() != null) {
            index = this.fillVirtualTableMethods(target, structure, global, virtualTable.getParent(), index, origin);
        }
        for (MethodDescriptor methodDescriptor : virtualTable.getMethods()) {
            VirtualTableEntry entry = virtualTable.getEntry(methodDescriptor);
            if (entry == null || entry.getImplementor() == null) continue;
            WasmFunction function = this.functionProvider.getMemberFunction(entry.getImplementor());
            if (!origin.equals(entry.getImplementor().getClassName())) {
                WasmFunctionType functionType = this.getFunctionType(virtualTable.getClassName(), methodDescriptor);
                WasmFunction wrapperFunction = new WasmFunction(functionType);
                this.module.functions.add(wrapperFunction);
                WasmCall call = new WasmCall(function);
                WasmLocal instanceParam = new WasmLocal(this.getClassInfo(virtualTable.getClassName()).getType());
                wrapperFunction.getLocalVariables().add(instanceParam);
                WasmType.CompositeReference castTarget = this.getClassInfo(entry.getImplementor().getClassName()).getType();
                call.getArguments().add(new WasmCast(new WasmGetLocal(instanceParam), castTarget));
                WasmLocal[] params = new WasmLocal[methodDescriptor.parameterCount()];
                for (int i = 0; i < methodDescriptor.parameterCount(); ++i) {
                    params[i] = new WasmLocal(this.typeMapper.mapType(methodDescriptor.parameterType(i)).asUnpackedType());
                    call.getArguments().add(new WasmGetLocal(params[i]));
                }
                wrapperFunction.getLocalVariables().addAll(List.of(params));
            }
            WasmFunctionReference ref = new WasmFunctionReference(function);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), index, ref));
        }
        return index;
    }

    private WasmStructure initRegularClassStructure(String className) {
        VirtualTable virtualTable = this.virtualTables.lookup(className);
        WasmStructure structure = new WasmStructure(this.names.forClassClass(className));
        this.module.types.add(structure);
        this.addVirtualTableFields(structure, virtualTable);
        this.fillClassFields(structure.getFields(), "java.lang.Class");
        return structure;
    }

    private void addVirtualTableFields(WasmStructure structure, VirtualTable virtualTable) {
        if (virtualTable.getParent() != null) {
            this.addVirtualTableFields(structure, virtualTable.getParent());
        }
        for (MethodDescriptor methodDescriptor : virtualTable.getMethods()) {
            WasmFunctionType functionType = this.getFunctionType(virtualTable.getClassName(), methodDescriptor);
            MethodReference methodRef = new MethodReference(virtualTable.getClassName(), methodDescriptor);
            this.methodIndexes.put((Object)methodRef, structure.getFields().size());
            structure.getFields().add(functionType.getReference().asStorage());
        }
    }

    private WasmFunctionType getFunctionType(String className, MethodDescriptor methodDesc) {
        WasmType returnType = this.typeMapper.mapType(methodDesc.getResultType()).asUnpackedType();
        ValueType[] javaParamTypes = methodDesc.getParameterTypes();
        WasmType[] paramTypes = new WasmType[javaParamTypes.length + 1];
        paramTypes[0] = this.getClassInfo(className).getType();
        for (int i = 0; i < javaParamTypes.length; ++i) {
            paramTypes[i + 1] = this.typeMapper.mapType(javaParamTypes[i]).asUnpackedType();
        }
        return this.functionTypes.of(returnType, paramTypes);
    }

    private void initArrayClass(WasmGCClassInfo classInfo, ValueType.Array type) {
        classInfo.initializer = target -> {
            WasmGCClassInfo itemTypeInfo = this.getClassInfo(type.getItemType());
            target.add(new WasmCall(this.getCreateArrayClassFunction(), new WasmGetGlobal(classInfo.pointer), new WasmGetGlobal(itemTypeInfo.pointer)));
        };
    }

    private WasmExpression fillPrimitiveClass(WasmGlobal global, String name, int kind) {
        return new WasmCall(this.getCreatePrimitiveClassFunction(), new WasmGetGlobal(global), new WasmGetGlobal(this.strings.getStringConstant((String)name).global), new WasmInt32Constant(kind));
    }

    public int getFieldIndex(FieldReference fieldRef) {
        int result = this.fieldIndexes.getOrDefault((Object)fieldRef, -1);
        if (result < 0) {
            throw new IllegalStateException("Can't get offset of field " + fieldRef);
        }
        return result;
    }

    public int getVirtualMethodIndex(MethodReference methodRef) {
        int result = this.methodIndexes.getOrDefault((Object)methodRef, -1);
        if (result < 0) {
            throw new IllegalStateException("Can't get offset of method " + methodRef);
        }
        return result;
    }

    private void fillFields(List<WasmStorageType> fields, ValueType type) {
        fields.add(this.standardClasses.classClass().getType().asStorage());
        if (type instanceof ValueType.Object) {
            this.fillClassFields(fields, ((ValueType.Object)type).getClassName());
        } else if (type instanceof ValueType.Array) {
            this.fillArrayField(fields, ((ValueType.Array)type).getItemType());
        }
    }

    private void fillClassFields(List<WasmStorageType> fields, String className) {
        ClassReader classReader = this.classSource.get(className);
        if (classReader.hasModifier(ElementModifier.INTERFACE)) {
            this.fillSimpleClassFields(fields, "java.lang.Object");
        } else {
            this.fillSimpleClassFields(fields, className);
        }
    }

    private void fillSimpleClassFields(List<WasmStorageType> fields, String className) {
        ClassReader classReader = this.classSource.get(className);
        if (classReader.getParent() != null) {
            this.fillClassFields(fields, classReader.getParent());
        } else {
            fields.add(this.standardClasses.classClass().getType().asStorage());
        }
        for (FieldReader fieldReader : classReader.getFields()) {
            if (fieldReader.hasModifier(ElementModifier.STATIC)) continue;
            this.fieldIndexes.putIfAbsent((Object)fieldReader.getReference(), fields.size());
            fields.add(this.typeMapper.mapType(fieldReader.getType()));
        }
        if (className.equals("java.lang.Class")) {
            this.classFlagsOffset = fields.size();
            fields.add(WasmType.INT32.asStorage());
            this.classTagOffset = fields.size();
            fields.add(WasmType.INT32.asStorage());
            this.classParentOffset = fields.size();
            fields.add(this.standardClasses.classClass().getType().asStorage());
            this.classArrayItemOffset = fields.size();
            fields.add(this.standardClasses.classClass().getType().asStorage());
            this.classArrayOffset = fields.size();
            fields.add(this.standardClasses.classClass().getType().asStorage());
            this.classSupertypeFunctionOffset = fields.size();
            fields.add(this.supertypeGenerator.getFunctionType().getReference().asStorage());
            this.virtualTableFieldOffset = fields.size();
            this.classNameOffset = this.fieldIndexes.get((Object)new FieldReference(className, "name"));
        }
    }

    private void fillArrayField(List<WasmStorageType> fields, ValueType elementType) {
        WasmArray wasmArray = new WasmArray(null, () -> this.typeMapper.mapType(elementType));
        this.module.types.add(wasmArray);
        fields.add(wasmArray.getReference().asStorage());
    }

    private WasmFunction getCreatePrimitiveClassFunction() {
        if (this.createPrimitiveClassFunction == null) {
            this.createPrimitiveClassFunction = this.createCreatePrimitiveClassFunction();
        }
        return this.createPrimitiveClassFunction;
    }

    private WasmFunction createCreatePrimitiveClassFunction() {
        WasmFunctionType functionType = this.functionTypes.of(null, this.standardClasses.classClass().getType(), this.standardClasses.stringClass().getType(), WasmType.INT32);
        WasmFunction function = new WasmFunction(functionType);
        function.setName("_teavm_fill_primitive_class_");
        WasmLocal targetVar = new WasmLocal(this.standardClasses.classClass().getType(), "target");
        WasmLocal nameVar = new WasmLocal(this.standardClasses.objectClass().getType(), "name");
        WasmLocal kindVar = new WasmLocal(WasmType.INT32, "kind");
        function.getLocalVariables().add(targetVar);
        function.getLocalVariables().add(nameVar);
        function.getLocalVariables().add(kindVar);
        WasmIntBinary flagsExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, new WasmGetLocal(kindVar), new WasmInt32Constant(16));
        flagsExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.OR, flagsExpr, new WasmInt32Constant(32772));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classFlagsOffset, flagsExpr));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classNameOffset, new WasmGetLocal(nameVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classTagOffset, new WasmInt32Constant(Integer.MAX_VALUE)));
        return function;
    }

    private WasmFunction getCreateArrayClassFunction() {
        if (this.createArrayClassFunction == null) {
            this.createArrayClassFunction = this.createCreateArrayClassFunction();
        }
        return this.createCreateArrayClassFunction();
    }

    private WasmFunction createCreateArrayClassFunction() {
        WasmFunctionType functionType = this.functionTypes.of(null, this.standardClasses.classClass().getType(), this.standardClasses.classClass().getType());
        WasmFunction function = new WasmFunction(functionType);
        function.setName("_teavm_fill_array_class_");
        WasmLocal targetVar = new WasmLocal(this.standardClasses.classClass().getType(), "target");
        WasmLocal itemVar = new WasmLocal(this.standardClasses.classClass().getType(), "item");
        function.getLocalVariables().add(targetVar);
        function.getLocalVariables().add(itemVar);
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classFlagsOffset, new WasmInt32Constant(4)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classArrayItemOffset, new WasmGetLocal(itemVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(itemVar), this.classArrayOffset, new WasmGetLocal(targetVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classTagOffset, new WasmInt32Constant(0)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classParentOffset, new WasmGetGlobal(this.standardClasses.classClass().pointer)));
        return function;
    }

    private WasmFunction getInitializer() {
        if (this.initializer == null) {
            this.initializer = new WasmFunction(this.functionTypes.of(null, new WasmType[0]));
            this.initializer.setName("_teavm_init_classes_");
            this.module.functions.add(this.initializer);
        }
        return this.initializer;
    }

    private WasmExpression setClassField(WasmGCClassInfo classInfo, int fieldIndex, WasmExpression value) {
        return new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetGlobal(classInfo.pointer), fieldIndex, value);
    }
}

