/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.parser;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public abstract class DebugSectionParser {
    private String name;
    private List<DebugSectionParser> dependantSections = new ArrayList<DebugSectionParser>();
    byte[] data;
    int ptr;
    private boolean ready;
    private int unsatisfiedDependencies;

    protected DebugSectionParser(String name, DebugSectionParser ... dependencies) {
        this.name = name;
        for (DebugSectionParser dependency : dependencies) {
            dependency.dependantSections.add(this);
        }
        this.unsatisfiedDependencies = dependencies.length;
    }

    public String name() {
        return this.name;
    }

    public boolean ready() {
        return this.ready;
    }

    public void parse(byte[] data) {
        this.data = data;
        if (this.unsatisfiedDependencies == 0) {
            this.parse();
        }
    }

    private void parse() {
        this.doParse();
        this.ready = true;
        this.data = null;
        for (DebugSectionParser dependant : this.dependantSections) {
            if (--dependant.unsatisfiedDependencies != 0 || dependant.data == null) continue;
            dependant.parse();
        }
    }

    protected abstract void doParse();

    protected int readLEB() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.data[this.ptr++];
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    protected int readSignedLEB() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.data[this.ptr++];
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) == 0) {
                if ((b & 0x40) == 0) break;
                result |= -1 << shift + 7;
                break;
            }
            shift += 7;
        }
        return result;
    }

    protected String readString() {
        int length = this.readLEB();
        String result = new String(this.data, this.ptr, length, StandardCharsets.UTF_8);
        this.ptr += length;
        return result;
    }
}

