/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public final class GCVisualizer {
    private static final int WIDTH = 1024;
    private static final int LINE_HEIGHT = 4;
    private static final int GAP_SIZE = 1;
    private static final int GC_GAP_SIZE = 3;

    private GCVisualizer() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Two arguments (input, output) expected");
            System.exit(1);
        }
        List<Line> lines = GCVisualizer.readData(args[0]);
        BufferedImage bitmap = GCVisualizer.createBitmap(lines);
        GCVisualizer.writeBitmap(bitmap, args[1]);
    }

    /*
     * Unable to fully structure code
     */
    private static List<Line> readData(String fileName) throws IOException {
        lines = new ArrayList<Line>();
        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), StandardCharsets.UTF_8));
        try {
            block17: while (true) {
                if ((fileLine = reader.readLine()) == null) {
                    break;
                }
                charIndex = fileLine.indexOf(58);
                if (charIndex < 0) continue;
                kind = fileLine.substring(0, charIndex);
                if (kind.equals("start") || lines.isEmpty()) {
                    lines.add(new Line());
                }
                line = (Line)lines.get(lines.size() - 1);
                var8_10 = kind;
                var9_12 = -1;
                switch (var8_10.hashCode()) {
                    case 109757538: {
                        if (!var8_10.equals("start")) break;
                        var9_12 = 0;
                        break;
                    }
                    case 109850348: {
                        if (!var8_10.equals("sweep")) break;
                        var9_12 = 1;
                        break;
                    }
                    case -1335625229: {
                        if (!var8_10.equals("defrag")) break;
                        var9_12 = 2;
                    }
                }
                switch (var9_12) {
                    case 0: {
                        array = line.start;
                        break;
                    }
                    case 1: {
                        array = line.sweep;
                        break;
                    }
                    case 2: {
                        array = line.defrag;
                        break;
                    }
                    default: {
                        continue block17;
                    }
                }
                charIndex = fileLine.indexOf(32, charIndex);
                if (charIndex < 0) continue;
                ++charIndex;
                i = 0;
                while (true) {
                    if (i >= array.length) continue block17;
                    next = fileLine.indexOf(32, charIndex);
                    if (next < 0) {
                        next = fileLine.length();
                    }
                    try {
                        array[i] = Integer.parseInt(fileLine.substring(charIndex, next));
                    }
                    catch (NumberFormatException var10_13) {
                        // empty catch block
                    }
                    if (next != fileLine.length()) ** break;
                    continue block17;
                    charIndex = next + 1;
                    ++i;
                }
                break;
            }
        }
        finally {
            reader.close();
        }
        return lines;
    }

    private static BufferedImage createBitmap(List<Line> lines) {
        int height = lines.size() * 18;
        int[] data = new int[1024 * height];
        int offset = 0;
        for (Line line : lines) {
            offset = GCVisualizer.renderComponent(data, line.start, offset, 0, 0, 255);
            offset = GCVisualizer.renderComponent(data, line.sweep, offset, 0, 255, 0);
            offset = GCVisualizer.renderComponent(data, line.defrag, offset, 255, 0, 0);
            GCVisualizer.renderLine(data, offset, 3, 0, 0, 0);
            offset += 3072;
        }
        BufferedImage image = new BufferedImage(1024, height, 2);
        image.setRGB(0, 0, 1024, height, data, 0, 1024);
        return image;
    }

    private static int renderComponent(int[] data, int[] array, int offset, int r, int g, int b) {
        GCVisualizer.renderArray(data, array, offset, r, g, b);
        GCVisualizer.renderLine(data, offset += 4096, 1, 0, 0, 0);
        return offset += 1024;
    }

    private static void renderArray(int[] data, int[] array, int offset, int r, int g, int b) {
        for (int i = 0; i < 1024; ++i) {
            int start = array.length * i / 1024;
            int end = array.length * (i + 1) / 1024;
            int total = 0;
            for (int j = start; j < end; ++j) {
                total += array[j];
            }
            double rate = (double)total / (4096.0 * (double)(end - start));
            int pixelR = GCVisualizer.makeColorComponent(r, rate);
            int pixelG = GCVisualizer.makeColorComponent(g, rate);
            int pixelB = GCVisualizer.makeColorComponent(b, rate);
            int pixelOffset = offset;
            int pixel = 0xFF000000 | (pixelR & 0xFF) << 16 | (pixelG & 0xFF) << 8 | pixelB & 0xFF;
            for (int j = 0; j < 4; ++j) {
                data[pixelOffset] = pixel;
                pixelOffset += 1024;
            }
            ++offset;
        }
    }

    private static void renderLine(int[] data, int offset, int height, int r, int g, int b) {
        int count = height * 1024;
        int pixel = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        for (int i = 0; i < count; ++i) {
            data[offset++] = pixel;
        }
    }

    private static int makeColorComponent(int c, double rate) {
        int r = (int)((double)c * rate + 255.0 * (1.0 - rate));
        return Math.min(Math.max(r, 0), 255);
    }

    private static void writeBitmap(BufferedImage image, String fileName) throws IOException {
        ImageIO.write((RenderedImage)image, "png", new File(fileName));
    }

    static class Line {
        int[] start = new int[4096];
        int[] sweep = new int[4096];
        int[] defrag = new int[4096];

        Line() {
        }
    }
}

