/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.ast;

import java.util.Collections;
import java.util.List;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.Expr;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.SequentialStatement;
import org.teavm.ast.StatementVisitor;
import org.teavm.ast.ThrowStatement;

public abstract class Statement {
    public abstract void acceptVisitor(StatementVisitor var1);

    public static Statement empty() {
        return new SequentialStatement();
    }

    public static AssignmentStatement assign(Expr left, Expr right) {
        AssignmentStatement stmt = new AssignmentStatement();
        stmt.setLeftValue(left);
        stmt.setRightValue(right);
        return stmt;
    }

    public static ReturnStatement exitFunction(Expr result) {
        ReturnStatement stmt = new ReturnStatement();
        stmt.setResult(result);
        return stmt;
    }

    public static ThrowStatement raiseException(Expr exception) {
        ThrowStatement stmt = new ThrowStatement();
        stmt.setException(exception);
        return stmt;
    }

    public static Statement cond(Expr predicate, List<Statement> consequent, List<Statement> alternative) {
        ConditionalStatement statement = new ConditionalStatement();
        statement.setCondition(predicate);
        statement.getConsequent().addAll(consequent);
        statement.getAlternative().addAll(alternative);
        return statement;
    }

    public static Statement cond(Expr predicate, List<Statement> consequent) {
        return Statement.cond(predicate, consequent, Collections.emptyList());
    }

    public static InitClassStatement initClass(String className) {
        InitClassStatement stmt = new InitClassStatement();
        stmt.setClassName(className);
        return stmt;
    }
}

