/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import org.teavm.interop.Address;
import org.teavm.interop.Export;
import org.teavm.interop.Import;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Structure;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.ExceptionHandling;
import org.teavm.runtime.FreeChunk;
import org.teavm.runtime.FreeChunkHolder;
import org.teavm.runtime.MarkQueue;
import org.teavm.runtime.MemoryTrace;
import org.teavm.runtime.Mutator;
import org.teavm.runtime.Relocation;
import org.teavm.runtime.RelocationBlock;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;
import org.teavm.runtime.RuntimeReference;
import org.teavm.runtime.RuntimeReferenceQueue;
import org.teavm.runtime.ShadowStack;

@Unmanaged
@StaticInit
public final class GC {
    private static final byte CARD_VALID = 1;
    private static final byte CARD_YOUNG_GEN = 2;
    private static final byte CARD_GAP = 4;
    private static final byte CARD_RELOCATABLE = 8;
    private static final int MIN_CHUNK_SIZE = 8;
    static Address currentChunkLimit;
    static FreeChunk currentChunk;
    static FreeChunkHolder currentChunkPointer;
    static int freeChunks;
    static int totalChunks;
    static int freeMemory;
    static RuntimeReference firstWeakReference;
    static FreeChunk lastChunk;
    static RelocationBlock lastRelocationBlock;
    static boolean isFullGC;
    private static int youngGCCount;

    private GC() {
    }

    static native Address gcStorageAddress();

    static native int gcStorageSize();

    public static native Address heapAddress();

    private static native Region regionsAddress();

    private static native Address cardTable();

    private static native int regionMaxCount();

    public static native long availableBytes();

    public static native long minAvailableBytes();

    public static native long maxAvailableBytes();

    public static native void resizeHeap(long var0);

    public static native boolean canShrinkHeap();

    private static native int regionSize();

    public static native void writeBarrier(RuntimeObject var0);

    @Import(name="teavm_outOfMemory")
    public static native void outOfMemory();

    public static int getFreeMemory() {
        return freeMemory;
    }

    private static int getRegionCount() {
        return (int)(GC.availableBytes() / (long)GC.regionSize()) + 1;
    }

    public static RuntimeObject alloc(int size) {
        FreeChunk current = currentChunk;
        Address next = current.toAddress().add(size);
        if (!next.add(Structure.sizeOf(FreeChunk.class)).isLessThan(currentChunkLimit)) {
            GC.getNextChunk(size);
            current = currentChunk;
            next = current.toAddress().add(size);
        }
        currentChunk = (FreeChunk)next.toStructure();
        freeMemory -= size;
        MemoryTrace.allocate(current.toAddress(), size);
        return (RuntimeObject)current.toAddress().toStructure();
    }

    private static void getNextChunk(int size) {
        if (GC.getNextChunkIfPossible(size)) {
            return;
        }
        GC.collectGarbageImpl(size);
        if (!GC.hasAvailableMemory(size)) {
            GC.collectGarbageFullImpl(size);
            if (!GC.hasAvailableMemory(size)) {
                ExceptionHandling.printStack();
                GC.outOfMemory();
            }
        }
    }

    private static boolean hasAvailableMemory(int size) {
        return GC.currentChunk.size == size || GC.currentChunk.size > size + 8 || GC.getNextChunkIfPossible(size);
    }

    private static boolean getNextChunkIfPossible(int size) {
        while (true) {
            if (currentChunk.toAddress().isLessThan(currentChunkLimit)) {
                GC.currentChunk.classReference = 0;
                GC.currentChunk.size = (int)(currentChunkLimit.toLong() - currentChunk.toAddress().toLong());
            }
            if (--freeChunks == 0) {
                return false;
            }
            currentChunkPointer = (FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)currentChunkPointer, (int)1);
            currentChunk = GC.currentChunkPointer.value;
            if (GC.currentChunk.size >= size + 8 || GC.currentChunk.size == size) break;
            freeMemory -= GC.currentChunk.size;
        }
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        return true;
    }

    @Export(name="teavm_gc_collect")
    public static void collectGarbage() {
        GC.fixHeap();
        GC.collectGarbageImpl(0);
    }

    @Export(name="teavm_gc_collectFull")
    public static void collectGarbageFull() {
        GC.fixHeap();
        GC.collectGarbageFullImpl(0);
    }

    private static void collectGarbageFullImpl(int size) {
        GC.triggerFullGC();
        GC.collectGarbageImpl(size);
    }

    private static void triggerFullGC() {
        isFullGC = true;
        int regionsCount = GC.getRegionCount();
        Allocator.fill(GC.cardTable(), (byte)0, GC.getRegionCount());
        Allocator.fill(GC.regionsAddress().toAddress(), (byte)0, regionsCount * Structure.sizeOf(Region.class));
    }

    private static void collectGarbageImpl(int size) {
        GC.doCollectGarbage();
        long minRequestedSize = 0L;
        if (!GC.hasAvailableChunk(size)) {
            minRequestedSize = GC.computeMinRequestedSize(size);
        }
        if (!isFullGC) {
            int youngGCLimit;
            int n = youngGCLimit = GC.canShrinkHeap() ? 2 : 8;
            if (++youngGCCount >= youngGCLimit && GC.isAboutToExpand(minRequestedSize)) {
                GC.triggerFullGC();
                GC.doCollectGarbage();
                youngGCCount = 0;
            }
        } else {
            youngGCCount = 0;
        }
        isFullGC = false;
        GC.resizeHeapIfNecessary(minRequestedSize);
        currentChunk = GC.currentChunkPointer.value;
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        Allocator.fill(GC.cardTable(), (byte)1, GC.getRegionCount());
    }

    private static void doCollectGarbage() {
        MemoryTrace.gcStarted(isFullGC);
        if (!isFullGC) {
            GC.storeGapsInCardTable();
        }
        GC.mark();
        GC.processReferences();
        GC.sweep();
        GC.defragment();
        GC.updateFreeMemory();
        MemoryTrace.gcCompleted();
        totalChunks = freeChunks;
    }

    private static boolean hasAvailableChunk(int size) {
        if (size == 0) {
            return true;
        }
        FreeChunkHolder ptr = currentChunkPointer;
        for (int i = 0; i < freeChunks; ++i) {
            if (size == ptr.value.size || size + 8 <= ptr.value.size) {
                return true;
            }
            ptr = (FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)ptr, (int)1);
        }
        return false;
    }

    private static long computeMinRequestedSize(int size) {
        if (GC.lastChunk.classReference == 0) {
            size -= GC.lastChunk.size;
        }
        return GC.availableBytes() + (long)size;
    }

    @Export(name="teavm_gc_fixHeap")
    public static void fixHeap() {
        if (freeChunks > 0) {
            GC.currentChunk.classReference = 0;
            GC.currentChunk.size = (int)(currentChunkLimit.toLong() - currentChunk.toAddress().toLong());
        }
    }

    @Export(name="teavm_gc_tryShrink")
    public static void tryShrink() {
        long availableBytes = GC.availableBytes();
        long occupiedMemory = availableBytes - (long)freeMemory;
        if (occupiedMemory < availableBytes / 4L) {
            GC.collectGarbageFull();
        }
    }

    private static void mark() {
        MemoryTrace.markStarted();
        firstWeakReference = null;
        GC.markFromStaticFields();
        GC.markFromClasses();
        GC.markFromStack();
        if (!isFullGC) {
            GC.markFromOldGeneration();
        }
        MemoryTrace.markCompleted();
    }

    private static void markFromStaticFields() {
        Address staticRoots = Mutator.getStaticGCRoots();
        int staticCount = staticRoots.getInt();
        staticRoots = staticRoots.add(Address.sizeOf());
        while (staticCount-- > 0) {
            RuntimeObject object = (RuntimeObject)staticRoots.getAddress().getAddress().toStructure();
            if (object != null) {
                GC.mark(object);
            }
            staticRoots = staticRoots.add(Address.sizeOf());
        }
    }

    private static void markFromClasses() {
        int classCount = Mutator.getClassCount();
        Address classPtr = Mutator.getClasses();
        for (int i = 0; i < classCount; ++i) {
            RuntimeClass cls = (RuntimeClass)classPtr.getAddress().toStructure();
            if (cls.simpleNameCache != null) {
                GC.mark(cls.simpleNameCache);
            }
            if (cls.canonicalName != null) {
                GC.mark(cls.canonicalName);
            }
            if (cls.nameCache != null) {
                GC.mark(cls.nameCache);
            }
            classPtr = classPtr.add(Address.sizeOf());
        }
    }

    private static void markFromStack() {
        Address stackRoots = ShadowStack.getStackTop();
        while (stackRoots != null) {
            int count = ShadowStack.getStackRootCount(stackRoots);
            Address stackRootsPtr = ShadowStack.getStackRootPointer(stackRoots);
            while (count-- > 0) {
                RuntimeObject obj = (RuntimeObject)stackRootsPtr.getAddress().toStructure();
                GC.mark(obj);
                stackRootsPtr = stackRootsPtr.add(Address.sizeOf());
            }
            stackRoots = ShadowStack.getNextStackFrame(stackRoots);
        }
    }

    private static void markFromOldGeneration() {
        int regionIndex;
        int validMask = 0x1010101;
        int regionsCount = GC.getRegionCount();
        int regionSize = GC.regionSize();
        Address cardPtr = GC.cardTable();
        Address regionPtr = GC.heapAddress();
        for (regionIndex = 0; regionIndex < regionsCount - 3; regionIndex += 4) {
            int n = cardPtr.getInt();
            if ((n & validMask) != validMask) {
                for (int i = 0; i < 4; ++i) {
                    n = cardPtr.add(i).getByte();
                    if ((n & 1) != 0) continue;
                    GC.markFromRegion(regionIndex + i);
                }
            }
            cardPtr = cardPtr.add(4);
            regionPtr = regionPtr.add(4 * regionSize);
        }
        while (regionIndex < regionsCount) {
            if ((cardPtr.getByte() & 1) == 0) {
                GC.markFromRegion(regionIndex);
            }
            cardPtr = cardPtr.add(1);
            ++regionIndex;
        }
    }

    private static void markFromRegion(int regionIndex) {
        Address card = GC.cardTable().add(regionIndex);
        int regionOffset = ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)regionIndex)).start;
        if (regionOffset == 0) {
            card.putByte((byte)(card.getByte() | 1));
            return;
        }
        int regionSize = GC.regionSize();
        Address regionStart = GC.heapAddress().add(regionIndex * regionSize);
        MemoryTrace.reportDirtyRegion(regionStart);
        Address regionEnd = regionStart.add(regionSize);
        FreeChunk object = (FreeChunk)regionStart.add(--regionOffset).toStructure();
        Address heapLimit = GC.heapAddress().add(GC.availableBytes());
        if (heapLimit.isLessThan(regionEnd)) {
            regionEnd = heapLimit;
        }
        boolean objectMarked = false;
        while (object.toAddress().isLessThan(regionEnd)) {
            int header = object.classReference;
            if (header != 0 && (header & 0x40000000) != 0) {
                objectMarked |= GC.doMarkOldGeneration((RuntimeObject)object.toAddress().toStructure());
            }
            object = (FreeChunk)object.toAddress().add(GC.objectSize(object)).toStructure();
        }
        if (!objectMarked) {
            card.putByte((byte)(card.getByte() | 1));
        }
    }

    private static void mark(RuntimeObject object) {
        if (object == null || GC.isMarked(object)) {
            return;
        }
        MarkQueue.init();
        GC.enqueueMark(object);
        GC.doProcessMarkQueue();
    }

    private static boolean doMarkOldGeneration(RuntimeObject object) {
        MarkQueue.init();
        boolean hasObjectsFromYoungGen = GC.markObjectData(object);
        GC.doProcessMarkQueue();
        return hasObjectsFromYoungGen;
    }

    private static void doProcessMarkQueue() {
        while (!MarkQueue.isEmpty()) {
            RuntimeObject object = MarkQueue.dequeue();
            MemoryTrace.mark(object.toAddress());
            long offset = object.toAddress().toLong() - GC.heapAddress().toLong();
            Region region = (Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)((int)(offset / (long)GC.regionSize())));
            short relativeOffset = (short)(offset % (long)GC.regionSize() + 1L);
            if (region.start == 0 || region.start > relativeOffset) {
                region.start = relativeOffset;
            }
            Address cardTableItem = GC.cardTable().add(offset / (long)GC.regionSize());
            cardTableItem.putByte((byte)(cardTableItem.getByte() | 2));
            GC.markObjectData(object);
        }
    }

    private static boolean markObjectData(RuntimeObject object) {
        RuntimeClass cls = RuntimeClass.getClass(object);
        if (cls.itemType == null) {
            return GC.markObject(cls, object);
        }
        return GC.markArray(cls, (RuntimeArray)object);
    }

    private static boolean markObject(RuntimeClass cls, RuntimeObject object) {
        boolean hasObjectsFromYoungGen = false;
        while (cls != null) {
            int type = cls.flags >> 6 & 7;
            switch (type) {
                case 1: {
                    hasObjectsFromYoungGen |= GC.markWeakReference((RuntimeReference)object);
                    break;
                }
                case 2: {
                    hasObjectsFromYoungGen |= GC.markReferenceQueue((RuntimeReferenceQueue)object);
                    break;
                }
                default: {
                    hasObjectsFromYoungGen |= GC.markFields(cls, object);
                }
            }
            cls = cls.parent;
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean markWeakReference(RuntimeReference object) {
        boolean hasObjectsFromYoungGen = false;
        if (object.queue != null) {
            hasObjectsFromYoungGen |= GC.enqueueMark(object.queue);
            if (object.next != null && object.object != null) {
                hasObjectsFromYoungGen |= GC.enqueueMark(object.object);
            }
        }
        if (object.next != null) {
            hasObjectsFromYoungGen |= GC.enqueueMark(object.next);
        } else if (object.object != null) {
            object.next = firstWeakReference;
            firstWeakReference = object;
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean markReferenceQueue(RuntimeReferenceQueue object) {
        RuntimeReference reference = object.first;
        boolean hasObjectsFromYoungGen = false;
        if (reference != null) {
            hasObjectsFromYoungGen |= GC.enqueueMark(reference);
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean markFields(RuntimeClass cls, RuntimeObject object) {
        Address layout = cls.layout;
        if (layout == null) {
            return false;
        }
        boolean hasObjectsFromYoungGen = false;
        short fieldCount = layout.getShort();
        while (true) {
            short s = fieldCount;
            fieldCount = (short)(fieldCount - 1);
            if (s <= 0) break;
            layout = layout.add(2);
            short fieldOffset = layout.getShort();
            RuntimeObject reference = (RuntimeObject)object.toAddress().add((int)fieldOffset).getAddress().toStructure();
            hasObjectsFromYoungGen |= GC.enqueueMark(reference);
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean markArray(RuntimeClass cls, RuntimeArray array) {
        if ((cls.itemType.flags & 2) != 0) {
            return false;
        }
        Address base = Address.align((Address)array.toAddress().add(RuntimeArray.class, 1), (int)Address.sizeOf());
        boolean hasObjectsFromYoungGen = false;
        for (int i = 0; i < array.size; ++i) {
            RuntimeObject reference = (RuntimeObject)base.getAddress().toStructure();
            hasObjectsFromYoungGen |= GC.enqueueMark(reference);
            base = base.add(Address.sizeOf());
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean enqueueMark(RuntimeObject object) {
        if (object == null) {
            return false;
        }
        if (!GC.isMarked(object)) {
            GC.doEnqueueMark(object);
            return true;
        }
        return (object.classReference & 0x40000000) == 0;
    }

    private static void doEnqueueMark(RuntimeObject object) {
        object.classReference = isFullGC ? (object.classReference |= 0xC0000000) : (object.classReference |= Integer.MIN_VALUE);
        MarkQueue.enqueue(object);
    }

    private static void processReferences() {
        RuntimeReference reference = firstWeakReference;
        while (reference != null) {
            RuntimeReference next = reference.next;
            reference.next = null;
            if (!GC.isMarked(reference.object)) {
                reference.object = null;
                RuntimeReferenceQueue queue = reference.queue;
                if (queue != null) {
                    if (queue.first == null) {
                        queue.first = reference;
                    } else {
                        queue.last.next = reference;
                        GC.makeInvalid(queue.last);
                    }
                    queue.last = reference;
                    GC.makeInvalid(queue);
                }
            }
            reference = next;
        }
    }

    private static void makeInvalid(RuntimeObject object) {
        long offset = object.toAddress().toLong() - GC.heapAddress().toLong();
        Address cardTableItem = GC.cardTable().add(offset / (long)GC.regionSize());
        cardTableItem.putByte((byte)(cardTableItem.getByte() & 0xFFFFFFFE));
    }

    private static void sweep() {
        MemoryTrace.sweepStarted();
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        freeChunks = 0;
        totalChunks = 0;
        FreeChunk object = (FreeChunk)GC.heapAddress().toStructure();
        FreeChunk lastFreeSpace = null;
        long heapSize = GC.availableBytes();
        int regionsCount = GC.getRegionCount();
        Address currentRegionEnd = null;
        Address limit = GC.heapAddress().add(heapSize);
        block0: while (object.toAddress().isLessThan(limit)) {
            int currentRegionIndex;
            boolean free;
            int tag = object.classReference;
            if (tag == 0) {
                free = true;
            } else {
                boolean bl = free = (tag & Integer.MIN_VALUE) == 0;
                if (free && !isFullGC && (tag & 0x40000000) != 0) {
                    free = false;
                }
                if (!free) {
                    tag &= Integer.MAX_VALUE;
                }
                object.classReference = tag;
            }
            if (free) {
                if (lastFreeSpace == null) {
                    lastFreeSpace = object;
                }
                if (!object.toAddress().isLessThan(currentRegionEnd)) {
                    currentRegionIndex = (int)((object.toAddress().toLong() - GC.heapAddress().toLong()) / (long)GC.regionSize());
                    Region currentRegion = (Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)currentRegionIndex);
                    currentRegionEnd = GC.heapAddress().add((currentRegionIndex + 1) * GC.regionSize());
                    if (currentRegion.start == 0) {
                        do {
                            if (++currentRegionIndex == regionsCount) {
                                object = (FreeChunk)limit.toStructure();
                                break block0;
                            }
                            currentRegion = (Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)currentRegionIndex);
                        } while (currentRegion.start == 0);
                        Address newRegionStart = GC.heapAddress().add(currentRegionIndex * GC.regionSize());
                        object = (FreeChunk)newRegionStart.add(currentRegion.start - 1).toStructure();
                        currentRegionEnd = newRegionStart.add(GC.regionSize());
                        continue;
                    }
                }
            } else {
                if (lastFreeSpace != null) {
                    GC.freeMemory(lastFreeSpace, object);
                    lastFreeSpace = null;
                }
                if (!object.toAddress().isLessThan(currentRegionEnd)) {
                    currentRegionIndex = (int)((object.toAddress().toLong() - GC.heapAddress().toLong()) / (long)GC.regionSize());
                    currentRegionEnd = GC.heapAddress().add((currentRegionIndex + 1) * GC.regionSize());
                    FreeChunk formerObject = object;
                    if (!isFullGC && (GC.cardTable().add(currentRegionIndex).getByte() & 2) == 0 && (GC.cardTable().add(currentRegionIndex).getByte() & 4) == 0) {
                        Region currentRegion;
                        while (++currentRegionIndex != regionsCount) {
                            currentRegion = (Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)currentRegionIndex);
                            if (currentRegion.start != 0 && (GC.cardTable().add(currentRegionIndex).getByte() & 2) == 0 && (GC.cardTable().add(currentRegionIndex).getByte() & 4) == 0) continue;
                        }
                        currentRegion = (Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)(--currentRegionIndex));
                        Address newRegionStart = GC.heapAddress().add(currentRegionIndex * GC.regionSize());
                        object = (FreeChunk)newRegionStart.add(currentRegion.start - 1).toStructure();
                        currentRegionEnd = newRegionStart.add(GC.regionSize());
                        if (formerObject.toAddress().isLessThan(object.toAddress())) continue;
                    }
                }
            }
            int size = GC.objectSize(object);
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        if (lastFreeSpace != null) {
            GC.freeMemory(lastFreeSpace, object);
        }
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        MemoryTrace.sweepCompleted();
    }

    private static void storeGapsInCardTable() {
        for (int i = 0; i < totalChunks; ++i) {
            FreeChunk freeChunkStart = ((FreeChunkHolder)FreeChunkHolder.add(FreeChunkHolder.class, (Structure)((FreeChunkHolder)GC.gcStorageAddress().toStructure()), (int)i)).value;
            long freeChunkOffset = freeChunkStart.toAddress().toLong() - GC.heapAddress().toLong();
            long freeChunkEndOffset = freeChunkOffset + (long)freeChunkStart.size;
            int startRegion = (int)(freeChunkOffset / (long)GC.regionSize());
            int endRegion = (int)(freeChunkEndOffset / (long)GC.regionSize());
            for (int region = startRegion; region <= endRegion; ++region) {
                Address card = GC.cardTable().add(region);
                card.putByte((byte)(card.getByte() | 4));
            }
        }
    }

    private static void clearGapsFromCardTable() {
        int regionIndex;
        int gapMask = -67372037;
        int regionsCount = GC.getRegionCount();
        Address cardPtr = GC.cardTable();
        for (regionIndex = 0; regionIndex < regionsCount - 3; regionIndex += 4) {
            cardPtr.putInt(cardPtr.getInt() & gapMask);
            cardPtr = cardPtr.add(4);
        }
        while (regionIndex < regionsCount) {
            cardPtr.putByte((byte)(cardPtr.getByte() & 0xFFFFFFFB));
            cardPtr = cardPtr.add(1);
            ++regionIndex;
        }
    }

    private static void freeMemory(FreeChunk from, FreeChunk to) {
        from.classReference = 0;
        from.size = (int)(to.toAddress().toLong() - from.toAddress().toLong());
        MemoryTrace.free(from.toAddress(), from.size);
        GC.currentChunkPointer.value = from;
        currentChunkPointer = (FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)currentChunkPointer, (int)1);
        ++freeChunks;
        ++totalChunks;
    }

    private static void defragment() {
        MemoryTrace.defragStarted();
        GC.clearGapsFromCardTable();
        GC.storeGapsInCardTable();
        GC.markStackRoots();
        GC.moveNonRelocatableObjectsToOldGeneration();
        GC.calculateRelocationTargets();
        GC.updatePointersFromStaticRoots();
        GC.updatePointersFromClasses();
        GC.updatePointersFromObjects();
        GC.restoreObjectHeaders();
        GC.relocateObjects();
        GC.putNewFreeChunks();
        MemoryTrace.defragCompleted();
    }

    private static void markStackRoots() {
        Address relocationThreshold = GC.currentChunkPointer.value.toAddress();
        Address stackRoots = ShadowStack.getStackTop();
        while (stackRoots != null) {
            int count = ShadowStack.getStackRootCount(stackRoots);
            Address stackRootsPtr = ShadowStack.getStackRootPointer(stackRoots);
            while (count-- > 0) {
                RuntimeObject obj = (RuntimeObject)stackRootsPtr.getAddress().toStructure();
                if (!obj.toAddress().isLessThan(relocationThreshold) && (isFullGC || (obj.classReference & 0x40000000) == 0)) {
                    obj.classReference |= Integer.MIN_VALUE;
                }
                stackRootsPtr = stackRootsPtr.add(Address.sizeOf());
            }
            stackRoots = ShadowStack.getNextStackFrame(stackRoots);
        }
    }

    private static void moveNonRelocatableObjectsToOldGeneration() {
        Address limitAddress = GC.currentChunkPointer.value.toAddress();
        long limit = limitAddress.toLong() - GC.heapAddress().toLong();
        int region = 0;
        while ((long)region * (long)GC.regionSize() < limit) {
            if ((GC.cardTable().add(region).getByte() & 2) != 0) {
                GC.moveObjectsToOldGenerationInRegion(region, limitAddress);
            }
            ++region;
        }
    }

    private static void moveObjectsToOldGenerationInRegion(int region, Address limit) {
        int regionOffset = ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)region)).start - 1;
        int regionSize = GC.regionSize();
        Address regionStart = GC.heapAddress().add(region * regionSize);
        Address regionEnd = regionStart.add(regionSize);
        FreeChunk object = (FreeChunk)regionStart.add(regionOffset).toStructure();
        if (limit.isLessThan(regionEnd)) {
            regionEnd = limit;
        }
        while (object.toAddress().isLessThan(regionEnd)) {
            int classRef = object.classReference;
            if (classRef != 0 && (classRef & 0x40000000) == 0) {
                object.classReference = classRef |= 0x40000000;
            }
            int size = GC.objectSize(object);
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
    }

    private static void calculateRelocationTargets() {
        int size;
        Address relocationTarget;
        Address start = GC.heapAddress();
        long heapSize = GC.availableBytes();
        Address limit = start.add(heapSize);
        FreeChunkHolder freeChunkPointer = currentChunkPointer;
        int freeChunks = GC.freeChunks;
        FreeChunk freeChunk = GC.currentChunkPointer.value;
        FreeChunk object = (FreeChunk)freeChunk.toAddress().add(freeChunk.size).toStructure();
        RelocationBlock relocationBlock = (RelocationBlock)((FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)currentChunkPointer, (int)freeChunks)).toAddress().toStructure();
        relocationBlock.start = relocationTarget = freeChunk.toAddress();
        relocationBlock.end = limit;
        relocationBlock.count = 0;
        RelocationBlock lastRelocationBlock = relocationBlock;
        int countInCurrentRelocationBlock = 0;
        Address relocations = ((FreeChunk)Structure.add(FreeChunk.class, (Structure)freeChunk, (int)1)).toAddress();
        Address relocationsLimit = freeChunk.toAddress().add(freeChunk.size);
        Address currentRegionEnd = null;
        lastChunk = (FreeChunk)GC.heapAddress().toStructure();
        boolean lastWasLocked = false;
        block0: while (object.toAddress().isLessThan(limit)) {
            size = GC.objectSize(object);
            if (object.classReference != 0) {
                Address nextRelocationTarget = null;
                boolean shouldRelocateObject = GC.shouldRelocateObject(object);
                object.classReference |= 0x40000000;
                if (shouldRelocateObject) {
                    while ((nextRelocationTarget = relocationTarget.add(size)) != relocationBlock.end && !nextRelocationTarget.add(7).isLessThan(relocationBlock.end)) {
                        RelocationBlock nextRelocationBlock = (RelocationBlock)Structure.add(RelocationBlock.class, (Structure)relocationBlock, (int)1);
                        if (nextRelocationBlock.start == object.toAddress()) {
                            shouldRelocateObject = false;
                            break;
                        }
                        relocationBlock.count = countInCurrentRelocationBlock;
                        countInCurrentRelocationBlock = 0;
                        relocationBlock = nextRelocationBlock;
                        relocationTarget = relocationBlock.start;
                    }
                }
                if (!shouldRelocateObject) {
                    if (!lastWasLocked) {
                        lastRelocationBlock.end = object.toAddress();
                        lastRelocationBlock = (RelocationBlock)Structure.add(RelocationBlock.class, (Structure)lastRelocationBlock, (int)1);
                        lastRelocationBlock.end = limit;
                        lastWasLocked = true;
                    }
                    if (!isFullGC && !object.toAddress().isLessThan(currentRegionEnd)) {
                        int region = (int)((object.toAddress().toLong() - GC.heapAddress().toLong()) / (long)GC.regionSize());
                        currentRegionEnd = GC.heapAddress().add((long)GC.regionSize() * (long)(region + 1));
                        byte card = GC.cardTable().add(region).getByte();
                        if ((card & 2) == 0 && (card & 4) == 0) {
                            while (((card = GC.cardTable().add(++region).getByte()) & 2) == 0 && (card & 4) == 0 && ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)region)).start != 0) {
                            }
                            currentRegionEnd = GC.heapAddress().add((long)GC.regionSize() * (long)(--region + 1));
                            int offset = ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)region)).start - 1;
                            object = (FreeChunk)GC.heapAddress().add((long)GC.regionSize() * (long)region).add(offset).toStructure();
                            size = GC.objectSize(object);
                        }
                    }
                    lastRelocationBlock.start = object.toAddress().add(size);
                    lastRelocationBlock.count = 0;
                    object.classReference &= Integer.MAX_VALUE;
                    lastChunk = object;
                } else {
                    lastWasLocked = false;
                    while (!relocations.add(Structure.sizeOf(Relocation.class)).isLessThan(relocationsLimit)) {
                        if (--freeChunks == 0) {
                            lastRelocationBlock.end = object.toAddress();
                            break block0;
                        }
                        freeChunkPointer = (FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)freeChunkPointer, (int)1);
                        freeChunk = freeChunkPointer.value;
                        relocations = ((FreeChunk)Structure.add(FreeChunk.class, (Structure)freeChunk, (int)1)).toAddress();
                        relocationsLimit = freeChunk.toAddress().add(freeChunk.size);
                    }
                    Relocation relocation = (Relocation)relocations.toStructure();
                    relocation.classBackup = object.classReference;
                    relocation.sizeBackup = object.size;
                    relocation.newAddress = relocationTarget;
                    ++countInCurrentRelocationBlock;
                    relocations = relocations.add(Structure.sizeOf(Relocation.class));
                    long targetAddress = relocation.toAddress().toLong();
                    object.classReference = (int)(targetAddress >>> 33) | Integer.MIN_VALUE;
                    object.size = (int)(targetAddress >> 1);
                    relocationTarget = nextRelocationTarget;
                    int region = (int)((object.toAddress().toLong() - GC.heapAddress().toLong()) / (long)GC.regionSize());
                    Address card = GC.cardTable().add(region);
                    card.putByte((byte)(card.getByte() | 8));
                }
            } else {
                lastWasLocked = false;
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        relocationBlock.count = countInCurrentRelocationBlock;
        while (object.toAddress().isLessThan(limit)) {
            size = GC.objectSize(object);
            if (object.classReference != 0) {
                int classRef = object.classReference;
                classRef &= Integer.MAX_VALUE;
                object.classReference = classRef |= 0x40000000;
            } else {
                lastRelocationBlock = (RelocationBlock)Structure.add(RelocationBlock.class, (Structure)lastRelocationBlock, (int)1);
                lastRelocationBlock.start = object.toAddress();
                lastRelocationBlock.count = 0;
                lastRelocationBlock.end = lastRelocationBlock.start.add(size);
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        GC.lastRelocationBlock = lastRelocationBlock;
    }

    private static boolean shouldRelocateObject(FreeChunk object) {
        return (object.classReference & Integer.MIN_VALUE) == 0 && (isFullGC || (object.classReference & 0x40000000) == 0);
    }

    private static void updatePointersFromStaticRoots() {
        Address staticRoots = Mutator.getStaticGCRoots();
        int staticCount = staticRoots.getInt();
        staticRoots = staticRoots.add(Address.sizeOf());
        while (staticCount-- > 0) {
            Address staticRoot = staticRoots.getAddress();
            staticRoot.putAddress(GC.updatePointer(staticRoot.getAddress()));
            staticRoots = staticRoots.add(Address.sizeOf());
        }
    }

    private static void updatePointersFromClasses() {
        int classCount = Mutator.getClassCount();
        Address classPtr = Mutator.getClasses();
        for (int i = 0; i < classCount; ++i) {
            RuntimeClass cls = (RuntimeClass)classPtr.getAddress().toStructure();
            if (cls.simpleNameCache != null) {
                cls.simpleNameCache = (RuntimeObject)GC.updatePointer(cls.simpleNameCache.toAddress()).toStructure();
            }
            if (cls.canonicalName != null) {
                cls.canonicalName = (RuntimeObject)GC.updatePointer(cls.canonicalName.toAddress()).toStructure();
            }
            if (cls.nameCache != null) {
                cls.nameCache = (RuntimeObject)GC.updatePointer(cls.nameCache.toAddress()).toStructure();
            }
            classPtr = classPtr.add(Address.sizeOf());
        }
    }

    private static void updatePointersFromObjects() {
        if (isFullGC) {
            GC.updatePointersFromObjectsFull();
        } else {
            GC.updatePointersFromObjectsYoung();
        }
    }

    private static void updatePointersFromObjectsFull() {
        Address start = GC.heapAddress();
        long heapSize = GC.availableBytes();
        Address limit = start.add(heapSize);
        FreeChunk object = (FreeChunk)GC.heapAddress().toStructure();
        while (object.toAddress().isLessThan(limit)) {
            int size;
            int classRef = object.classReference;
            if (classRef != 0) {
                Relocation relocation = GC.getRelocation(object.toAddress());
                if (relocation != null) {
                    classRef = relocation.classBackup;
                }
                RuntimeClass cls = RuntimeClass.unpack(classRef);
                RuntimeObject realObject = (RuntimeObject)object.toAddress().toStructure();
                GC.updatePointers(cls, realObject);
                size = GC.objectSize(realObject, cls);
            } else {
                size = object.size;
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
    }

    private static void updatePointersFromObjectsYoung() {
        int n;
        int regionIndex;
        int validMask = 0x1010101;
        int youngMask = 0x2020202;
        int regionsCount = GC.getRegionCount();
        int regionSize = GC.regionSize();
        Address cardPtr = GC.cardTable();
        Address regionPtr = GC.heapAddress();
        for (regionIndex = 0; regionIndex < regionsCount - 3; regionIndex += 4) {
            n = cardPtr.getInt();
            if ((n & validMask) != validMask || (n & youngMask) != 0) {
                for (int i = 0; i < 4; ++i) {
                    n = cardPtr.add(i).getByte();
                    if ((n & 1) != 0 && (n & 2) == 0) continue;
                    GC.updatePointersFromRegion(regionIndex + i);
                }
            }
            cardPtr = cardPtr.add(4);
            regionPtr = regionPtr.add(4 * regionSize);
        }
        while (regionIndex < regionsCount) {
            n = cardPtr.getByte();
            if ((n & 1) == 0 || (n & 2) != 0) {
                GC.updatePointersFromRegion(regionIndex);
            }
            cardPtr = cardPtr.add(1);
            ++regionIndex;
        }
    }

    private static void updatePointersFromRegion(int regionIndex) {
        int regionOffset = ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)regionIndex)).start - 1;
        if (regionOffset < 0) {
            return;
        }
        int regionSize = GC.regionSize();
        Address regionStart = GC.heapAddress().add(regionIndex * regionSize);
        Address regionEnd = regionStart.add(regionSize);
        FreeChunk object = (FreeChunk)regionStart.add(regionOffset).toStructure();
        Address heapLimit = GC.heapAddress().add(GC.availableBytes());
        if (heapLimit.isLessThan(regionEnd)) {
            regionEnd = heapLimit;
        }
        while (object.toAddress().isLessThan(regionEnd)) {
            int size;
            int classRef = object.classReference;
            if (classRef != 0) {
                Relocation relocation = GC.getRelocation(object.toAddress());
                if (relocation != null) {
                    classRef = relocation.classBackup;
                }
                RuntimeClass cls = RuntimeClass.unpack(classRef);
                GC.updatePointers(cls, (RuntimeObject)object.toAddress().toStructure());
                size = GC.objectSize((RuntimeObject)object.toAddress().toStructure(), cls);
            } else {
                size = object.size;
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
    }

    private static void updatePointers(RuntimeClass cls, RuntimeObject object) {
        if (cls.itemType == null) {
            GC.updatePointersInObject(cls, object);
        } else {
            GC.updatePointersInArray(cls, (RuntimeArray)object);
        }
    }

    private static void updatePointersInObject(RuntimeClass cls, RuntimeObject object) {
        while (cls != null) {
            int type = cls.flags >> 6 & 7;
            switch (type) {
                case 1: {
                    GC.updatePointersInWeakReference((RuntimeReference)object);
                    break;
                }
                case 2: {
                    GC.updatePointersInReferenceQueue((RuntimeReferenceQueue)object);
                    break;
                }
                default: {
                    GC.updatePointersInFields(cls, object);
                }
            }
            cls = cls.parent;
        }
    }

    private static void updatePointersInWeakReference(RuntimeReference object) {
        object.queue = (RuntimeReferenceQueue)GC.updatePointer(object.queue.toAddress()).toStructure();
        object.next = (RuntimeReference)GC.updatePointer(object.next.toAddress()).toStructure();
        object.object = (RuntimeObject)GC.updatePointer(object.object.toAddress()).toStructure();
    }

    private static void updatePointersInReferenceQueue(RuntimeReferenceQueue object) {
        object.first = (RuntimeReference)GC.updatePointer(object.first.toAddress()).toStructure();
        object.last = (RuntimeReference)GC.updatePointer(object.last.toAddress()).toStructure();
    }

    private static void updatePointersInFields(RuntimeClass cls, RuntimeObject object) {
        Address layout = cls.layout;
        if (layout != null) {
            short fieldCount = layout.getShort();
            while (true) {
                short s = fieldCount;
                fieldCount = (short)(fieldCount - 1);
                if (s <= 0) break;
                layout = layout.add(2);
                short fieldOffset = layout.getShort();
                Address referenceHolder = object.toAddress().add((int)fieldOffset);
                referenceHolder.putAddress(GC.updatePointer(referenceHolder.getAddress()));
            }
        }
    }

    private static void updatePointersInArray(RuntimeClass cls, RuntimeArray array) {
        if ((cls.itemType.flags & 2) != 0) {
            return;
        }
        Address base = Address.align((Address)array.toAddress().add(RuntimeArray.class, 1), (int)Address.sizeOf());
        int size = array.size;
        for (int i = 0; i < size; ++i) {
            base.putAddress(GC.updatePointer(base.getAddress()));
            base = base.add(Address.sizeOf());
        }
    }

    private static Address updatePointer(Address address) {
        if (address == null) {
            return null;
        }
        Relocation relocation = GC.getRelocation(address);
        return relocation != null ? relocation.newAddress : address;
    }

    private static Relocation getRelocation(Address address) {
        if (address.isLessThan(GC.heapAddress()) || !address.isLessThan(GC.heapAddress().add(GC.availableBytes()))) {
            return null;
        }
        FreeChunk obj = (FreeChunk)address.toStructure();
        if ((obj.classReference & Integer.MIN_VALUE) == 0) {
            return null;
        }
        long result = ((long)obj.classReference & 0xFFFFFFFFL) << 33 | ((long)obj.size & 0xFFFFFFFFL) << 1;
        return (Relocation)Address.fromLong((long)result).toStructure();
    }

    private static void restoreObjectHeaders() {
        int regionIndex;
        int relocatableMask = 0x8080808;
        int regionsCount = GC.getRegionCount();
        Address cardPtr = GC.cardTable();
        Address limit = GC.heapAddress().add(GC.availableBytes());
        for (regionIndex = 0; regionIndex < regionsCount - 3; regionIndex += 4) {
            int n = cardPtr.getInt();
            if ((n & relocatableMask) != 0) {
                for (int i = 0; i < 4; ++i) {
                    n = cardPtr.add(i).getByte();
                    if ((n & 8) == 0) continue;
                    GC.restoreObjectHeadersInRegion(regionIndex + i, limit);
                }
            }
            cardPtr = cardPtr.add(4);
        }
        while (regionIndex < regionsCount) {
            if ((cardPtr.getByte() & 8) != 0) {
                GC.restoreObjectHeadersInRegion(regionIndex, limit);
            }
            cardPtr = cardPtr.add(1);
            ++regionIndex;
        }
    }

    private static void restoreObjectHeadersInRegion(int region, Address limit) {
        int regionOffset = ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)region)).start - 1;
        int regionSize = GC.regionSize();
        Address regionStart = GC.heapAddress().add(region * regionSize);
        Address regionEnd = regionStart.add(regionSize);
        FreeChunk object = (FreeChunk)regionStart.add(regionOffset).toStructure();
        if (limit.isLessThan(regionEnd)) {
            regionEnd = limit;
        }
        GC.restoreObjectHeadersInRange(object, regionEnd);
    }

    private static void restoreObjectHeadersInRange(FreeChunk object, Address limit) {
        while (object.toAddress().isLessThan(limit)) {
            Relocation relocation = GC.getRelocation(object.toAddress());
            if (relocation != null) {
                object.classReference = relocation.classBackup | Integer.MIN_VALUE;
                object.size = relocation.sizeBackup;
            }
            int size = GC.objectSize(object);
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
    }

    private static void relocateObjects() {
        Address start = GC.heapAddress();
        long heapSize = GC.availableBytes();
        Address limit = start.add(heapSize);
        int freeChunks = GC.freeChunks;
        FreeChunk freeChunk = GC.currentChunkPointer.value;
        FreeChunk object = (FreeChunk)freeChunk.toAddress().add(freeChunk.size).toStructure();
        RelocationBlock relocationBlock = (RelocationBlock)((FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)currentChunkPointer, (int)freeChunks)).toAddress().toStructure();
        int countInRelocationBlock = relocationBlock.count;
        Address relocationTarget = relocationBlock.start;
        Address blockTarget = null;
        Address blockSource = null;
        int blockSize = 0;
        Address currentRegionEnd = null;
        int regionCount = GC.getRegionCount();
        while (object.toAddress().isLessThan(limit)) {
            int size = GC.objectSize(object);
            if ((object.classReference & Integer.MIN_VALUE) != 0) {
                object.classReference &= Integer.MAX_VALUE;
                while (countInRelocationBlock == 0) {
                    if (blockSize != 0) {
                        GC.moveMemoryBlock(blockSource, blockTarget, blockSize);
                        blockSource = null;
                        blockSize = 0;
                    }
                    relocationBlock.start = relocationTarget;
                    relocationBlock = (RelocationBlock)Structure.add(RelocationBlock.class, (Structure)relocationBlock, (int)1);
                    countInRelocationBlock = relocationBlock.count;
                    relocationTarget = relocationBlock.start;
                }
                if (blockSource == null) {
                    blockSource = object.toAddress();
                    blockTarget = relocationTarget;
                }
                relocationTarget = relocationTarget.add(size);
                blockSize += size;
                --countInRelocationBlock;
            } else {
                if (blockSource != null) {
                    GC.moveMemoryBlock(blockSource, blockTarget, blockSize);
                    blockSource = null;
                    blockSize = 0;
                }
                if (object.classReference != 0 && !object.toAddress().isLessThan(currentRegionEnd)) {
                    int region = (int)((object.toAddress().toLong() - GC.heapAddress().toLong()) / (long)GC.regionSize());
                    currentRegionEnd = GC.heapAddress().add((long)GC.regionSize() * (long)(region + 1));
                    byte card = GC.cardTable().add(region).getByte();
                    if ((card & 8) == 0 && (card & 4) == 0) {
                        while (++region < regionCount && ((card = GC.cardTable().add(region).getByte()) & 8) == 0 && (card & 4) == 0 && ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)region)).start != 0) {
                        }
                        currentRegionEnd = GC.heapAddress().add((long)GC.regionSize() * (long)(--region + 1));
                        int offset = ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)region)).start - 1;
                        object = (FreeChunk)GC.heapAddress().add((long)GC.regionSize() * (long)region).add(offset).toStructure();
                        size = GC.objectSize(object);
                    }
                }
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        relocationBlock.start = relocationTarget;
        if (blockSource != null) {
            GC.moveMemoryBlock(blockSource, blockTarget, blockSize);
        }
    }

    private static void moveMemoryBlock(Address blockSource, Address blockTarget, int blockSize) {
        long sourceStartOffset = blockSource.toLong() - GC.heapAddress().toLong();
        int sourceStartRegionIndex = (int)(sourceStartOffset / (long)GC.regionSize());
        Region sourceStartRegion = (Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)sourceStartRegionIndex);
        long sourceEndOffset = sourceStartOffset + (long)blockSize;
        int sourceEndRegionIndex = (int)(sourceEndOffset / (long)GC.regionSize());
        Region sourceEndRegion = (Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)sourceEndRegionIndex);
        if (sourceStartRegion != sourceEndRegion && sourceStartOffset % (long)GC.regionSize() + 1L == (long)sourceStartRegion.start) {
            sourceStartRegion.start = 0;
        }
        for (int i = sourceStartRegionIndex + 1; i < sourceEndRegionIndex; ++i) {
            ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)i)).start = 0;
        }
        if (sourceStartRegion != sourceEndRegion || sourceStartOffset % (long)GC.regionSize() + 1L == (long)sourceStartRegion.start) {
            Address heapLimit = GC.heapAddress().add(GC.availableBytes());
            FreeChunk objectAfterSource = (FreeChunk)blockSource.add(blockSize).toStructure();
            if (objectAfterSource.toAddress().isLessThan(heapLimit)) {
                int objectRegionIndex = sourceEndRegionIndex;
                if (objectAfterSource.classReference == 0) {
                    objectAfterSource = (FreeChunk)objectAfterSource.toAddress().add(objectAfterSource.size).toStructure();
                    objectRegionIndex = (int)((objectAfterSource.toAddress().toLong() - GC.heapAddress().toLong()) / (long)GC.regionSize());
                }
                sourceEndRegion.start = objectRegionIndex != sourceEndRegionIndex || !objectAfterSource.toAddress().isLessThan(heapLimit) ? (short)0 : (short)((objectAfterSource.toAddress().toLong() - GC.heapAddress().toLong()) % (long)GC.regionSize() + 1L);
            } else {
                sourceEndRegion.start = 0;
            }
        }
        Allocator.moveMemoryBlock(blockSource, blockTarget, blockSize);
        FreeChunk object = (FreeChunk)blockTarget.toStructure();
        Address blockTargetEnd = blockTarget.add(blockSize);
        Address currentRegionEnd = null;
        while (object.toAddress().isLessThan(blockTargetEnd)) {
            if (!object.toAddress().isLessThan(currentRegionEnd)) {
                long offset = object.toAddress().toLong() - GC.heapAddress().toLong();
                int regionIndex = (int)(offset / (long)GC.regionSize());
                currentRegionEnd = GC.heapAddress().add((long)GC.regionSize() * (long)(regionIndex + 1));
                Region region = (Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)regionIndex);
                int offsetInRegion = (int)(offset % (long)GC.regionSize());
                if (region.start == 0 || region.start - 1 > offsetInRegion) {
                    region.start = (short)(offsetInRegion + 1);
                }
            }
            int size = GC.objectSize(object);
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        MemoryTrace.move(blockSource, blockTarget, blockSize);
    }

    private static void putNewFreeChunks() {
        FreeChunkHolder freeChunkPointer = currentChunkPointer;
        RelocationBlock relocationBlock = (RelocationBlock)((FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)currentChunkPointer, (int)freeChunks)).toAddress().toStructure();
        freeChunks = 0;
        while (!lastRelocationBlock.toAddress().isLessThan(relocationBlock.toAddress())) {
            if (relocationBlock.start.isLessThan(relocationBlock.end)) {
                FreeChunk freeChunk = (FreeChunk)relocationBlock.start.toStructure();
                if (!freeChunk.toAddress().isLessThan(lastChunk.toAddress())) {
                    lastChunk = freeChunk;
                }
                freeChunk.size = (int)(relocationBlock.end.toLong() - relocationBlock.start.toLong());
                freeChunk.classReference = 0;
                MemoryTrace.assertFree(freeChunk.toAddress(), freeChunk.size);
                freeChunkPointer.value = freeChunk;
                freeChunkPointer = (FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)freeChunkPointer, (int)1);
                ++freeChunks;
            }
            relocationBlock = (RelocationBlock)Structure.add(RelocationBlock.class, (Structure)relocationBlock, (int)1);
        }
        totalChunks = freeChunks;
    }

    private static void updateFreeMemory() {
        freeMemory = 0;
        FreeChunkHolder freeChunkPtr = currentChunkPointer;
        for (int i = 0; i < freeChunks; ++i) {
            freeMemory += freeChunkPtr.value.size;
            freeChunkPtr = (FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)freeChunkPtr, (int)1);
        }
    }

    private static void resizeHeapConsistent(long newSize) {
        long oldSize = GC.availableBytes();
        if (newSize == oldSize) {
            return;
        }
        if (newSize > oldSize) {
            int previousRegionCount = GC.getRegionCount();
            GC.resizeHeap(newSize);
            currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
            int newRegionCount = GC.getRegionCount();
            for (int i = previousRegionCount; i < newRegionCount; ++i) {
                ((Region)Structure.add(Region.class, (Structure)GC.regionsAddress(), (int)i)).start = 0;
            }
            if (GC.lastChunk.classReference == 0) {
                GC.lastChunk.size += (int)(newSize - oldSize);
            } else {
                int size = GC.objectSize(lastChunk);
                lastChunk = (FreeChunk)lastChunk.toAddress().add(size).toStructure();
                GC.lastChunk.classReference = 0;
                GC.lastChunk.size = (int)(newSize - oldSize);
                ((FreeChunkHolder)Structure.add(FreeChunkHolder.class, (Structure)GC.currentChunkPointer, (int)GC.freeChunks)).value = lastChunk;
                ++freeChunks;
                ++totalChunks;
            }
        } else if (GC.canShrinkHeap()) {
            long minimumSize = lastChunk.toAddress().toLong() - GC.heapAddress().toLong();
            if (GC.lastChunk.classReference != 0) {
                minimumSize += (long)GC.objectSize(lastChunk);
            }
            if (newSize < minimumSize && (newSize = minimumSize) == oldSize) {
                return;
            }
            if (newSize == minimumSize) {
                --freeChunks;
                --totalChunks;
            } else {
                GC.lastChunk.size -= (int)(oldSize - newSize);
            }
            GC.resizeHeap(newSize);
            currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        }
    }

    private static void resizeHeapIfNecessary(long requestedSize) {
        long availableBytes = GC.availableBytes();
        long occupiedMemory = availableBytes - (long)freeMemory;
        if (GC.isAboutToExpand(requestedSize)) {
            long newSize = GC.max(requestedSize, (availableBytes - (long)freeMemory) * 2L);
            if ((newSize = GC.min(newSize, GC.maxAvailableBytes())) != availableBytes) {
                if (newSize % 8L != 0L) {
                    newSize += 8L - newSize % 8L;
                }
                GC.resizeHeapConsistent(newSize);
            }
        } else if (occupiedMemory < availableBytes / 4L) {
            long newSize = occupiedMemory * 3L;
            if ((newSize = GC.max(newSize, GC.minAvailableBytes())) % 8L != 0L) {
                newSize -= newSize % 8L;
            }
            GC.resizeHeapConsistent(newSize);
        }
    }

    private static boolean isAboutToExpand(long requestedSize) {
        long availableBytes = GC.availableBytes();
        long occupiedMemory = availableBytes - (long)freeMemory;
        return requestedSize > availableBytes || occupiedMemory > availableBytes / 2L;
    }

    private static long min(long a, long b) {
        return a < b ? a : b;
    }

    private static long max(long a, long b) {
        return a > b ? a : b;
    }

    private static int objectSize(FreeChunk object) {
        if (object.classReference == 0) {
            return object.size;
        }
        RuntimeObject realObject = (RuntimeObject)object.toAddress().toStructure();
        RuntimeClass cls = RuntimeClass.getClass(realObject);
        return GC.objectSize(realObject, cls);
    }

    private static int objectSize(RuntimeObject object, RuntimeClass cls) {
        if (cls.itemType == null) {
            return cls.size;
        }
        int itemSize = (cls.itemType.flags & 2) == 0 ? Address.sizeOf() : cls.itemType.size;
        RuntimeArray array = (RuntimeArray)object.toAddress().toStructure();
        Address address = Address.fromInt((int)Structure.sizeOf(RuntimeArray.class));
        address = Address.align((Address)address, (int)itemSize);
        address = address.add(itemSize * array.size);
        address = Address.align((Address)address, (int)Address.sizeOf());
        return address.toInt();
    }

    private static boolean isMarked(RuntimeObject object) {
        return (object.classReference & Integer.MIN_VALUE) != 0 || !isFullGC && (object.classReference & 0x40000000) != 0;
    }

    static {
        freeMemory = (int)GC.availableBytes();
        isFullGC = true;
        currentChunk = (FreeChunk)GC.heapAddress().toStructure();
        GC.currentChunk.classReference = 0;
        GC.currentChunk.size = (int)GC.availableBytes();
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        GC.currentChunkPointer.value = currentChunk;
        freeChunks = 1;
        totalChunks = 1;
        int regionCount = GC.getRegionCount();
        Allocator.fill(GC.cardTable(), (byte)1, regionCount);
    }

    static class Region
    extends Structure {
        short start;

        Region() {
        }
    }
}

