/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.teavm.common.OptionalPredicate;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;

public class Devirtualization {
    static final boolean shouldLog = System.getProperty("org.teavm.logDevirtualization", "false").equals("true");
    private DependencyInfo dependency;
    private ClassHierarchy hierarchy;
    private Set<MethodReference> virtualMethods = new HashSet<MethodReference>();
    private Set<? extends MethodReference> readonlyVirtualMethods = Collections.unmodifiableSet(this.virtualMethods);
    private int virtualCallSites;
    private int directCallSites;
    private int remainingCasts;
    private int eliminatedCasts;

    public Devirtualization(DependencyInfo dependency, ClassHierarchy hierarchy) {
        this.dependency = dependency;
        this.hierarchy = hierarchy;
    }

    public int getVirtualCallSites() {
        return this.virtualCallSites;
    }

    public int getDirectCallSites() {
        return this.directCallSites;
    }

    public int getRemainingCasts() {
        return this.remainingCasts;
    }

    public int getEliminatedCasts() {
        return this.eliminatedCasts;
    }

    public void apply(MethodHolder method) {
        MethodDependencyInfo methodDep = this.dependency.getMethod(method.getReference());
        if (methodDep == null) {
            return;
        }
        Program program = method.getProgram();
        if (shouldLog) {
            System.out.println("DEVIRTUALIZATION running at " + method.getReference());
        }
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                if (insn instanceof InvokeInstruction) {
                    this.applyToInvoke(methodDep, (InvokeInstruction)insn);
                    continue;
                }
                if (!(insn instanceof CastInstruction)) continue;
                this.applyToCast(methodDep, (CastInstruction)insn);
            }
        }
        if (shouldLog) {
            System.out.println("DEVIRTUALIZATION complete for " + method.getReference());
        }
    }

    private void applyToInvoke(MethodDependencyInfo methodDep, InvokeInstruction invoke) {
        if (invoke.getType() != InvocationType.VIRTUAL) {
            return;
        }
        ValueDependencyInfo var = methodDep.getVariable(invoke.getInstance().getIndex());
        Set<MethodReference> implementations = this.getImplementations(var.getTypes(), invoke.getMethod());
        if (implementations.size() == 1) {
            MethodReference resolvedImplementaiton = implementations.iterator().next();
            if (shouldLog) {
                System.out.print("DIRECT CALL " + invoke.getMethod() + " resolved to " + resolvedImplementaiton.getClassName());
                if (invoke.getLocation() != null) {
                    System.out.print(" at " + invoke.getLocation().getFileName() + ":" + invoke.getLocation().getLine());
                }
                System.out.println();
            }
            invoke.setType(InvocationType.SPECIAL);
            invoke.setMethod(resolvedImplementaiton);
            ++this.directCallSites;
        } else {
            this.virtualMethods.addAll(implementations);
            if (shouldLog) {
                System.out.print("VIRTUAL CALL " + invoke.getMethod() + " resolved to [");
                boolean first = true;
                for (MethodReference impl : implementations) {
                    if (!first) {
                        System.out.print(", ");
                    }
                    first = false;
                    System.out.print(impl.getClassName());
                }
                System.out.print("]");
                if (invoke.getLocation() != null) {
                    System.out.print(" at " + invoke.getLocation().getFileName() + ":" + invoke.getLocation().getLine());
                }
                System.out.println();
            }
            ++this.virtualCallSites;
        }
    }

    private void applyToCast(MethodDependencyInfo methodDep, CastInstruction cast) {
        ValueDependencyInfo var = methodDep.getVariable(cast.getValue().getIndex());
        if (var == null) {
            return;
        }
        boolean canFail = false;
        String failType = null;
        for (String type : var.getTypes()) {
            if (!this.castCanFail(type, cast.getTargetType())) continue;
            failType = type;
            canFail = true;
        }
        if (canFail) {
            if (shouldLog) {
                System.out.print("REMAINING CAST to " + cast.getTargetType() + " (example is " + failType + ")");
                if (cast.getLocation() != null) {
                    System.out.print(" at " + cast.getLocation().getFileName() + ":" + cast.getLocation().getLine());
                }
                System.out.println();
            }
            ++this.remainingCasts;
        } else {
            if (shouldLog) {
                System.out.print("ELIMINATED CAST to " + cast.getTargetType());
                if (cast.getLocation() != null) {
                    System.out.print(" at " + cast.getLocation().getFileName() + ":" + cast.getLocation().getLine());
                }
                System.out.println();
            }
            AssignInstruction assign = new AssignInstruction();
            assign.setAssignee(cast.getValue());
            assign.setReceiver(cast.getReceiver());
            assign.setLocation(cast.getLocation());
            cast.replace(assign);
            ++this.eliminatedCasts;
        }
    }

    private boolean castCanFail(String type, ValueType target) {
        String targetClassName;
        ValueType valueType;
        return !(type.startsWith("[") ? this.hierarchy.isSuperType(target, valueType = ValueType.parse(type), false) : target instanceof ValueType.Object && this.hierarchy.isSuperType(targetClassName = ((ValueType.Object)target).getClassName(), type, false));
    }

    private Set<MethodReference> getImplementations(String[] classNames, MethodReference ref) {
        return Devirtualization.implementations(this.hierarchy, this.dependency, classNames, ref);
    }

    public static Set<MethodReference> implementations(ClassHierarchy hierarchy, DependencyInfo dependency, String[] classNames, MethodReference ref) {
        OptionalPredicate<String> isSuperclass = hierarchy.getSuperclassPredicate(ref.getClassName());
        LinkedHashSet<MethodReference> methods = new LinkedHashSet<MethodReference>();
        for (String className : classNames) {
            MethodDependencyInfo methodDep;
            ClassReader cls;
            if (className.startsWith("[")) {
                className = "java.lang.Object";
            }
            if ((cls = hierarchy.getClassSource().get(className)) == null || !isSuperclass.test(cls.getName(), false) || (methodDep = dependency.getMethodImplementation(new MethodReference(className, ref.getDescriptor()))) == null) continue;
            methods.add(methodDep.getReference());
        }
        return methods;
    }

    public Set<? extends MethodReference> getVirtualMethods() {
        return this.readonlyVirtualMethods;
    }
}

