/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;

class TemporaryVariablePool {
    private WasmFunction function;
    private List<Deque<WasmLocal>> temporaryVariablesByType = new ArrayList<Deque<WasmLocal>>();

    TemporaryVariablePool(WasmFunction function) {
        this.function = function;
        int typeCount = WasmType.values().length;
        for (int i = 0; i < typeCount; ++i) {
            this.temporaryVariablesByType.add(new ArrayDeque());
        }
    }

    WasmLocal acquire(WasmType type) {
        Deque<WasmLocal> stack = this.temporaryVariablesByType.get(type.ordinal());
        WasmLocal variable = stack.pollFirst();
        if (variable == null) {
            variable = new WasmLocal(type);
            this.function.add(variable);
        }
        return variable;
    }

    void release(WasmLocal variable) {
        Deque<WasmLocal> stack = this.temporaryVariablesByType.get(variable.getType().ordinal());
        stack.push(variable);
    }
}

