/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.disasm;

import java.io.PrintWriter;

public class DisassemblyWriter {
    private PrintWriter out;
    private boolean withAddress;
    private int indentLevel;
    private int address;
    private boolean hasAddress;
    private boolean lineStarted;

    public DisassemblyWriter(PrintWriter out, boolean withAddress) {
        this.out = out;
        this.withAddress = withAddress;
    }

    public DisassemblyWriter address(int address) {
        this.address = address;
        this.hasAddress = true;
        return this;
    }

    public DisassemblyWriter indent() {
        ++this.indentLevel;
        return this;
    }

    public DisassemblyWriter outdent() {
        --this.indentLevel;
        return this;
    }

    public DisassemblyWriter eol() {
        this.out.println();
        this.lineStarted = false;
        return this;
    }

    private void startLine() {
        if (!this.lineStarted) {
            this.lineStarted = true;
            if (this.withAddress) {
                if (this.hasAddress) {
                    this.hasAddress = false;
                    this.printAddress();
                } else {
                    this.out.print("                ");
                }
            }
            for (int i = 0; i < this.indentLevel; ++i) {
                this.out.print("  ");
            }
        }
    }

    private void printAddress() {
        this.out.print("(; ");
        for (int i = 7; i >= 0; --i) {
            int digit = this.address >>> i * 4 & 0xF;
            this.out.print(Character.forDigit(digit, 16));
        }
        this.out.print(" ;)  ");
    }

    public DisassemblyWriter write(String s) {
        this.startLine();
        this.out.print(s);
        return this;
    }
}

