/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.c.util.BufferedFile;
import org.teavm.common.json.JsonAllErrorVisitor;
import org.teavm.common.json.JsonArrayVisitor;
import org.teavm.common.json.JsonErrorReporter;
import org.teavm.common.json.JsonObjectVisitor;
import org.teavm.common.json.JsonParser;
import org.teavm.common.json.JsonPropertyVisitor;
import org.teavm.common.json.JsonVisitingConsumer;
import org.teavm.common.json.JsonVisitor;
import org.teavm.hppc.LongArrayList;
import org.teavm.hppc.LongObjectHashMap;
import org.teavm.hppc.LongObjectMap;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;

public final class HeapDumpConverter {
    private static byte[] buffer = new byte[8];
    private static int idSize;
    private static JsonVisitor pointerSizeVisitor;

    private HeapDumpConverter() {
    }

    public static void main(String[] args) throws IOException {
        SymbolTable symbolTable;
        if (args.length != 2) {
            System.err.println("Converts TeaVM/C heap dump into HotSpot compatible format (hprof)");
            System.err.println("Two arguments expected: input file (JSON), output file (hprof)");
            System.exit(-1);
        }
        try (Reader reader = HeapDumpConverter.createReader(args[0]);){
            symbolTable = HeapDumpConverter.fillSymbolTable(reader);
        }
        reader = HeapDumpConverter.createReader(args[0]);
        try (RandomAccessFile output = new RandomAccessFile(args[1], "rw");){
            HeapDumpConverter.generateHprofFile(reader, output, symbolTable);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static Reader createReader(String fileName) throws IOException {
        return new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(fileName)), StandardCharsets.UTF_8);
    }

    private static SymbolTable fillSymbolTable(Reader reader) throws IOException {
        SymbolTable symbolTable = new SymbolTable();
        JsonPropertyVisitor rootObjectVisitor = new JsonPropertyVisitor(true);
        rootObjectVisitor.addProperty("pointerSize", pointerSizeVisitor);
        rootObjectVisitor.addProperty("classes", new JsonArrayVisitor(new SymbolTableClassVisitor(symbolTable)));
        rootObjectVisitor.addProperty("stack", new JsonArrayVisitor(new SymbolTableStackVisitor(symbolTable)));
        JsonParser parser = new JsonParser(new JsonVisitingConsumer(new JsonObjectVisitor(rootObjectVisitor)));
        parser.parse(reader);
        if (symbolTable.classLoaderClassId == 0L) {
            HeapDumpConverter.addFakeClass(1L, symbolTable, "java.lang.ClassLoader", symbolTable.objectClassId);
        }
        if (symbolTable.referenceClassId == 0L) {
            HeapDumpConverter.addFakeClass(2L, symbolTable, "java.lang.ref.Reference", symbolTable.objectClassId);
            symbolTable.referenceClassId = 2L;
        }
        if (symbolTable.weakReferenceClassId == 0L) {
            HeapDumpConverter.addFakeClass(3L, symbolTable, "java.lang.ref.WeakReference", symbolTable.referenceClassId);
        }
        if (symbolTable.softReferenceClassId == 0L) {
            HeapDumpConverter.addFakeClass(4L, symbolTable, "java.lang.ref.SoftReference", symbolTable.referenceClassId);
        }
        if (symbolTable.phantomReferenceClassId == 0L) {
            HeapDumpConverter.addFakeClass(5L, symbolTable, "java.lang.ref.PhantomReference", symbolTable.referenceClassId);
        }
        if (symbolTable.finalReferenceClassId == 0L) {
            HeapDumpConverter.addFakeClass(6L, symbolTable, "java.lang.ref.FinalReference", symbolTable.referenceClassId);
        }
        HeapDumpConverter.fixClassNames(symbolTable);
        return symbolTable;
    }

    private static void addFakeClass(long id, SymbolTable symbolTable, String name, long parent) {
        ClassDescriptor cls = new ClassDescriptor();
        cls.id = id;
        cls.superClassId = parent;
        cls.name = name;
        symbolTable.classesById.put(cls.id, (Object)cls);
        symbolTable.classList.add(cls);
    }

    private static void fixClassNames(SymbolTable symbolTable) {
        int serialIdGen = 1;
        int anonymousIdGen = 0;
        for (ClassDescriptor descriptor : symbolTable.classList) {
            if (descriptor.primitiveType != null) continue;
            descriptor.serialId = serialIdGen++;
            if (descriptor.itemClassId != 0L) continue;
            if (descriptor.name == null) {
                do {
                    descriptor.name = "anonymous_" + anonymousIdGen++;
                } while (symbolTable.getClass(descriptor.name) != null);
                continue;
            }
            descriptor.name = descriptor.name.replace('.', '/');
        }
        ArrayList<ClassDescriptor> arrayClasses = new ArrayList<ClassDescriptor>();
        for (ClassDescriptor descriptor : symbolTable.classList) {
            if (descriptor.itemClassId == 0L || descriptor.name != null) continue;
            while (descriptor.itemClassId != 0L) {
                arrayClasses.add(descriptor);
                descriptor = (ClassDescriptor)symbolTable.classesById.get(descriptor.itemClassId);
                if (descriptor.name == null) continue;
            }
            Object name = descriptor.name;
            if (descriptor.primitiveType != null) {
                switch (descriptor.primitiveType) {
                    case BOOLEAN: {
                        name = "Z";
                        break;
                    }
                    case BYTE: {
                        name = "B";
                        break;
                    }
                    case SHORT: {
                        name = "S";
                        break;
                    }
                    case CHAR: {
                        name = "C";
                        break;
                    }
                    case INT: {
                        name = "I";
                        break;
                    }
                    case LONG: {
                        name = "J";
                        break;
                    }
                    case FLOAT: {
                        name = "F";
                        break;
                    }
                    case DOUBLE: {
                        name = "D";
                        break;
                    }
                    case OBJECT: 
                    case ARRAY: {
                        assert (false);
                        break;
                    }
                }
            } else if (descriptor.itemClassId == 0L) {
                name = "L" + (String)name + ";";
            }
            for (int i = arrayClasses.size() - 1; i >= 0; --i) {
                ((ClassDescriptor)arrayClasses.get((int)i)).name = name = "[" + (String)name;
            }
            arrayClasses.clear();
        }
        for (ClassDescriptor descriptor : symbolTable.classList) {
            if (descriptor.name == null) continue;
            symbolTable.lookup(descriptor.name);
            symbolTable.classes.put(descriptor.name, descriptor);
        }
    }

    private static void generateHprofFile(Reader reader, RandomAccessFile output, SymbolTable symbolTable) throws IOException {
        output.write("JAVA PROFILE 1.0.2\u0000".getBytes(StandardCharsets.UTF_8));
        output.writeInt(idSize);
        output.writeLong(System.currentTimeMillis());
        BufferedFile bufferedOutput = new BufferedFile(output);
        HeapDumpConverter.writeSymbols(bufferedOutput, symbolTable);
        HeapDumpConverter.writeStack(bufferedOutput, symbolTable);
        HeapDumpConverter.writeHeapDump(reader, bufferedOutput, symbolTable);
        bufferedOutput.flush();
        output.write(44);
        output.writeInt(0);
        output.writeInt(0);
        output.setLength(output.getFilePointer());
    }

    private static void writeSymbols(BufferedFile output, SymbolTable symbolTable) throws IOException {
        List<String> strings = symbolTable.getStrings();
        for (int i = 0; i < strings.size(); ++i) {
            byte[] bytes = strings.get(i).getBytes(StandardCharsets.UTF_8);
            output.write(1);
            output.writeInt(0);
            output.writeInt(idSize + bytes.length);
            HeapDumpConverter.writeId(output, i + 1);
            output.write(bytes);
        }
    }

    private static void writeStack(BufferedFile output, SymbolTable symbolTable) throws IOException {
        int i;
        for (i = 0; i < symbolTable.stack.size(); ++i) {
            ClassDescriptor cls;
            Frame frame = symbolTable.stack.get(i);
            output.write(4);
            output.writeInt(0);
            output.writeInt(4 * idSize + 8);
            HeapDumpConverter.writeId(output, i + 1);
            HeapDumpConverter.writeId(output, frame.methodName != null ? (long)symbolTable.lookup(frame.methodName) : 0L);
            HeapDumpConverter.writeId(output, 0L);
            HeapDumpConverter.writeId(output, frame.fileName != null ? (long)symbolTable.lookup(frame.fileName) : 0L);
            int classSerialId = 0;
            if (frame.className != null && (cls = symbolTable.getClass(frame.className)) != null) {
                classSerialId = cls.serialId;
            }
            output.writeInt(classSerialId);
            output.writeInt(frame.lineNumber);
        }
        output.write(5);
        output.writeInt(0);
        output.writeInt(12 + idSize * symbolTable.stack.size());
        output.writeInt(1);
        output.writeInt(0);
        output.writeInt(symbolTable.stack.size());
        for (i = 0; i < symbolTable.stack.size(); ++i) {
            HeapDumpConverter.writeId(output, i + 1);
        }
    }

    private static void writeGcRoots(BufferedFile output, SymbolTable symbolTable) throws IOException {
        List<Frame> stack = symbolTable.stack;
        for (int i = 0; i < stack.size(); ++i) {
            Frame frame = stack.get(i);
            if (frame.roots == null) continue;
            for (long rootId : frame.roots) {
                output.write(3);
                HeapDumpConverter.writeId(output, rootId);
                output.writeInt(0);
                output.writeInt(i);
            }
        }
        for (ClassDescriptor classDescriptor : symbolTable.getClasses()) {
            if (classDescriptor.primitiveType != null) continue;
            output.write(5);
            HeapDumpConverter.writeId(output, classDescriptor.id);
        }
    }

    private static void writeHeapDump(Reader reader, BufferedFile output, SymbolTable symbolTable) throws IOException {
        for (ClassDescriptor classDescriptor : symbolTable.getClasses()) {
            if (classDescriptor.primitiveType != null) continue;
            output.write(2);
            output.writeInt(0);
            output.writeInt(8 + 2 * idSize);
            output.writeInt(classDescriptor.serialId);
            HeapDumpConverter.writeId(output, classDescriptor.id);
            output.writeInt(1);
            HeapDumpConverter.writeId(output, symbolTable.lookup(classDescriptor.name));
        }
        output.write(12);
        output.writeInt(0);
        output.writeInt(0);
        long mark = output.getFilePointer();
        HeapDumpConverter.writeGcRoots(output, symbolTable);
        HeapDumpConverter.writeClassObjects(output, symbolTable);
        JsonPropertyVisitor rootPropertyVisitor = new JsonPropertyVisitor(true);
        rootPropertyVisitor.addProperty("objects", new JsonArrayVisitor(new ObjectDumpVisitor(output, symbolTable)));
        JsonParser parser = new JsonParser(new JsonVisitingConsumer(new JsonObjectVisitor(rootPropertyVisitor)));
        parser.parse(reader);
        long pointerBackup = output.getFilePointer();
        int size = (int)(output.getFilePointer() - mark);
        output.seek(mark - 4L);
        output.writeInt(size);
        output.seek(pointerBackup);
    }

    private static void writeClassObjects(BufferedFile output, SymbolTable symbolTable) throws IOException {
        Collection<ClassDescriptor> classes = symbolTable.getClasses();
        for (ClassDescriptor cls : classes) {
            if (cls.primitiveType != null) continue;
            HeapDumpConverter.writeClassDump(output, symbolTable, cls);
        }
    }

    private static void writeClassDump(BufferedFile output, SymbolTable symbolTable, ClassDescriptor cls) throws IOException {
        output.write(32);
        HeapDumpConverter.writeId(output, cls.id);
        output.writeInt(1);
        long superClassId = cls.superClassId;
        if (cls.itemClassId != 0L) {
            superClassId = symbolTable.objectClassId;
        }
        HeapDumpConverter.writeId(output, superClassId);
        HeapDumpConverter.writeId(output, 0L);
        HeapDumpConverter.writeId(output, 0L);
        HeapDumpConverter.writeId(output, 0L);
        HeapDumpConverter.writeId(output, 0L);
        HeapDumpConverter.writeId(output, 0L);
        output.writeInt(cls.size);
        output.writeShort(0);
        output.writeShort((short)cls.staticFields.size());
        int dataPtr = 0;
        for (FieldDescriptor field : cls.staticFields) {
            HeapDumpConverter.writeId(output, symbolTable.lookup(field.name));
            output.write(HeapDumpConverter.typeToInt(field.type));
            int sz = HeapDumpConverter.typeSize(field.type);
            output.write(cls.data, dataPtr, sz);
            dataPtr += sz;
        }
        output.writeShort((short)cls.fields.size());
        for (FieldDescriptor field : cls.fields) {
            HeapDumpConverter.writeId(output, symbolTable.lookup(field.name));
            output.write(HeapDumpConverter.typeToInt(field.type));
        }
    }

    private static Type parseType(JsonErrorReporter errorReporter, String type) {
        switch (type) {
            case "object": {
                return Type.OBJECT;
            }
            case "array": {
                return Type.ARRAY;
            }
            case "boolean": {
                return Type.BOOLEAN;
            }
            case "byte": {
                return Type.BYTE;
            }
            case "char": {
                return Type.CHAR;
            }
            case "short": {
                return Type.SHORT;
            }
            case "int": {
                return Type.INT;
            }
            case "long": {
                return Type.LONG;
            }
            case "float": {
                return Type.FLOAT;
            }
            case "double": {
                return Type.DOUBLE;
            }
        }
        errorReporter.error("Unknown type: " + type);
        return Type.OBJECT;
    }

    private static int typeToInt(Type type) {
        switch (type) {
            case OBJECT: 
            case ARRAY: {
                return 2;
            }
            case BOOLEAN: {
                return 4;
            }
            case CHAR: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BYTE: {
                return 8;
            }
            case SHORT: {
                return 9;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
        }
        return 0;
    }

    private static int typeSize(Type type) {
        switch (type) {
            case OBJECT: 
            case ARRAY: {
                return idSize;
            }
            case BOOLEAN: 
            case BYTE: {
                return 1;
            }
            case SHORT: 
            case CHAR: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
            case LONG: 
            case DOUBLE: {
                return 8;
            }
        }
        return 0;
    }

    private static void writeId(BufferedFile out, long id) throws IOException {
        HeapDumpConverter.writeLongBytes(out, id, idSize);
    }

    private static void writeLongBytes(BufferedFile out, long v, int size) throws IOException {
        for (int i = size - 1; i >= 0; --i) {
            HeapDumpConverter.buffer[i] = (byte)(v & 0xFFL);
            v >>>= 8;
        }
        out.write(buffer, 0, size);
    }

    static byte[] parseData(JsonErrorReporter errorReporter, String data) {
        if (data.length() % 2 != 0) {
            errorReporter.error("Invalid hex sequence");
            return new byte[0];
        }
        byte[] bytes = new byte[data.length() / 2];
        int j = 0;
        for (int i = 0; i < data.length(); i += 2) {
            int b = HeapDumpConverter.hexDigit(errorReporter, data.charAt(i)) << 4 | HeapDumpConverter.hexDigit(errorReporter, data.charAt(i + 1));
            bytes[j++] = (byte)b;
        }
        return bytes;
    }

    private static int hexDigit(JsonErrorReporter errorReporter, char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        errorReporter.error("Invalid hex sequence");
        return -1;
    }

    static {
        pointerSizeVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                idSize = (int)value;
            }
        };
    }

    static class SymbolTable {
        private List<String> strings = new ArrayList<String>();
        private ObjectIntMap<String> stringIndexes = new ObjectIntHashMap();
        List<ClassDescriptor> classList = new ArrayList<ClassDescriptor>();
        Map<String, ClassDescriptor> classes = new LinkedHashMap<String, ClassDescriptor>();
        LongObjectMap<ClassDescriptor> classesById = new LongObjectHashMap();
        List<Frame> stack = new ArrayList<Frame>();
        long objectClassId;
        long classLoaderClassId;
        long referenceClassId;
        long weakReferenceClassId;
        long softReferenceClassId;
        long finalReferenceClassId;
        long phantomReferenceClassId;

        SymbolTable() {
        }

        List<String> getStrings() {
            return this.strings;
        }

        ClassDescriptor getClass(String name) {
            return this.classes.get(name);
        }

        ClassDescriptor getClassById(long id) {
            return (ClassDescriptor)this.classesById.get(id);
        }

        Collection<ClassDescriptor> getClasses() {
            return this.classList;
        }

        int lookup(String str) {
            int value = this.stringIndexes.getOrDefault((Object)str, -1);
            if (value < 0) {
                value = this.strings.size() + 1;
                this.strings.add(str);
                this.stringIndexes.put((Object)str, value);
            }
            return value;
        }
    }

    static class SymbolTableClassVisitor
    extends JsonAllErrorVisitor {
        SymbolTable symbolTable;
        ClassDescriptor descriptor;
        FieldDescriptor fieldDescriptor;
        private JsonPropertyVisitor propertyVisitor;
        private List<FieldDescriptor> fields;
        JsonVisitor idVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                descriptor.id = value;
            }
        };
        JsonVisitor nameVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                descriptor.name = value;
            }
        };
        JsonVisitor superVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                descriptor.superClassId = value;
            }

            @Override
            public void nullValue(JsonErrorReporter reporter) {
            }
        };
        JsonVisitor sizeVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                descriptor.size = (int)value;
            }
        };
        JsonVisitor primitiveVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                descriptor.primitiveType = HeapDumpConverter.parseType(reporter, value);
            }
        };
        JsonVisitor itemVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                descriptor.itemClassId = value;
            }
        };
        JsonVisitor fieldsVisitor = new JsonAllErrorVisitor(){

            @Override
            public JsonVisitor array(JsonErrorReporter reporter) {
                fields = descriptor.fields;
                return fieldVisitor;
            }
        };
        JsonVisitor staticFieldsVisitor = new JsonAllErrorVisitor(){

            @Override
            public JsonVisitor array(JsonErrorReporter reporter) {
                fields = descriptor.staticFields;
                return fieldVisitor;
            }
        };
        JsonVisitor fieldNameVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                fieldDescriptor.name = value;
                symbolTable.lookup(value);
            }
        };
        JsonVisitor fieldTypeVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                fieldDescriptor.type = HeapDumpConverter.parseType(reporter, value);
            }
        };
        JsonVisitor fieldVisitor = new JsonAllErrorVisitor(){
            private JsonPropertyVisitor propertyVisitor = new JsonPropertyVisitor(true);
            {
                this.propertyVisitor.addProperty("name", fieldNameVisitor);
                this.propertyVisitor.addProperty("type", fieldTypeVisitor);
            }

            @Override
            public JsonVisitor object(JsonErrorReporter reporter) {
                fieldDescriptor = new FieldDescriptor();
                return this.propertyVisitor;
            }

            @Override
            public void end(JsonErrorReporter reporter) {
                if (fieldDescriptor.type == null) {
                    reporter.error("Type for this field not specified");
                }
                fields.add(fieldDescriptor);
                fieldDescriptor = null;
            }
        };
        JsonVisitor dataVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                descriptor.data = HeapDumpConverter.parseData(reporter, value);
            }
        };

        SymbolTableClassVisitor(SymbolTable symbolTable) {
            this.symbolTable = symbolTable;
            this.propertyVisitor = new JsonPropertyVisitor(true);
            this.propertyVisitor.addProperty("id", this.idVisitor);
            this.propertyVisitor.addProperty("name", this.nameVisitor);
            this.propertyVisitor.addProperty("super", this.superVisitor);
            this.propertyVisitor.addProperty("size", this.sizeVisitor);
            this.propertyVisitor.addProperty("primitive", this.primitiveVisitor);
            this.propertyVisitor.addProperty("item", this.itemVisitor);
            this.propertyVisitor.addProperty("fields", this.fieldsVisitor);
            this.propertyVisitor.addProperty("staticFields", this.staticFieldsVisitor);
            this.propertyVisitor.addProperty("data", this.dataVisitor);
        }

        @Override
        public JsonVisitor object(JsonErrorReporter reporter) {
            this.descriptor = new ClassDescriptor();
            return this.propertyVisitor;
        }

        @Override
        public void end(JsonErrorReporter reporter) {
            if (this.descriptor.id == 0L) {
                reporter.error("Required property 'id' was not set");
            }
            this.symbolTable.classList.add(this.descriptor);
            if (this.symbolTable.classesById.put(this.descriptor.id, (Object)this.descriptor) != null) {
                reporter.error("Duplicate class id: " + this.descriptor.id);
            }
            if (this.descriptor.name != null) {
                switch (this.descriptor.name) {
                    case "java.lang.Object": {
                        this.symbolTable.objectClassId = this.descriptor.id;
                        break;
                    }
                    case "java.lang.ClassLoader": {
                        this.symbolTable.classLoaderClassId = this.descriptor.id;
                        break;
                    }
                    case "java.lang.ref.Reference": {
                        this.symbolTable.referenceClassId = this.descriptor.id;
                        break;
                    }
                    case "java.lang.ref.WeakReference": {
                        this.symbolTable.weakReferenceClassId = this.descriptor.id;
                        break;
                    }
                    case "java.lang.ref.SoftReference": {
                        this.symbolTable.softReferenceClassId = this.descriptor.id;
                        break;
                    }
                    case "java.lang.ref.PhantomReference": {
                        this.symbolTable.phantomReferenceClassId = this.descriptor.id;
                        break;
                    }
                    case "java.lang.ref.FinalReference": {
                        this.symbolTable.finalReferenceClassId = this.descriptor.id;
                    }
                }
            }
        }
    }

    static class SymbolTableStackVisitor
    extends JsonAllErrorVisitor {
        SymbolTable symbolTable;
        private JsonPropertyVisitor propertyVisitor = new JsonPropertyVisitor(true);
        private Frame frame;
        private LongArrayList roots = new LongArrayList();
        JsonVisitor fileVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                symbolTable.lookup(value);
                frame.fileName = value;
            }
        };
        JsonVisitor classVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                symbolTable.lookup(value);
                frame.className = value;
            }
        };
        JsonVisitor methodVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                symbolTable.lookup(value);
                frame.methodName = value;
            }
        };
        JsonVisitor lineVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                frame.lineNumber = (int)value;
            }
        };
        JsonVisitor rootsVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                roots.add(value);
            }
        };

        SymbolTableStackVisitor(SymbolTable symbolTable) {
            this.symbolTable = symbolTable;
            this.propertyVisitor.addProperty("file", this.fileVisitor);
            this.propertyVisitor.addProperty("class", this.classVisitor);
            this.propertyVisitor.addProperty("method", this.methodVisitor);
            this.propertyVisitor.addProperty("line", this.lineVisitor);
            this.propertyVisitor.addProperty("roots", new JsonArrayVisitor(this.rootsVisitor));
        }

        @Override
        public JsonVisitor object(JsonErrorReporter reporter) {
            this.frame = new Frame();
            return this.propertyVisitor;
        }

        @Override
        public void end(JsonErrorReporter reporter) {
            if (!this.roots.isEmpty()) {
                this.frame.roots = this.roots.toArray();
                this.roots.clear();
            }
            this.symbolTable.stack.add(this.frame);
        }
    }

    static class ClassDescriptor {
        long id;
        String name;
        int serialId;
        Type primitiveType;
        long itemClassId;
        long superClassId;
        int size;
        List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        List<FieldDescriptor> staticFields = new ArrayList<FieldDescriptor>();
        byte[] data;

        ClassDescriptor() {
        }
    }

    static enum Type {
        OBJECT,
        ARRAY,
        BOOLEAN,
        BYTE,
        CHAR,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }

    static class Frame {
        String className;
        String methodName;
        String fileName;
        int lineNumber = -1;
        long[] roots;

        Frame() {
        }
    }

    static class ObjectDumpVisitor
    extends JsonAllErrorVisitor {
        private BufferedFile output;
        private SymbolTable symbolTable;
        private JsonPropertyVisitor propertyVisitor = new JsonPropertyVisitor(true);
        private long id;
        private long classId;
        private byte[] data;
        private JsonVisitor idVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                id = value;
            }
        };
        private JsonVisitor classVisitor = new JsonAllErrorVisitor(){

            @Override
            public void intValue(JsonErrorReporter reporter, long value) {
                classId = value;
            }
        };
        private JsonVisitor dataVisitor = new JsonAllErrorVisitor(){

            @Override
            public void stringValue(JsonErrorReporter reporter, String value) {
                data = HeapDumpConverter.parseData(reporter, value);
            }
        };

        ObjectDumpVisitor(BufferedFile output, SymbolTable symbolTable) {
            this.output = output;
            this.symbolTable = symbolTable;
            this.propertyVisitor.addProperty("id", this.idVisitor);
            this.propertyVisitor.addProperty("class", this.classVisitor);
            this.propertyVisitor.addProperty("data", this.dataVisitor);
        }

        @Override
        public JsonVisitor object(JsonErrorReporter reporter) {
            this.id = 0L;
            this.classId = 0L;
            this.data = null;
            return this.propertyVisitor;
        }

        @Override
        public void end(JsonErrorReporter reporter) {
            try {
                ClassDescriptor cls = this.symbolTable.getClassById(this.classId);
                if (cls == null) {
                    reporter.error("Unknown class: " + this.classId);
                }
                if (cls.itemClassId == 0L) {
                    this.output.write(33);
                    HeapDumpConverter.writeId(this.output, this.id);
                    this.output.writeInt(1);
                    HeapDumpConverter.writeId(this.output, this.classId);
                    this.output.writeInt(this.data.length);
                    int dataPtr = this.data.length;
                    while (cls != null) {
                        for (FieldDescriptor fieldDescriptor : cls.fields) {
                            dataPtr -= HeapDumpConverter.typeSize(fieldDescriptor.type);
                        }
                        int ptr = dataPtr;
                        for (FieldDescriptor field : cls.fields) {
                            int size = HeapDumpConverter.typeSize(field.type);
                            this.output.write(this.data, ptr, size);
                            ptr += size;
                        }
                        cls = cls.superClassId != 0L ? this.symbolTable.getClassById(cls.superClassId) : null;
                    }
                } else {
                    ClassDescriptor itemCls = this.symbolTable.getClassById(cls.itemClassId);
                    this.output.write(itemCls.primitiveType == null ? 34 : 35);
                    HeapDumpConverter.writeId(this.output, this.id);
                    this.output.writeInt(1);
                    int itemSize = itemCls.primitiveType != null ? HeapDumpConverter.typeSize(itemCls.primitiveType) : idSize;
                    int n = this.data.length / itemSize;
                    this.output.writeInt(n);
                    if (itemCls.primitiveType == null) {
                        HeapDumpConverter.writeId(this.output, this.classId);
                    } else {
                        this.output.write(HeapDumpConverter.typeToInt(itemCls.primitiveType));
                    }
                    for (int i = 0; i < n; ++i) {
                        int ptr = i * itemSize;
                        this.output.write(this.data, ptr, itemSize);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class FieldDescriptor {
        String name;
        Type type;

        FieldDescriptor() {
        }
    }
}

