/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.teavm.codegen.AliasProvider;
import org.teavm.codegen.DefaultAliasProvider;
import org.teavm.codegen.DefaultNamingStrategy;
import org.teavm.codegen.MinifyingAliasProvider;
import org.teavm.codegen.SourceWriter;
import org.teavm.codegen.SourceWriterBuilder;
import org.teavm.common.FiniteExecutor;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.Linker;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.Decompiler;
import org.teavm.javascript.Renderer;
import org.teavm.javascript.RenderingException;
import org.teavm.javascript.ast.ClassNode;
import org.teavm.javascript.ni.Generator;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ElementHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.util.ListingBuilder;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.RegisterAllocator;
import org.teavm.optimization.ClassSetOptimizer;
import org.teavm.optimization.Devirtualization;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.JavascriptProcessedClassSource;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.spi.RendererListener;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

public class TeaVM
implements TeaVMHost {
    private JavascriptProcessedClassSource classSource;
    private DependencyChecker dependencyChecker;
    private FiniteExecutor executor;
    private ClassLoader classLoader;
    private boolean minifying = true;
    private boolean bytecodeLogging;
    private OutputStream logStream = System.out;
    private Map<String, TeaVMEntryPoint> entryPoints = new HashMap<String, TeaVMEntryPoint>();
    private Map<String, String> exportedClasses = new HashMap<String, String>();
    private Map<MethodReference, Generator> methodGenerators = new HashMap<MethodReference, Generator>();
    private List<RendererListener> rendererListeners = new ArrayList<RendererListener>();
    private Properties properties = new Properties();

    TeaVM(ClassHolderSource classSource, ClassLoader classLoader, FiniteExecutor executor) {
        this.classSource = new JavascriptProcessedClassSource(classSource);
        this.classLoader = classLoader;
        this.dependencyChecker = new DependencyChecker(this.classSource, classLoader, executor);
        this.executor = executor;
    }

    @Override
    public void add(DependencyListener listener) {
        this.dependencyChecker.addDependencyListener(listener);
    }

    @Override
    public void add(ClassHolderTransformer transformer) {
        this.classSource.addTransformer(transformer);
    }

    @Override
    public void add(MethodReference methodRef, Generator generator) {
        this.methodGenerators.put(methodRef, generator);
    }

    @Override
    public void add(RendererListener listener) {
        this.rendererListeners.add(listener);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public boolean isBytecodeLogging() {
        return this.bytecodeLogging;
    }

    public void setBytecodeLogging(boolean bytecodeLogging) {
        this.bytecodeLogging = bytecodeLogging;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public TeaVMEntryPoint entryPoint(String name, MethodReference ref) {
        if (this.entryPoints.containsKey(name)) {
            throw new IllegalArgumentException("Entry point with public name `" + name + "' already defined " + "for method " + ref);
        }
        TeaVMEntryPoint entryPoint = new TeaVMEntryPoint(name, ref, this.dependencyChecker.linkMethod(ref, DependencyStack.ROOT));
        this.dependencyChecker.initClass(ref.getClassName(), DependencyStack.ROOT);
        this.entryPoints.put(name, entryPoint);
        return entryPoint;
    }

    public TeaVMEntryPoint linkMethod(MethodReference ref) {
        TeaVMEntryPoint entryPoint = new TeaVMEntryPoint("", ref, this.dependencyChecker.linkMethod(ref, DependencyStack.ROOT));
        this.dependencyChecker.initClass(ref.getClassName(), DependencyStack.ROOT);
        return entryPoint;
    }

    public void exportType(String name, String className) {
        if (this.exportedClasses.containsKey(name)) {
            throw new IllegalArgumentException("Class with public name `" + name + "' already defined for class " + className);
        }
        this.dependencyChecker.initClass(className, DependencyStack.ROOT);
        this.exportedClasses.put(name, className);
    }

    public void linkType(String className) {
        this.dependencyChecker.initClass(className, DependencyStack.ROOT);
    }

    public ClassHolderSource getClassSource() {
        return this.classSource;
    }

    public boolean hasMissingItems() {
        return this.dependencyChecker.hasMissingItems();
    }

    public void showMissingItems(Appendable target) throws IOException {
        this.dependencyChecker.showMissingItems(target);
    }

    public void checkForMissingItems() {
        this.dependencyChecker.checkForMissingItems();
    }

    public void build(Appendable writer, BuildTarget target) throws RenderingException {
        AliasProvider aliasProvider = this.minifying ? new MinifyingAliasProvider() : new DefaultAliasProvider();
        DefaultNamingStrategy naming = new DefaultNamingStrategy(aliasProvider, this.classSource);
        naming.setMinifying(this.minifying);
        SourceWriterBuilder builder = new SourceWriterBuilder(naming);
        builder.setMinified(this.minifying);
        SourceWriter sourceWriter = builder.build(writer);
        this.dependencyChecker.linkMethod(new MethodReference("java.lang.Class", "createNew", ValueType.object("java.lang.Class")), DependencyStack.ROOT).use();
        this.dependencyChecker.linkMethod(new MethodReference("java.lang.String", "<init>", ValueType.arrayOf(ValueType.CHARACTER), ValueType.VOID), DependencyStack.ROOT).use();
        this.dependencyChecker.linkMethod(new MethodReference("java.lang.String", "getChars", ValueType.INTEGER, ValueType.INTEGER, ValueType.arrayOf(ValueType.CHARACTER), ValueType.INTEGER, ValueType.VOID), DependencyStack.ROOT).use();
        MethodDependency internDep = this.dependencyChecker.linkMethod(new MethodReference("java.lang.String", "intern", ValueType.object("java.lang.String")), DependencyStack.ROOT);
        internDep.getVariable(0).propagate("java.lang.String");
        internDep.use();
        this.dependencyChecker.linkMethod(new MethodReference("java.lang.String", "length", ValueType.INTEGER), DependencyStack.ROOT).use();
        this.dependencyChecker.linkMethod(new MethodReference("java.lang.Object", new MethodDescriptor("clone", ValueType.object("java.lang.Object"))), DependencyStack.ROOT).use();
        this.executor.complete();
        if (this.hasMissingItems()) {
            return;
        }
        Linker linker = new Linker(this.dependencyChecker);
        ListableClassHolderSource classSet = linker.link(this.classSource);
        Decompiler decompiler = new Decompiler(classSet, this.classLoader, this.executor);
        this.devirtualize(classSet, this.dependencyChecker);
        this.executor.complete();
        ClassSetOptimizer optimizer = new ClassSetOptimizer(this.executor);
        optimizer.optimizeAll(classSet);
        this.executor.complete();
        this.allocateRegisters(classSet);
        this.executor.complete();
        if (this.bytecodeLogging) {
            try {
                this.logBytecode(new PrintWriter(new OutputStreamWriter(this.logStream, "UTF-8")), classSet);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        for (Map.Entry<MethodReference, Generator> entry : this.methodGenerators.entrySet()) {
            decompiler.addGenerator(entry.getKey(), entry.getValue());
        }
        List<ClassNode> clsNodes = decompiler.decompile(classSet.getClassNames());
        Renderer renderer = new Renderer(sourceWriter, classSet, this.classLoader);
        try {
            for (RendererListener rendererListener : this.rendererListeners) {
                rendererListener.begin(renderer, target);
            }
            renderer.renderRuntime();
            for (ClassNode classNode : clsNodes) {
                ClassHolder cls = classSet.get(classNode.getName());
                for (RendererListener listener : this.rendererListeners) {
                    listener.beforeClass(cls);
                }
                renderer.render(classNode);
                for (RendererListener listener : this.rendererListeners) {
                    listener.afterClass(cls);
                }
            }
            for (Map.Entry entry : this.entryPoints.entrySet()) {
                sourceWriter.append((String)entry.getKey()).ws().append("=").ws().appendMethodBody(((TeaVMEntryPoint)entry.getValue()).reference).append(";").softNewLine();
            }
            for (Map.Entry entry : this.exportedClasses.entrySet()) {
                sourceWriter.append((String)entry.getKey()).ws().append("=").ws().appendClass((String)entry.getValue()).append(";").softNewLine();
            }
            for (RendererListener rendererListener : this.rendererListeners) {
                rendererListener.complete();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO Error occured", e);
        }
    }

    private void devirtualize(ListableClassHolderSource classes, DependencyInfo dependency) {
        final Devirtualization devirtualization = new Devirtualization(dependency, classes);
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (final MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        devirtualization.apply(method);
                    }
                });
            }
        }
    }

    private void allocateRegisters(ListableClassHolderSource classes) {
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (final MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null || method.getProgram().basicBlockCount() <= 0) continue;
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        RegisterAllocator allocator = new RegisterAllocator();
                        Program program = ProgramUtils.copy(method.getProgram());
                        allocator.allocateRegisters(method, program);
                        method.setProgram(program);
                    }
                });
            }
        }
    }

    private void logBytecode(PrintWriter writer, ListableClassHolderSource classes) {
        for (String className : classes.getClassNames()) {
            ClassHolder classHolder = classes.get(className);
            this.printModifiers(writer, classHolder);
            writer.println("class " + className);
            for (MethodHolder method : classHolder.getMethods()) {
                this.logMethodBytecode(writer, method);
            }
        }
    }

    private void logMethodBytecode(PrintWriter writer, MethodHolder method) {
        writer.print("    ");
        this.printModifiers(writer, method);
        writer.print(method.getName() + "(");
        ValueType[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                writer.print(", ");
            }
            this.printType(writer, parameterTypes[i]);
        }
        writer.println(")");
        Program program = method.getProgram();
        if (program != null && program.basicBlockCount() > 0) {
            ListingBuilder builder = new ListingBuilder();
            writer.print(builder.buildListing(program, "        "));
            writer.print("        Register allocation:");
            for (int i = 0; i < program.variableCount(); ++i) {
                writer.print(i + ":" + program.variableAt(i).getRegister() + " ");
            }
            writer.println();
            writer.println();
            writer.flush();
        } else {
            writer.println();
        }
    }

    private void printType(PrintWriter writer, ValueType type) {
        if (type instanceof ValueType.Object) {
            writer.print(((ValueType.Object)type).getClassName());
        } else if (type instanceof ValueType.Array) {
            this.printType(writer, ((ValueType.Array)type).getItemType());
            writer.print("[]");
        } else if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    writer.print("boolean");
                    break;
                }
                case SHORT: {
                    writer.print("short");
                    break;
                }
                case BYTE: {
                    writer.print("byte");
                    break;
                }
                case CHARACTER: {
                    writer.print("char");
                    break;
                }
                case DOUBLE: {
                    writer.print("double");
                    break;
                }
                case FLOAT: {
                    writer.print("float");
                    break;
                }
                case INTEGER: {
                    writer.print("int");
                    break;
                }
                case LONG: {
                    writer.print("long");
                }
            }
        }
    }

    private void printModifiers(PrintWriter writer, ElementHolder element) {
        switch (element.getLevel()) {
            case PRIVATE: {
                writer.print("private ");
                break;
            }
            case PUBLIC: {
                writer.print("public ");
                break;
            }
            case PROTECTED: {
                writer.print("protected ");
                break;
            }
        }
        EnumSet<ElementModifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)ElementModifier.ABSTRACT)) {
            writer.print("abstract ");
        }
        if (modifiers.contains((Object)ElementModifier.FINAL)) {
            writer.print("final ");
        }
        if (modifiers.contains((Object)ElementModifier.STATIC)) {
            writer.print("static ");
        }
        if (modifiers.contains((Object)ElementModifier.NATIVE)) {
            writer.print("native ");
        }
    }

    public void build(File dir, String fileName) throws RenderingException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dir, fileName)), "UTF-8");){
            this.build(writer, new DirectoryBuildTarget(dir));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Platform does not support UTF-8", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    public void installPlugins() {
        for (TeaVMPlugin plugin : ServiceLoader.load(TeaVMPlugin.class, this.classLoader)) {
            plugin.install(this);
        }
    }
}

