/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import java.util.ArrayList;
import java.util.List;
import org.teavm.common.ConcurrentCachedMapper;
import org.teavm.common.Mapper;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;

class JavascriptProcessedClassSource
implements ClassHolderSource {
    private ClassHolderSource innerSource;
    private List<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
    private ConcurrentCachedMapper<String, ClassHolder> mapper = new ConcurrentCachedMapper<String, ClassHolder>(new Mapper<String, ClassHolder>(){

        @Override
        public ClassHolder map(String preimage) {
            return JavascriptProcessedClassSource.this.getTransformed(preimage);
        }
    });

    public JavascriptProcessedClassSource(ClassHolderSource innerSource) {
        this.innerSource = innerSource;
    }

    public void addTransformer(ClassHolderTransformer transformer) {
        this.transformers.add(transformer);
    }

    @Override
    public ClassHolder get(String name) {
        return this.mapper.map(name);
    }

    private ClassHolder getTransformed(String name) {
        ClassHolder cls = this.innerSource.get(name);
        if (cls != null) {
            this.transformClass(cls);
        }
        return cls;
    }

    private void transformClass(ClassHolder cls) {
        for (ClassHolderTransformer transformer : this.transformers) {
            transformer.transformClass(cls, this.innerSource);
        }
    }
}

