/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teavm.common.ConcurrentCachedMapper;
import org.teavm.common.Mapper;
import org.teavm.model.ClassHolder;
import org.teavm.parsing.ClassRefsRenamer;

public class ClasspathResourceMapper
implements Mapper<String, ClassHolder> {
    private static final String PACKAGE_PREFIX = "packagePrefix.";
    private static final String CLASS_PREFIX = "classPrefix.";
    private Mapper<String, ClassHolder> innerMapper;
    private List<Transformation> transformations = new ArrayList<Transformation>();
    private ClassRefsRenamer renamer;
    private Mapper<String, String> classNameMapper = new Mapper<String, String>(){

        @Override
        public String map(String preimage) {
            return ClasspathResourceMapper.this.renameClass(preimage);
        }
    };

    public ClasspathResourceMapper(ClassLoader classLoader, Mapper<String, ClassHolder> innerMapper) {
        this.innerMapper = innerMapper;
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/teavm.properties");
            HashMap<String, Transformation> transformationMap = new HashMap<String, Transformation>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Properties properties = new Properties();
                try (InputStream input = resource.openStream();){
                    properties.load(input);
                }
                this.loadProperties(properties, transformationMap);
            }
            this.transformations.addAll(transformationMap.values());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading resources", e);
        }
        this.renamer = new ClassRefsRenamer(new ConcurrentCachedMapper<String, String>(this.classNameMapper));
    }

    private void loadProperties(Properties properties, Map<String, Transformation> cache) {
        for (String propertyName : properties.stringPropertyNames()) {
            Transformation transformation;
            String packageName;
            if (propertyName.startsWith(PACKAGE_PREFIX)) {
                packageName = propertyName.substring(PACKAGE_PREFIX.length());
                transformation = this.getTransformation(cache, packageName);
                transformation.packagePrefix = properties.getProperty(propertyName) + ".";
                transformation.fullPrefix = transformation.packagePrefix + transformation.packageName;
                continue;
            }
            if (!propertyName.startsWith(CLASS_PREFIX)) continue;
            packageName = propertyName.substring(CLASS_PREFIX.length());
            transformation = this.getTransformation(cache, packageName);
            transformation.classPrefix = properties.getProperty(propertyName);
        }
    }

    private Transformation getTransformation(Map<String, Transformation> cache, String packageName) {
        Transformation transformation = cache.get(packageName);
        if (transformation == null) {
            transformation = new Transformation();
            transformation.packageName = packageName + ".";
            transformation.fullPrefix = packageName + ".";
            cache.put(packageName, transformation);
        }
        return transformation;
    }

    @Override
    public ClassHolder map(String name) {
        for (Transformation transformation : this.transformations) {
            if (!name.startsWith(transformation.packageName)) continue;
            int index = name.lastIndexOf(46);
            String className = name.substring(index + 1);
            String packageName = index > 0 ? name.substring(0, index) : "";
            ClassHolder classHolder = this.innerMapper.map(transformation.packagePrefix + packageName + "." + transformation.classPrefix + className);
            if (classHolder != null) {
                classHolder = this.renamer.rename(classHolder);
            }
            return classHolder;
        }
        return this.innerMapper.map(name);
    }

    private String renameClass(String name) {
        for (Transformation transformation : this.transformations) {
            if (!name.startsWith(transformation.fullPrefix)) continue;
            int index = name.lastIndexOf(46);
            String className = name.substring(index + 1);
            String packageName = name.substring(0, index);
            if (!className.startsWith(transformation.classPrefix)) continue;
            return packageName.substring(transformation.packagePrefix.length()) + "." + className.substring(transformation.classPrefix.length());
        }
        return name;
    }

    private static class Transformation {
        String packageName;
        String packagePrefix = "";
        String fullPrefix = "";
        String classPrefix = "";

        private Transformation() {
        }
    }
}

