/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import org.teavm.common.Graph;
import org.teavm.model.BasicBlock;
import org.teavm.model.MethodReader;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.optimization.MethodOptimization;
import org.teavm.optimization.VariableEscapeAnalyzer;
import org.teavm.optimization.VariableUsageGraphBuilder;

public class UnusedVariableElimination
implements MethodOptimization {
    @Override
    public void optimize(MethodReader method, Program program) {
        if (method.getProgram() == null) {
            return;
        }
        Graph graph = VariableUsageGraphBuilder.build(program);
        boolean[] escaping = VariableEscapeAnalyzer.findEscapingVariables(program);
        boolean[] used = new boolean[escaping.length];
        int[] stack = new int[graph.size() * 2];
        int top = 0;
        for (int i = 0; i < used.length; ++i) {
            if (!escaping[i]) continue;
            stack[top++] = i;
        }
        while (top > 0) {
            int var;
            if (used[var = stack[--top]]) continue;
            used[var] = true;
            for (int arg : graph.incomingEdges(var)) {
                if (used[arg]) continue;
                stack[top++] = arg;
            }
        }
        InstructionOptimizer insnOptimizer = new InstructionOptimizer(used);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            int j;
            BasicBlock block = program.basicBlockAt(i);
            for (j = 0; j < block.getInstructions().size(); ++j) {
                insnOptimizer.eliminate = false;
                block.getInstructions().get(j).acceptVisitor(insnOptimizer);
                if (!insnOptimizer.eliminate) continue;
                block.getInstructions().remove(j--);
            }
            for (j = 0; j < block.getPhis().size(); ++j) {
                Phi phi = block.getPhis().get(j);
                if (used[phi.getReceiver().getIndex()]) continue;
                block.getPhis().remove(j--);
            }
        }
    }

    private static class InstructionOptimizer
    implements InstructionVisitor {
        private boolean[] used;
        boolean eliminate;

        public InstructionOptimizer(boolean[] used) {
            this.used = used;
        }

        private void requestUsage(Variable var) {
            if (!this.used[var.getIndex()]) {
                this.eliminate = true;
            }
        }

        @Override
        public void visit(EmptyInstruction insn) {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(BinaryInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(NegateInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(CastInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(BranchingInstruction insn) {
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
        }

        @Override
        public void visit(JumpInstruction insn) {
        }

        @Override
        public void visit(SwitchInstruction insn) {
        }

        @Override
        public void visit(ExitInstruction insn) {
        }

        @Override
        public void visit(RaiseInstruction insn) {
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(ConstructInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(PutFieldInstruction insn) {
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(GetElementInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(PutElementInstruction insn) {
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getReceiver() != null && !this.used[insn.getReceiver().getIndex()]) {
                insn.setReceiver(null);
            }
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(InitClassInstruction insn) {
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }
    }
}

