/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.common.DisjointSet;
import org.teavm.common.MutableGraphEdge;
import org.teavm.common.MutableGraphNode;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.util.BasicBlockMapper;
import org.teavm.model.util.GraphColorer;
import org.teavm.model.util.InstructionVariableMapper;
import org.teavm.model.util.InterferenceGraphBuilder;
import org.teavm.model.util.LivenessAnalyzer;

public class RegisterAllocator {
    public void allocateRegisters(MethodReader method, Program program) {
        this.insertPhiArgumentsCopies(program);
        InterferenceGraphBuilder interferenceBuilder = new InterferenceGraphBuilder();
        LivenessAnalyzer liveness = new LivenessAnalyzer();
        liveness.analyze(program);
        List<MutableGraphNode> interferenceGraph = interferenceBuilder.build(program, method.parameterCount(), liveness);
        DisjointSet congruenceClasses = this.buildPhiCongruenceClasses(program);
        RegisterAllocator.joinClassNodes(interferenceGraph, congruenceClasses);
        this.removeRedundantCopies(program, interferenceGraph, congruenceClasses);
        int[] classArray = congruenceClasses.pack(program.variableCount());
        this.renameVariables(program, classArray);
        int[] colors = new int[program.variableCount()];
        Arrays.fill(colors, -1);
        for (int i = 0; i <= method.parameterCount(); ++i) {
            colors[i] = i;
        }
        this.renameInterferenceGraph(interferenceGraph, congruenceClasses, classArray);
        GraphColorer colorer = new GraphColorer();
        colorer.colorize(interferenceGraph, colors);
        for (int i = 0; i < colors.length; ++i) {
            program.variableAt(i).setRegister(colors[i]);
        }
    }

    private static void joinClassNodes(List<MutableGraphNode> graph, DisjointSet classes) {
        int sz = graph.size();
        for (int i = 0; i < sz; ++i) {
            int cls = classes.find(i);
            while (cls >= graph.size()) {
                graph.add(new MutableGraphNode(graph.size()));
            }
            if (cls == i) continue;
            for (MutableGraphEdge edge : graph.get(i).getEdges().toArray(new MutableGraphEdge[0])) {
                if (edge.getFirst() == graph.get(i)) {
                    edge.setFirst(graph.get(cls));
                }
                if (edge.getSecond() != graph.get(i)) continue;
                edge.setSecond(graph.get(cls));
            }
            graph.set(i, graph.get(cls));
        }
    }

    private void insertPhiArgumentsCopies(Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            HashMap<BasicBlock, BasicBlock> blockMap = new HashMap<BasicBlock, BasicBlock>();
            for (Phi phi : program.basicBlockAt(i).getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    if (this.isExceptionHandler(incoming)) continue;
                    this.insertCopy(incoming, blockMap);
                }
            }
            for (Phi phi : program.basicBlockAt(i).getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    if (this.isExceptionHandler(incoming)) continue;
                    this.insertCopy(incoming, blockMap);
                }
            }
        }
    }

    private void insertCopy(Incoming incoming, Map<BasicBlock, BasicBlock> blockMap) {
        final Phi phi = incoming.getPhi();
        Program program = phi.getBasicBlock().getProgram();
        AssignInstruction copyInstruction = new AssignInstruction();
        Variable firstCopy = program.createVariable();
        copyInstruction.setReceiver(firstCopy);
        copyInstruction.setAssignee(incoming.getValue());
        BasicBlock source = blockMap.get(incoming.getSource());
        if (source == null) {
            source = incoming.getSource();
        } else {
            incoming.setSource(source);
        }
        if (!(incoming.getSource().getLastInstruction() instanceof JumpInstruction)) {
            final BasicBlock copyBlock = program.createBasicBlock();
            JumpInstruction jumpInstruction = new JumpInstruction();
            jumpInstruction.setTarget(phi.getBasicBlock());
            copyBlock.getInstructions().add(jumpInstruction);
            incoming.getSource().getLastInstruction().acceptVisitor(new BasicBlockMapper(){

                @Override
                protected BasicBlock map(BasicBlock block) {
                    if (block == phi.getBasicBlock()) {
                        return copyBlock;
                    }
                    return block;
                }
            });
            blockMap.put(source, copyBlock);
            incoming.setSource(copyBlock);
            source = copyBlock;
        }
        source.getInstructions().add(source.getInstructions().size() - 1, copyInstruction);
        incoming.setValue(copyInstruction.getReceiver());
    }

    private boolean isExceptionHandler(Incoming incoming) {
        for (TryCatchBlock tryCatch : incoming.getSource().getTryCatchBlocks()) {
            if (tryCatch.getExceptionVariable() != incoming.getValue()) continue;
            return true;
        }
        return false;
    }

    private void removeRedundantCopies(Program program, List<MutableGraphNode> interferenceGraph, DisjointSet congruenceClasses) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (int j = 0; j < block.getInstructions().size(); ++j) {
                Instruction insn = block.getInstructions().get(j);
                if (!(insn instanceof AssignInstruction)) continue;
                AssignInstruction assignment = (AssignInstruction)insn;
                boolean interfere = false;
                int copyClass = congruenceClasses.find(assignment.getReceiver().getIndex());
                int origClass = congruenceClasses.find(assignment.getAssignee().getIndex());
                for (MutableGraphEdge edge : interferenceGraph.get(origClass).getEdges()) {
                    int neighbour;
                    if (edge.getFirst() == edge.getSecond() || (neighbour = congruenceClasses.find(edge.getSecond().getTag())) != copyClass && neighbour != origClass) continue;
                    interfere = true;
                    break;
                }
                if (interfere) continue;
                int newClass = congruenceClasses.union(copyClass, origClass);
                block.getInstructions().set(j, new EmptyInstruction());
                if (newClass == interferenceGraph.size()) {
                    MutableGraphNode newNode = new MutableGraphNode(interferenceGraph.size());
                    interferenceGraph.add(newNode);
                }
                for (MutableGraphEdge edge : interferenceGraph.get(origClass).getEdges().toArray(new MutableGraphEdge[0])) {
                    if (edge.getFirst() == interferenceGraph.get(origClass)) {
                        edge.setFirst(interferenceGraph.get(newClass));
                    }
                    if (edge.getSecond() != interferenceGraph.get(origClass)) continue;
                    edge.setSecond(interferenceGraph.get(newClass));
                }
                for (MutableGraphEdge edge : interferenceGraph.get(copyClass).getEdges().toArray(new MutableGraphEdge[0])) {
                    if (edge.getFirst() == interferenceGraph.get(copyClass)) {
                        edge.setFirst(interferenceGraph.get(newClass));
                    }
                    if (edge.getSecond() != interferenceGraph.get(copyClass)) continue;
                    edge.setSecond(interferenceGraph.get(newClass));
                }
                interferenceGraph.set(copyClass, interferenceGraph.get(newClass));
                interferenceGraph.set(origClass, interferenceGraph.get(newClass));
            }
        }
    }

    private void renameVariables(final Program program, final int[] varMap) {
        InstructionVariableMapper mapper = new InstructionVariableMapper(){

            @Override
            protected Variable map(Variable var) {
                return program.variableAt(varMap[var.getIndex()]);
            }
        };
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block.getInstructions()) {
                insn.acceptVisitor(mapper);
            }
            for (Phi phi : block.getPhis()) {
                phi.setReceiver(program.variableAt(varMap[phi.getReceiver().getIndex()]));
                for (Incoming incoming : phi.getIncomings()) {
                    incoming.setValue(program.variableAt(varMap[incoming.getValue().getIndex()]));
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                tryCatch.setExceptionVariable(program.variableAt(varMap[tryCatch.getExceptionVariable().getIndex()]));
            }
        }
    }

    private void renameInterferenceGraph(List<MutableGraphNode> graph, DisjointSet classes, int[] varMap) {
        ArrayList<MutableGraphNode> newGraph = new ArrayList<MutableGraphNode>();
        for (int i = 0; i < graph.size(); ++i) {
            int mapped = varMap[i];
            while (newGraph.size() <= mapped) {
                newGraph.add(null);
            }
            if (newGraph.get(mapped) != null) continue;
            int cls = classes.find(i);
            newGraph.set(mapped, graph.get(cls));
            graph.get(cls).setTag(mapped);
        }
        graph.clear();
        graph.addAll(newGraph);
    }

    private DisjointSet buildPhiCongruenceClasses(Program program) {
        int i;
        DisjointSet classes = new DisjointSet();
        for (i = 0; i < program.variableCount(); ++i) {
            classes.create();
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    classes.union(phi.getReceiver().getIndex(), incoming.getValue().getIndex());
                }
            }
        }
        return classes;
    }
}

