/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.teavm.common.GraphIndexer;
import org.teavm.javascript.Decompiler;
import org.teavm.javascript.ast.BinaryOperation;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.UnaryOperation;
import org.teavm.javascript.ast.UnwrapArrayExpr;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;
import org.teavm.model.instructions.UnwrapArrayInstruction;

class StatementGenerator
implements InstructionVisitor {
    private int lastSwitchId;
    List<Statement> statements = new ArrayList<Statement>();
    GraphIndexer indexer;
    BasicBlock nextBlock;
    BasicBlock currentBlock;
    Decompiler.Block[] blockMap;
    Program program;
    ClassHolderSource classSource;

    StatementGenerator() {
    }

    @Override
    public void visit(EmptyInstruction insn) {
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(NullConstantInstruction insn) {
        this.assign(Expr.constant(null), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(IntegerConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(LongConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(FloatConstantInstruction insn) {
        this.assign(Expr.constant(Float.valueOf(insn.getConstant())), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(DoubleConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(StringConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(BinaryInstruction insn) {
        int first = insn.getFirstOperand().getIndex();
        int second = insn.getSecondOperand().getIndex();
        int result = insn.getReceiver().getIndex();
        block0 : switch (insn.getOperation()) {
            case ADD: {
                switch (insn.getOperandType()) {
                    case INT: {
                        this.intBinary(first, second, result, BinaryOperation.ADD);
                        break block0;
                    }
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.ADD_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.ADD);
                break;
            }
            case SUBTRACT: {
                switch (insn.getOperandType()) {
                    case INT: {
                        this.intBinary(first, second, result, BinaryOperation.SUBTRACT);
                        break block0;
                    }
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.SUBTRACT_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.SUBTRACT);
                break;
            }
            case MULTIPLY: {
                switch (insn.getOperandType()) {
                    case INT: {
                        this.intBinary(first, second, result, BinaryOperation.MULTIPLY);
                        break block0;
                    }
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.MULTIPLY_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.MULTIPLY);
                break;
            }
            case DIVIDE: {
                switch (insn.getOperandType()) {
                    case INT: {
                        this.intBinary(first, second, result, BinaryOperation.DIVIDE);
                        break block0;
                    }
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.DIVIDE_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.DIVIDE);
                break;
            }
            case MODULO: {
                switch (insn.getOperandType()) {
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.MODULO_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.MODULO);
                break;
            }
            case COMPARE: {
                switch (insn.getOperandType()) {
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.COMPARE_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.COMPARE);
                break;
            }
            case AND: {
                switch (insn.getOperandType()) {
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.BITWISE_AND_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.BITWISE_AND);
                break;
            }
            case OR: {
                switch (insn.getOperandType()) {
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.BITWISE_OR_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.BITWISE_OR);
                break;
            }
            case XOR: {
                switch (insn.getOperandType()) {
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.BITWISE_XOR_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.BITWISE_XOR);
                break;
            }
            case SHIFT_LEFT: {
                switch (insn.getOperandType()) {
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.LEFT_SHIFT_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.LEFT_SHIFT);
                break;
            }
            case SHIFT_RIGHT: {
                switch (insn.getOperandType()) {
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.RIGHT_SHIFT_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.RIGHT_SHIFT);
                break;
            }
            case SHIFT_RIGHT_UNSIGNED: {
                switch (insn.getOperandType()) {
                    case LONG: {
                        this.binary(first, second, result, BinaryOperation.UNSIGNED_RIGHT_SHIFT_LONG);
                        break block0;
                    }
                }
                this.binary(first, second, result, BinaryOperation.UNSIGNED_RIGHT_SHIFT);
            }
        }
    }

    @Override
    public void visit(NegateInstruction insn) {
        switch (insn.getOperandType()) {
            case INT: {
                this.assign(this.castToInteger(Expr.unary(UnaryOperation.NEGATE, Expr.var(insn.getOperand().getIndex()))), insn.getReceiver().getIndex());
                break;
            }
            case LONG: {
                this.assign(Expr.unary(UnaryOperation.NEGATE_LONG, Expr.var(insn.getOperand().getIndex())), insn.getReceiver().getIndex());
                break;
            }
            default: {
                this.assign(Expr.unary(UnaryOperation.NEGATE, Expr.var(insn.getOperand().getIndex())), insn.getReceiver().getIndex());
            }
        }
    }

    @Override
    public void visit(AssignInstruction insn) {
        this.statements.add(Statement.assign(Expr.var(insn.getReceiver().getIndex()), Expr.var(insn.getAssignee().getIndex())));
    }

    @Override
    public void visit(CastInstruction insn) {
        this.assign(Expr.var(insn.getValue().getIndex()), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(CastNumberInstruction insn) {
        Expr value = Expr.var(insn.getValue().getIndex());
        block0 : switch (insn.getTargetType()) {
            case INT: {
                switch (insn.getSourceType()) {
                    case DOUBLE: 
                    case FLOAT: {
                        value = this.castToInteger(value);
                        break block0;
                    }
                    case LONG: {
                        value = this.castFromLong(value);
                        break block0;
                    }
                }
                break;
            }
            case LONG: {
                switch (insn.getSourceType()) {
                    case INT: {
                        value = this.castIntToLong(value);
                        break block0;
                    }
                    case DOUBLE: 
                    case FLOAT: {
                        value = this.castToLong(value);
                        break block0;
                    }
                }
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                if (insn.getSourceType() != NumericOperandType.LONG) break;
                value = this.castFromLong(value);
                break;
            }
        }
        this.assign(value, insn.getReceiver().getIndex());
    }

    @Override
    public void visit(CastIntegerInstruction insn) {
        Expr value = Expr.var(insn.getValue().getIndex());
        block0 : switch (insn.getDirection()) {
            case FROM_INTEGER: {
                switch (insn.getTargetType()) {
                    case BYTE: {
                        value = Expr.binary(BinaryOperation.BITWISE_AND, value, Expr.constant(255));
                        break;
                    }
                    case SHORT: 
                    case CHARACTER: {
                        value = Expr.binary(BinaryOperation.BITWISE_AND, value, Expr.constant(65535));
                    }
                }
                break;
            }
            case TO_INTEGER: {
                switch (insn.getTargetType()) {
                    case BYTE: {
                        value = Expr.unary(UnaryOperation.BYTE_TO_INT, value);
                        break block0;
                    }
                    case SHORT: {
                        value = Expr.unary(UnaryOperation.SHORT_TO_INT, value);
                        break block0;
                    }
                }
            }
        }
        this.assign(value, insn.getReceiver().getIndex());
    }

    @Override
    public void visit(BranchingInstruction insn) {
        switch (insn.getCondition()) {
            case EQUAL: {
                this.branch(this.compare(BinaryOperation.EQUALS, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case NOT_EQUAL: {
                this.branch(this.compare(BinaryOperation.NOT_EQUALS, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case GREATER: {
                this.branch(this.compare(BinaryOperation.GREATER, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case GREATER_OR_EQUAL: {
                this.branch(this.compare(BinaryOperation.GREATER_OR_EQUALS, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case LESS: {
                this.branch(this.compare(BinaryOperation.LESS, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case LESS_OR_EQUAL: {
                this.branch(this.compare(BinaryOperation.LESS_OR_EQUALS, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case NOT_NULL: {
                this.branch(Expr.binary(BinaryOperation.STRICT_NOT_EQUALS, Expr.var(insn.getOperand().getIndex()), Expr.constant(null)), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case NULL: {
                this.branch(Expr.binary(BinaryOperation.STRICT_EQUALS, Expr.var(insn.getOperand().getIndex()), Expr.constant(null)), insn.getConsequent(), insn.getAlternative());
            }
        }
    }

    @Override
    public void visit(BinaryBranchingInstruction insn) {
        int a = insn.getFirstOperand().getIndex();
        int b = insn.getSecondOperand().getIndex();
        BasicBlock consequent = insn.getConsequent();
        BasicBlock alternative = insn.getAlternative();
        switch (insn.getCondition()) {
            case EQUAL: {
                this.branch(Expr.binary(BinaryOperation.EQUALS, Expr.var(a), Expr.var(b)), consequent, alternative);
                break;
            }
            case REFERENCE_EQUAL: {
                this.branch(Expr.binary(BinaryOperation.STRICT_EQUALS, Expr.var(a), Expr.var(b)), consequent, alternative);
                break;
            }
            case NOT_EQUAL: {
                this.branch(Expr.binary(BinaryOperation.NOT_EQUALS, Expr.var(a), Expr.var(b)), consequent, alternative);
                break;
            }
            case REFERENCE_NOT_EQUAL: {
                this.branch(Expr.binary(BinaryOperation.STRICT_NOT_EQUALS, Expr.var(a), Expr.var(b)), consequent, alternative);
            }
        }
    }

    @Override
    public void visit(JumpInstruction insn) {
        Statement stmt = this.generateJumpStatement(insn.getTarget());
        if (stmt != null) {
            this.statements.add(stmt);
        }
    }

    @Override
    public void visit(SwitchInstruction insn) {
        SwitchStatement stmt = new SwitchStatement();
        stmt.setId("sblock" + this.lastSwitchId++);
        stmt.setValue(Expr.var(insn.getCondition().getIndex()));
        HashMap<Integer, ArrayList<Integer>> switchMap = new HashMap<Integer, ArrayList<Integer>>();
        for (int i = 0; i < insn.getEntries().size(); ++i) {
            SwitchTableEntry entry = insn.getEntries().get(i);
            ArrayList<Integer> conditions = (ArrayList<Integer>)switchMap.get(entry.getTarget().getIndex());
            if (conditions == null) {
                conditions = new ArrayList<Integer>();
                switchMap.put(entry.getTarget().getIndex(), conditions);
            }
            conditions.add(entry.getCondition());
        }
        ArrayList targets = new ArrayList(switchMap.keySet());
        Collections.sort(targets);
        Iterator i$ = targets.iterator();
        while (i$.hasNext()) {
            int target = (Integer)i$.next();
            SwitchClause clause = new SwitchClause();
            List conditionList = (List)switchMap.get(target);
            int[] conditions = new int[conditionList.size()];
            for (int i = 0; i < conditionList.size(); ++i) {
                conditions[i] = (Integer)conditionList.get(i);
            }
            clause.setConditions(conditions);
            Statement jumpStmt = this.generateJumpStatement(stmt, target);
            if (jumpStmt != null) {
                clause.getBody().add(jumpStmt);
            }
            stmt.getClauses().add(clause);
        }
        Statement breakStmt = this.generateJumpStatement(insn.getDefaultTarget());
        if (breakStmt != null) {
            stmt.getDefaultClause().add(breakStmt);
        }
        this.statements.add(stmt);
    }

    @Override
    public void visit(ExitInstruction insn) {
        this.statements.add(Statement.exitFunction(insn.getValueToReturn() != null ? Expr.var(insn.getValueToReturn().getIndex()) : null));
    }

    @Override
    public void visit(RaiseInstruction insn) {
        ThrowStatement stmt = new ThrowStatement();
        stmt.setException(Expr.var(insn.getException().getIndex()));
        this.statements.add(stmt);
    }

    @Override
    public void visit(ConstructArrayInstruction insn) {
        this.assign(Expr.createArray(insn.getItemType(), Expr.var(insn.getSize().getIndex())), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(ConstructInstruction insn) {
        this.assign(Expr.createObject(insn.getType()), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(ConstructMultiArrayInstruction insn) {
        Expr[] dimensionExprs = new Expr[insn.getDimensions().size()];
        for (int i = 0; i < dimensionExprs.length; ++i) {
            dimensionExprs[i] = Expr.var(insn.getDimensions().get(i).getIndex());
        }
        this.assign(Expr.createArray(insn.getItemType(), dimensionExprs), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(GetFieldInstruction insn) {
        if (insn.getInstance() != null) {
            this.statements.add(Statement.assign(Expr.var(insn.getReceiver().getIndex()), Expr.qualify(Expr.var(insn.getInstance().getIndex()), insn.getField())));
        } else {
            Expr fieldExpr = Expr.qualify(Expr.staticClass(ValueType.object(insn.getField().getClassName())), insn.getField());
            this.statements.add(Statement.assign(Expr.var(insn.getReceiver().getIndex()), fieldExpr));
        }
    }

    @Override
    public void visit(PutFieldInstruction insn) {
        if (insn.getInstance() != null) {
            this.statements.add(Statement.assign(Expr.qualify(Expr.var(insn.getInstance().getIndex()), insn.getField()), Expr.var(insn.getValue().getIndex())));
        } else {
            Expr fieldExpr = Expr.qualify(Expr.staticClass(ValueType.object(insn.getField().getClassName())), insn.getField());
            this.statements.add(Statement.assign(fieldExpr, Expr.var(insn.getValue().getIndex())));
        }
    }

    @Override
    public void visit(ArrayLengthInstruction insn) {
        this.assign(Expr.unary(UnaryOperation.LENGTH, Expr.var(insn.getArray().getIndex())), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(UnwrapArrayInstruction insn) {
        UnwrapArrayExpr unwrapExpr = new UnwrapArrayExpr(insn.getElementType());
        unwrapExpr.setArray(Expr.var(insn.getArray().getIndex()));
        this.assign(unwrapExpr, insn.getReceiver().getIndex());
    }

    @Override
    public void visit(CloneArrayInstruction insn) {
        MethodDescriptor cloneMethodDesc = new MethodDescriptor("clone", ValueType.object("java.lang.Object"));
        MethodReference cloneMethod = new MethodReference("java.lang.Object", cloneMethodDesc);
        this.assign(Expr.invoke(cloneMethod, Expr.var(insn.getArray().getIndex()), new Expr[0]), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(GetElementInstruction insn) {
        this.assign(Expr.subscript(Expr.var(insn.getArray().getIndex()), Expr.var(insn.getIndex().getIndex())), insn.getReceiver().getIndex());
    }

    @Override
    public void visit(PutElementInstruction insn) {
        this.statements.add(Statement.assign(Expr.subscript(Expr.var(insn.getArray().getIndex()), Expr.var(insn.getIndex().getIndex())), Expr.var(insn.getValue().getIndex())));
    }

    @Override
    public void visit(InvokeInstruction insn) {
        Expr[] exprArgs = new Expr[insn.getMethod().getParameterTypes().length];
        for (int i = 0; i < insn.getArguments().size(); ++i) {
            exprArgs[i] = Expr.var(insn.getArguments().get(i).getIndex());
        }
        Expr invocationExpr = insn.getInstance() != null ? (insn.getType() == InvocationType.VIRTUAL ? Expr.invoke(insn.getMethod(), Expr.var(insn.getInstance().getIndex()), exprArgs) : Expr.invokeSpecial(insn.getMethod(), Expr.var(insn.getInstance().getIndex()), exprArgs)) : Expr.invokeStatic(insn.getMethod(), exprArgs);
        if (insn.getReceiver() != null) {
            this.assign(invocationExpr, insn.getReceiver().getIndex());
        } else {
            this.statements.add(Statement.assign(null, invocationExpr));
        }
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        this.assign(Expr.instanceOf(Expr.var(insn.getValue().getIndex()), insn.getType()), insn.getReceiver().getIndex());
    }

    private void assign(Expr source, int target) {
        this.statements.add(Statement.assign(Expr.var(target), source));
    }

    private Expr castToInteger(Expr value) {
        return Expr.binary(BinaryOperation.BITWISE_OR, value, Expr.constant(0));
    }

    private Expr castToLong(Expr value) {
        return Expr.unary(UnaryOperation.NUM_TO_LONG, value);
    }

    private Expr castIntToLong(Expr value) {
        return Expr.unary(UnaryOperation.INT_TO_LONG, value);
    }

    private Expr castFromLong(Expr value) {
        return Expr.unary(UnaryOperation.LONG_TO_NUM, value);
    }

    private void binary(int first, int second, int result, BinaryOperation op) {
        this.assign(Expr.binary(op, Expr.var(first), Expr.var(second)), result);
    }

    private void intBinary(int first, int second, int result, BinaryOperation op) {
        this.assign(this.castToInteger(Expr.binary(op, Expr.var(first), Expr.var(second))), result);
    }

    Statement generateJumpStatement(BasicBlock target) {
        if (this.nextBlock == target) {
            return null;
        }
        Decompiler.Block block = this.blockMap[target.getIndex()];
        if (target.getIndex() == this.indexer.nodeAt(block.end)) {
            BreakStatement breakStmt = new BreakStatement();
            breakStmt.setTarget(block.statement);
            return breakStmt;
        }
        ContinueStatement contStmt = new ContinueStatement();
        contStmt.setTarget(block.statement);
        return contStmt;
    }

    private Statement generateJumpStatement(SwitchStatement stmt, int target) {
        Statement body = this.generateJumpStatement(this.program.basicBlockAt(target));
        if (body == null) {
            BreakStatement breakStmt = new BreakStatement();
            breakStmt.setTarget(stmt);
            body = breakStmt;
        }
        return body;
    }

    private void branch(Expr condition, BasicBlock consequentBlock, BasicBlock alternativeBlock) {
        Statement consequent = this.generateJumpStatement(consequentBlock);
        Statement alternative = this.generateJumpStatement(alternativeBlock);
        this.statements.add(Statement.cond(condition, consequent != null ? Arrays.asList(consequent) : Collections.emptyList(), alternative != null ? Arrays.asList(alternative) : Collections.emptyList()));
    }

    private Expr compare(BinaryOperation op, Variable value) {
        return Expr.binary(op, Expr.var(value.getIndex()), Expr.constant(0));
    }

    @Override
    public void visit(InitClassInstruction insn) {
        this.statements.add(Statement.initClass(insn.getClassName()));
    }

    @Override
    public void visit(NullCheckInstruction insn) {
        this.assign(Expr.unary(UnaryOperation.NULL_CHECK, Expr.var(insn.getValue().getIndex())), insn.getReceiver().getIndex());
    }
}

